/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.EUMeterUIFactory;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverEUMeter
extends Cover {
    private EnergyType type;
    private boolean inverted;
    private long threshold;

    public CoverEUMeter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
        this.initializeData(context.getCoverInitializer());
    }

    public EnergyType getType() {
        return this.type;
    }

    public CoverEUMeter setType(EnergyType type) {
        this.type = type;
        return this;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public CoverEUMeter setInverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public CoverEUMeter setThresdhold(long threshold) {
        this.threshold = threshold;
        return this;
    }

    public int getNum() {
        return this.type.ordinal() * 2 + (this.inverted ? 1 : 0);
    }

    public void setNum(int num) {
        this.type = EnergyType.getEnergyType(num / 2);
        this.inverted = num % 2 == 1;
    }

    @Override
    protected void initializeData() {
        this.type = EnergyType.UNIVERSAL_STORAGE;
        this.inverted = false;
        this.threshold = 0L;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        int typeOrdinal = tag.func_74762_e("typeOrdinal");
        this.type = EnergyType.getEnergyType(typeOrdinal);
        this.inverted = tag.func_74767_n("inverted");
        this.threshold = tag.func_74763_f("threshold");
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        int typeOrdinal = byteData.readInt();
        this.type = EnergyType.getEnergyType(typeOrdinal);
        this.inverted = byteData.readBoolean();
        this.threshold = byteData.readLong();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("typeOrdinal", this.type.ordinal());
        tag.func_74757_a("inverted", this.inverted);
        tag.func_74772_a("threshold", this.threshold);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.type.ordinal());
        byteBuf.writeBoolean(this.inverted);
        byteBuf.writeLong(this.threshold);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        long stored = this.type.getTileEntityStoredEnergy(coverable);
        long capacity = this.type.getTileEntityEnergyCapacity(coverable);
        byte redstoneSignal = stored == 0L ? (byte)0 : (stored >= capacity ? (byte)15 : (byte)((byte)(1L + 14L * stored / capacity)));
        if (this.inverted) {
            redstoneSignal = (byte)(15 - redstoneSignal);
        }
        if (this.threshold > 0L) {
            if (this.inverted && stored >= this.threshold) {
                redstoneSignal = 0;
            } else if (!this.inverted && stored < this.threshold) {
                redstoneSignal = 0;
            }
        }
        coverable.setOutputRedstoneSignal(this.coverSide, redstoneSignal);
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int num = (this.getNum() + (aPlayer.func_70093_af() ? -1 : 1) + EnergyType.values().length * 2) % (EnergyType.values().length * 2);
        switch (num) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("031", "Normal Universal Storage"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("032", "Inverted Universal Storage"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("033", "Normal Electricity Storage"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("034", "Inverted Electricity Storage"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("035", "Normal Steam Storage"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("036", "Inverted Steam Storage"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("037", "Normal Average Electric Input"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("038", "Inverted Average Electric Input"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("039", "Normal Average Electric Output"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("040", "Inverted Average Electric Output"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("041", "Normal Electricity Storage(Including Batteries)"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("042", "Inverted Electricity Storage(Including Batteries)"));
            }
        }
        this.setNum(num);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new EUMeterUIFactory(buildContext).createWindow();
    }

    public static enum EnergyType {
        UNIVERSAL_STORAGE(GTUtility.trans("301", "Universal"), GTUtility.trans("256", "Universal Storage"), IBasicEnergyContainer::getUniversalEnergyStored, IBasicEnergyContainer::getUniversalEnergyCapacity),
        ELECTRICITY_STORAGE(GTUtility.trans("302", "Int. EU"), GTUtility.trans("257", "Electricity Storage"), IBasicEnergyContainer::getStoredEU, IBasicEnergyContainer::getEUCapacity),
        STEAM_STORAGE(GTUtility.trans("303", "Steam"), GTUtility.trans("258", "Steam Storage"), IBasicEnergyContainer::getStoredSteam, IBasicEnergyContainer::getSteamCapacity),
        AVERAGE_ELECTRIC_INPUT(GTUtility.trans("304", "Avg. Input"), GTUtility.trans("259", "Average Electric Input"), IBasicEnergyContainer::getAverageElectricInput, te -> te.getInputVoltage() * te.getInputAmperage()),
        AVERAGE_ELECTRIC_OUTPUT(GTUtility.trans("305", "Avg. Output"), GTUtility.trans("260", "Average Electric Output"), IBasicEnergyContainer::getAverageElectricOutput, te -> te.getOutputVoltage() * te.getOutputAmperage()),
        ELECTRICITY_STORAGE_INCLUDING_BATTERIES(GTUtility.trans("306", "EU stored"), GTUtility.trans("261", "Electricity Storage(Including Batteries)"), te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEBasicBatteryBuffer) {
                MTEBasicBatteryBuffer buffer = (MTEBasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[0];
            }
            return te.getStoredEU();
        }, te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEBasicBatteryBuffer) {
                MTEBasicBatteryBuffer buffer = (MTEBasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[1];
            }
            return te.getEUCapacity();
        });

        private final String title;
        private final String tooltip;
        private final Function<ICoverable, Long> getTileEntityStoredEnergyFunc;
        private final Function<ICoverable, Long> getTileEntityEnergyCapacityFunc;

        private EnergyType(String title, String tooltip, Function<ICoverable, Long> getTileEntityStoredEnergyFunc, Function<ICoverable, Long> getTileEntityEnergyCapacityFunc) {
            this.title = title;
            this.tooltip = tooltip;
            this.getTileEntityStoredEnergyFunc = getTileEntityStoredEnergyFunc;
            this.getTileEntityEnergyCapacityFunc = getTileEntityEnergyCapacityFunc;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public long getTileEntityStoredEnergy(ICoverable coverable) {
            return this.getTileEntityStoredEnergyFunc.apply(coverable);
        }

        public long getTileEntityEnergyCapacity(ICoverable coverable) {
            return this.getTileEntityEnergyCapacityFunc.apply(coverable);
        }

        public EnergyType getNext() {
            return EnergyType.values()[(this.ordinal() + 1) % EnergyType.values().length];
        }

        public static EnergyType getEnergyType(int ordinal) {
            if (ordinal < 0 || EnergyType.values().length <= ordinal) {
                ordinal = 0;
            }
            return EnergyType.values()[ordinal];
        }
    }
}

