/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.ConveyorUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverConveyor
extends CoverLegacyData {
    public final int mTickRate;
    private final int mMaxStacks;

    public CoverConveyor(CoverContext context, int aTickRate, int maxStacks, ITexture coverTexture) {
        super(context, coverTexture);
        this.mTickRate = aTickRate;
        this.mMaxStacks = maxStacks;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        IMachineProgress machine;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (this.coverData % 6 > 1 && coverable instanceof IMachineProgress && (machine = (IMachineProgress)((Object)coverable)).isAllowedToWork() != this.coverData % 6 < 4) {
            return;
        }
        TileEntity tTileEntity = coverable.getTileEntityAtSide(this.coverSide);
        ICoverable fromEntity = this.coverData % 2 == 0 ? coverable : tTileEntity;
        ICoverable toEntity = this.coverData % 2 != 0 ? coverable : tTileEntity;
        ForgeDirection fromSide = this.coverData % 2 != 0 ? this.coverSide.getOpposite() : this.coverSide;
        ForgeDirection toSide = this.coverData % 2 == 0 ? this.coverSide.getOpposite() : this.coverSide;
        GTUtility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1, this.mMaxStacks);
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 12;
        if (this.coverData < 0) {
            this.coverData = 11;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("006", "Export"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("007", "Import"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("008", "Export (conditional)"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("009", "Import (conditional)"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("010", "Export (invert cond)"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("011", "Import (invert cond)"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("012", "Export allow Input"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("013", "Import allow Output"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("014", "Export allow Input (conditional)"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("015", "Import allow Output (conditional)"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("016", "Export allow Input (invert cond)"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("017", "Import allow Output (invert cond)"));
            }
        }
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return this.coverData >= 6 || this.coverData % 2 != 0;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return this.coverData >= 6 || this.coverData % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return this.mTickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ConveyorUIFactory(buildContext).createWindow();
    }
}

