/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.ControlsWorkUIFactory;
import java.lang.ref.WeakReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverControlsWork
extends CoverLegacyData {
    private boolean handledShutdown = false;
    protected WeakReference<EntityPlayer> lastPlayer = null;
    private boolean mPlayerNotified = false;

    public static boolean isCoverPlaceable(ForgeDirection side, ItemStack coverItem, ICoverable coverable) {
        for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
            if (!(coverable.getCoverAtSide(tSide) instanceof CoverControlsWork)) continue;
            return false;
        }
        return true;
    }

    public CoverControlsWork(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean onCoverShiftRightClick(EntityPlayer aPlayer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && this.hasCoverGUI() && aPlayer instanceof EntityPlayerMP) {
            this.lastPlayer = new WeakReference<EntityPlayer>(aPlayer);
            this.mPlayerNotified = false;
            GTUIInfos.openCoverUI(coverable, aPlayer, this.coverSide);
            return true;
        }
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable instanceof IMachineProgress) {
            IMachineProgress machine = (IMachineProgress)((Object)coverable);
            State state = this.coverData < State.values().length ? State.values()[this.coverData] : State.DISABLED;
            switch (state) {
                case ENABLE_WITH_SIGNAL: 
                case DISABLE_WITH_SIGNAL: {
                    if (aInputRedstone > 0 == (state == State.ENABLE_WITH_SIGNAL)) {
                        if (machine.isAllowedToWork()) break;
                        machine.enableWorking();
                        this.handledShutdown = false;
                        break;
                    }
                    if (!machine.isAllowedToWork()) break;
                    machine.disableWorking();
                    break;
                }
                case DISABLED: {
                    if (!machine.isAllowedToWork()) break;
                    machine.disableWorking();
                    break;
                }
                case ENABLE_WITH_SIGNAL_SAFE: 
                case DISABLE_WITH_SIGNAL_SAFE: {
                    if (machine.wasShutdown() && machine.getLastShutDownReason().wasCritical() && !this.handledShutdown) {
                        if (!this.mPlayerNotified) {
                            EntityPlayer player;
                            EntityPlayer entityPlayer = player = this.lastPlayer == null ? null : (EntityPlayer)this.lastPlayer.get();
                            if (player != null) {
                                this.lastPlayer = null;
                                this.mPlayerNotified = true;
                                GTUtility.sendChatToPlayer(player, coverable.func_145825_b() + "at " + String.format("(%d,%d,%d)", coverable.getXCoord(), coverable.getYCoord(), coverable.getZCoord()) + " shut down.");
                            }
                        }
                        this.handledShutdown = true;
                        this.coverData = State.DISABLED.ordinal();
                        break;
                    }
                    if (aInputRedstone > 0 == (state == State.ENABLE_WITH_SIGNAL_SAFE)) {
                        if (machine.isAllowedToWork()) break;
                        machine.enableWorking();
                        this.handledShutdown = false;
                        break;
                    }
                    if (!machine.isAllowedToWork()) break;
                    machine.disableWorking();
                }
            }
        }
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return this.coverData != 2;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid fluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid fluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int slot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int slot) {
        return true;
    }

    @Override
    public void onCoverRemoval() {
        Object t = this.coveredTile.get();
        if (t instanceof IMachineProgress) {
            IMachineProgress machine = (IMachineProgress)t;
            machine.enableWorking();
        }
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int newCoverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 5;
        if (newCoverData < 0) {
            newCoverData = 2;
        }
        if (newCoverData == 0) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("003", "Enable with Signal"));
        }
        if (newCoverData == 1) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("004", "Disable with Signal"));
        }
        if (newCoverData == 2) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("005", "Disabled"));
        }
        if (newCoverData == 3) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("505", "Enable with Signal (Safe)"));
        }
        if (newCoverData == 4) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("506", "Disable with Signal (Safe)"));
        }
        this.coverData = newCoverData;
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ControlsWorkUIFactory(buildContext).createWindow();
    }

    private static enum State {
        ENABLE_WITH_SIGNAL,
        DISABLE_WITH_SIGNAL,
        DISABLED,
        ENABLE_WITH_SIGNAL_SAFE,
        DISABLE_WITH_SIGNAL_SAFE;

    }
}

