/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import gregtech.api.covers.CoverContext;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.gui.mui1.cover.CoverUiFactory;
import gregtech.common.text.ClientTickRateFormatter;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class Cover {
    public static final int MAX_TICK_RATE_ADDITION = 1200;
    private static final String NBT_DATA = "d";
    private static final String NBT_TICK_RATE_ADDITION = "tra";
    protected final ForgeDirection coverSide;
    protected final int coverID;
    protected final WeakReference<ICoverable> coveredTile;
    private final ITexture coverFGTexture;
    protected boolean needsUpdate = false;
    protected int tickRateAddition = 0;

    public Cover(@NotNull CoverContext context, ITexture coverFGTexture) {
        this.coverSide = context.getSide();
        this.coverID = context.getCoverId();
        this.coveredTile = new WeakReference<ICoverable>(context.getCoverable());
        this.coverFGTexture = coverFGTexture;
        this.setTickRateAddition(this.initializeTickRateAddition(context.getCoverInitializer()));
    }

    protected void initializeData(Object coverData) {
        NBTTagCompound nbt;
        if (coverData instanceof ItemStack) {
            ItemStack coverStack = (ItemStack)coverData;
            this.loadFromItemStack(coverStack);
        } else if (coverData instanceof NBTTagCompound && (nbt = (NBTTagCompound)coverData).func_74764_b(NBT_DATA)) {
            this.loadFromNbt(nbt.func_74781_a(NBT_DATA));
        } else if (coverData instanceof ByteArrayDataInput) {
            ByteArrayDataInput byteData = (ByteArrayDataInput)coverData;
            this.readFromPacket(byteData);
        } else {
            this.initializeData();
        }
    }

    private int initializeTickRateAddition(Object coverData) {
        NBTTagCompound nbt;
        if (coverData instanceof NBTTagCompound && (nbt = (NBTTagCompound)coverData).func_74764_b(NBT_TICK_RATE_ADDITION)) {
            return nbt.func_74762_e(NBT_TICK_RATE_ADDITION);
        }
        if (coverData instanceof ByteArrayDataInput) {
            ByteArrayDataInput byteData = (ByteArrayDataInput)coverData;
            return byteData.readInt();
        }
        return this.getDefaultTickRateAddition();
    }

    private int getDefaultTickRateAddition() {
        if (!this.allowsTickRateAddition()) {
            return 0;
        }
        return this.getDefaultTickRate() - this.getMinimumTickRate();
    }

    protected void initializeData() {
    }

    protected void loadFromItemStack(@NotNull ItemStack cover) {
        this.initializeData();
    }

    protected void loadFromNbt(NBTBase nbt) {
    }

    protected void readFromPacket(ByteArrayDataInput byteData) {
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_TICK_RATE_ADDITION, this.tickRateAddition);
        nbt.func_74782_a(NBT_DATA, this.saveDataToNbt());
        return nbt;
    }

    @Nonnull
    protected NBTBase saveDataToNbt() {
        return new NBTTagCompound();
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.tickRateAddition);
        this.writeDataToByteBuf(byteBuf);
    }

    protected void writeDataToByteBuf(ByteBuf byteBuf) {
    }

    public ITexture getOverlayTexture() {
        return this.coverFGTexture;
    }

    public void doCoverThings(byte aRedstone, long aTickTimer) {
    }

    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    public boolean isValid() {
        return this.coverID != 0 && this.coverSide != ForgeDirection.UNKNOWN;
    }

    public int getCoverID() {
        return this.coverID;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean aUpdate) {
        this.needsUpdate = aUpdate;
    }

    public boolean allowsTickRateAddition() {
        return true;
    }

    public void onPlayerAttach(EntityPlayer player, ItemStack coverItem) {
    }

    public int getDefaultTickRate() {
        return this.getMinimumTickRate();
    }

    public ItemStack asItemStack() {
        return GTUtility.intToStack(this.coverID);
    }

    public boolean isDataNeededOnClient() {
        return false;
    }

    public void onCoverRemoval() {
    }

    public ITexture getSpecialFaceTexture() {
        return null;
    }

    public final int getTickRate() {
        return this.getMinimumTickRate() + this.tickRateAddition;
    }

    public ForgeDirection getSide() {
        return this.coverSide;
    }

    public ICoverable getTile() {
        return (ICoverable)this.coveredTile.get();
    }

    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    public boolean manipulatesSidedRedstoneOutput() {
        return false;
    }

    public byte getRedstoneInput(byte aInputRedstone) {
        return this.letsRedstoneGoIn() ? aInputRedstone : (byte)0;
    }

    public boolean letsRedstoneGoIn() {
        return false;
    }

    public boolean letsRedstoneGoOut() {
        return false;
    }

    public void onCoverUnload() {
    }

    public void onBaseTEDestroyed() {
    }

    public void preDataChanged(Cover newCover) {
    }

    public void onDataChanged() {
    }

    public String getDescription() {
        return "";
    }

    protected ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new CoverUiFactory(buildContext).createWindow();
    }

    public ModularUIContainer createCoverContainer(EntityPlayer player) {
        ICoverable tile = (ICoverable)this.coveredTile.get();
        if (tile == null) {
            return null;
        }
        CoverUIBuildContext buildContext = new CoverUIBuildContext(player, this.coverID, this.coverSide, tile, false);
        ModularWindow window = this.createWindow(buildContext);
        if (window == null) {
            return null;
        }
        return new ModularUIContainer(new ModularUIContext((UIBuildContext)buildContext, () -> ((ICoverable)tile).func_70296_d()), window);
    }

    public ModularWindow createCoverWindow(EntityPlayer player) {
        CoverUIBuildContext buildContext = new CoverUIBuildContext(player, this.coverID, this.coverSide, (ICoverable)this.coveredTile.get(), true);
        return this.createWindow(buildContext);
    }

    public final boolean isGUIClickable() {
        return CoverRegistry.getCoverPlacer(this.coverID).isGuiClickable();
    }

    public boolean hasCoverGUI() {
        return false;
    }

    public boolean letsEnergyIn() {
        return false;
    }

    public boolean letsEnergyOut() {
        return false;
    }

    public boolean letsFluidIn(Fluid fluid) {
        return false;
    }

    public boolean letsFluidOut(Fluid fluid) {
        return false;
    }

    public boolean letsItemsIn(int slot) {
        return false;
    }

    public boolean letsItemsOut(int slot) {
        return false;
    }

    public boolean alwaysLookConnected() {
        return false;
    }

    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    public boolean onCoverShiftRightClick(EntityPlayer aPlayer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && this.hasCoverGUI() && aPlayer instanceof EntityPlayerMP) {
            GTUIInfos.openCoverUI(coverable, aPlayer, this.coverSide);
            return true;
        }
        return false;
    }

    public void onCoverJackhammer(EntityPlayer aPlayer) {
        this.adjustTickRateMultiplier(aPlayer.func_70093_af());
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"gt.cover.info.chat.tick_rate", (Object[])new Object[]{this.getCurrentTickRateFormatted()}));
    }

    public void adjustTickRateMultiplier(boolean isDecreasing) {
        int currentTickRate = this.getTickRate();
        int stepAmount = currentTickRate == 20 ? (isDecreasing ? 5 : 20) : (currentTickRate < 20 ? 5 : 20);
        this.setTickRateAddition(this.tickRateAddition + (isDecreasing ? -1 : 1) * stepAmount);
        this.setTickRateAddition(this.tickRateAddition - this.getTickRate() % stepAmount);
    }

    protected final void setTickRateAddition(int newValue) {
        this.tickRateAddition = Math.min(1200, Math.max(0, newValue));
    }

    @NotNull
    public ClientTickRateFormatter getCurrentTickRateFormatted() {
        return new ClientTickRateFormatter(this.getTickRate());
    }

    public int getMinimumTickRate() {
        return 0;
    }

    public int getTickRateAddition() {
        return this.tickRateAddition;
    }

    public Block getFacadeBlock() {
        return null;
    }

    public int getFacadeMeta() {
        return 0;
    }

    @NotNull
    public List<String> getAdditionalTooltip() {
        return ImmutableList.of();
    }

    public boolean allowsCopyPasteTool() {
        return true;
    }
}

