/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTRenderingWorld;
import gregtech.common.blocks.BlockCasingsAbstract;
import gregtech.common.blocks.ItemCasings;
import gregtech.common.blocks.MaterialCasings;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockCasings8
extends BlockCasingsAbstract {
    public static boolean mConnectedMachineTextures = true;

    public BlockCasings8() {
        super(ItemCasings.class, "gt.blockcasings8", MaterialCasings.INSTANCE, 15);
        this.register(0, ItemList.Casing_Chemically_Inert, "Chemically Inert Machine Casing");
        this.register(1, ItemList.Casing_Pipe_Polytetrafluoroethylene, "PTFE Pipe Casing");
        this.register(2, ItemList.Casing_MiningNeutronium, "Mining Neutronium Casing");
        this.register(3, ItemList.Casing_MiningBlackPlutonium, "Mining Black Plutonium Casing");
        this.register(4, ItemList.Casing_ExtremeEngineIntake, "Extreme Engine Intake Casing");
        this.register(5, ItemList.Casing_AdvancedRadiationProof, "Europium Reinforced Radiation Proof Machine Casing");
        this.register(6, ItemList.Casing_Advanced_Rhodium_Palladium, "Advanced Rhodium Plated Palladium Machine Casing");
        this.register(7, ItemList.Casing_Advanced_Iridium, "Advanced Iridium Plated Machine Casing");
        this.register(8, ItemList.Casing_Magical, "Magical Machine Casing");
        this.register(9, ItemList.Casing_TurbineGasAdvanced, "HSS-S Turbine Casing");
        this.register(10, ItemList.RadiantNaquadahAlloyCasing, "Radiant Naquadah Alloy Casing");
        this.register(11, ItemList.BasicPhotolithographicFrameworkCasing, "Basic Photolithographic Framework Casing");
        this.register(12, ItemList.ReinforcedPhotolithographicFrameworkCasing, "Reinforced Photolithographic Framework Casing");
        this.register(13, ItemList.RadiationProofPhotolithographicFrameworkCasing, "Radiation Proof Photolithographic Framework Casing");
        this.register(14, ItemList.InfinityCooledCasing, "Infinity Cooled Casing");
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return 0x80 | aMeta + 48;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        IIcon iIcon;
        switch (aMeta) {
            case 0: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_CHEMICALLY_INERT.getIcon();
                break;
            }
            case 1: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PIPE_POLYTETRAFLUOROETHYLENE.getIcon();
                break;
            }
            case 2: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MINING_NEUTRONIUM.getIcon();
                break;
            }
            case 3: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MINING_BLACKPLUTONIUM.getIcon();
                break;
            }
            case 4: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_EXTREME_ENGINE_INTAKE.getIcon();
                break;
            }
            case 5: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ADVANCEDRADIATIONPROOF.getIcon();
                break;
            }
            case 6: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_RHODIUM_PALLADIUM.getIcon();
                break;
            }
            case 7: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_IRIDIUM.getIcon();
                break;
            }
            case 8: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MAGICAL.getIcon();
                break;
            }
            case 9: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_HSSS.getIcon();
                break;
            }
            case 10: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_RADIANT_NAQUADAH_ALLOY.getIcon();
                break;
            }
            case 11: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PCB_TIER_1.getIcon();
                break;
            }
            case 12: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PCB_TIER_2.getIcon();
                break;
            }
            case 13: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PCB_TIER_3.getIcon();
                break;
            }
            case 14: {
                iIcon = Textures.BlockIcons.INFINITY_COOLED_CASING.getIcon();
                break;
            }
            default: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ROBUST_TUNGSTENSTEEL.getIcon();
            }
        }
        return iIcon;
    }

    public IIcon getTurbineCasing(int meta, int iconIndex, boolean active, boolean hasTurbine) {
        IIcon iIcon;
        switch (meta) {
            case 9: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ADVGASACTIVE[iconIndex].getIcon();
                    break;
                }
                if (hasTurbine) {
                    iIcon = Textures.BlockIcons.TURBINEADVGAS[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINE_ADVGASEMPTY[iconIndex].getIcon();
                break;
            }
            default: {
                iIcon = active ? Textures.BlockIcons.TURBINE_ACTIVE[iconIndex].getIcon() : (hasTurbine ? Textures.BlockIcons.TURBINE[iconIndex].getIcon() : Textures.BlockIcons.TURBINE_EMPTY[iconIndex].getIcon());
            }
        }
        return iIcon;
    }

    private static int isTurbineControllerWithSide(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return 0;
        }
        IGregTechTileEntity tTile = (IGregTechTileEntity)tTileEntity;
        IMetaTileEntity iMetaTileEntity = tTile.getMetaTileEntity();
        if (iMetaTileEntity instanceof MTELargeTurbine) {
            MTELargeTurbine turbine = (MTELargeTurbine)iMetaTileEntity;
            if (tTile.getFrontFacing().ordinal() == ordinalSide) {
                if (turbine.isNewStyleRendering()) {
                    return 0;
                }
                if (tTile.isActive()) {
                    return 1;
                }
                return turbine.hasTurbine() ? 2 : 3;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aWorld, int xCoord, int yCoord, int zCoord, int ordinalSide) {
        int tMeta = (aWorld = GTRenderingWorld.getInstance(aWorld)).func_72805_g(xCoord, yCoord, zCoord);
        if (tMeta != 9 || !mConnectedMachineTextures) {
            return this.func_149691_a(ordinalSide, tMeta);
        }
        int tInvertLeftRightMod = ordinalSide % 2 * 2 - 1;
        switch (ordinalSide / 2) {
            case 0: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = BlockCasings8.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord, zCoord + i, ordinalSide)) == 0) continue;
                        return this.getTurbineCasing(tMeta, 4 - i * 3 - j, tState == 1, tState == 2);
                    }
                }
                break;
            }
            case 1: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = BlockCasings8.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord + i, zCoord, ordinalSide)) == 0) continue;
                        return this.getTurbineCasing(tMeta, 4 + i * 3 - j * tInvertLeftRightMod, tState == 1, tState == 2);
                    }
                }
                break;
            }
            case 2: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = BlockCasings8.isTurbineControllerWithSide(aWorld, xCoord, yCoord + i, zCoord + j, ordinalSide)) == 0) continue;
                        return this.getTurbineCasing(tMeta, 4 + i * 3 + j * tInvertLeftRightMod, tState == 1, tState == 2);
                    }
                }
                break;
            }
        }
        return Textures.BlockIcons.MACHINE_CASING_TURBINE_HSSS.getIcon();
    }
}

