/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTRenderingWorld;
import gregtech.common.blocks.BlockCasingsAbstract;
import gregtech.common.blocks.ItemCasings;
import gregtech.common.blocks.MaterialCasings;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockCasings4
extends BlockCasingsAbstract {
    private static final int[][] mapping = new int[][]{{7, 7, 7, 7, 0, 7, 0, 7, 1, 7, 1, 7, 8, 7, 8, 7, 0, 7, 0, 7, 0, 7, 0, 7, 9, 7, 9, 7, 3, 7, 3, 7, 1, 7, 1, 7, 11, 7, 11, 7, 1, 7, 1, 7, 2, 7, 2, 7, 10, 7, 10, 7, 5, 7, 5, 7, 4, 7, 4, 7, 6, 7, 6, 7}, {7, 7, 7, 7, 0, 0, 7, 7, 1, 1, 7, 7, 8, 8, 7, 7, 0, 0, 7, 7, 0, 0, 7, 7, 9, 9, 7, 7, 3, 3, 7, 7, 1, 1, 7, 7, 11, 11, 7, 7, 1, 1, 7, 7, 2, 2, 7, 7, 10, 10, 7, 7, 5, 5, 7, 7, 4, 4, 7, 7, 6, 6, 7, 7}, {7, 1, 1, 1, 0, 9, 10, 4, 7, 1, 1, 1, 0, 9, 10, 4, 0, 8, 11, 2, 0, 3, 5, 6, 0, 8, 11, 2, 0, 3, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {7, 1, 1, 1, 0, 8, 11, 2, 7, 7, 7, 7, 7, 7, 7, 7, 0, 9, 10, 4, 0, 3, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 1, 1, 1, 0, 8, 11, 2, 7, 7, 7, 7, 7, 7, 7, 7, 0, 9, 10, 4, 0, 3, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7}, {7, 1, 1, 1, 7, 1, 1, 1, 0, 8, 11, 2, 0, 8, 11, 2, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 9, 10, 4, 0, 9, 10, 4, 0, 3, 5, 6, 0, 3, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {7, 1, 1, 1, 7, 7, 7, 7, 0, 9, 10, 4, 7, 7, 7, 7, 7, 1, 1, 1, 7, 7, 7, 7, 0, 9, 10, 4, 7, 7, 7, 7, 0, 8, 11, 2, 7, 7, 7, 7, 0, 3, 5, 6, 7, 7, 7, 7, 0, 8, 11, 2, 7, 7, 7, 7, 0, 3, 5, 6, 7, 7, 7, 7}};
    public static boolean mConnectedMachineTextures = true;

    public BlockCasings4() {
        super(ItemCasings.class, "gt.blockcasings4", MaterialCasings.INSTANCE, 16);
        this.register(0, ItemList.Casing_RobustTungstenSteel, "Robust Tungstensteel Machine Casing");
        this.register(1, ItemList.Casing_CleanStainlessSteel, "Clean Stainless Steel Machine Casing");
        this.register(2, ItemList.Casing_StableTitanium, "Stable Titanium Machine Casing");
        this.register(3, ItemList.Casing_Firebox_Titanium, "Titanium Firebox Casing");
        this.register(6, ItemList.Casing_Fusion, "Fusion Machine Casing");
        this.register(7, ItemList.Casing_Fusion_Coil, "Fusion Coil Block");
        this.register(8, ItemList.Casing_Fusion2, "Fusion Machine Casing MK II");
        this.register(9, ItemList.Casing_Turbine, "Turbine Casing");
        this.register(10, ItemList.Casing_Turbine1, "Stainless Steel Turbine Casing");
        this.register(11, ItemList.Casing_Turbine2, "Titanium Turbine Casing");
        this.register(12, ItemList.Casing_Turbine3, "Tungstensteel Turbine Casing");
        this.register(13, ItemList.Casing_EngineIntake, "Engine Intake Casing");
        this.register(14, ItemList.Casing_MiningOsmiridium, "Mining Osmiridium Casing");
        this.register(15, ItemList.Casing_Firebricks, "Firebricks");
        GTMod.gregtechproxy.mCTMBlockCache.put(this, 6, true);
        GTMod.gregtechproxy.mCTMBlockCache.put(this, 8, true);
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return aMeta + 48;
    }

    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        IIcon iIcon;
        switch (aMeta) {
            case 0: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ROBUST_TUNGSTENSTEEL.getIcon();
                break;
            }
            case 1: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_CLEAN_STAINLESSSTEEL.getIcon();
                break;
            }
            case 2: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_STABLE_TITANIUM.getIcon();
                break;
            }
            case 3: {
                if (ordinalSide > 1) {
                    iIcon = Textures.BlockIcons.MACHINE_CASING_FIREBOX_TITANIUM.getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.MACHINE_CASING_STABLE_TITANIUM.getIcon();
                break;
            }
            case 4: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW.getIcon();
                break;
            }
            case 5: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS.getIcon();
                break;
            }
            case 6: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_FUSION.getIcon();
                break;
            }
            case 7: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_FUSION_COIL.getIcon();
                break;
            }
            case 8: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_FUSION_2.getIcon();
                break;
            }
            case 9: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_STEEL.getIcon();
                break;
            }
            case 10: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_STAINLESSSTEEL.getIcon();
                break;
            }
            case 11: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_TITANIUM.getIcon();
                break;
            }
            case 12: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_TUNGSTENSTEEL.getIcon();
                break;
            }
            case 13: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ENGINE_INTAKE.getIcon();
                break;
            }
            case 14: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MINING_OSMIRIDIUM.getIcon();
                break;
            }
            case 15: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_DENSEBRICKS.getIcon();
                break;
            }
            default: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_SOLID_STEEL.getIcon();
            }
        }
        return iIcon;
    }

    @Deprecated
    public IIcon getTurbineCasing(int meta, int iconIndex, boolean active, boolean hasTurbine) {
        IIcon iIcon;
        switch (meta) {
            case 9: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ACTIVE[iconIndex].getIcon();
                    break;
                }
                if (hasTurbine) {
                    iIcon = Textures.BlockIcons.TURBINE[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINE_EMPTY[iconIndex].getIcon();
                break;
            }
            case 10: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ACTIVE1[iconIndex].getIcon();
                    break;
                }
                if (hasTurbine) {
                    iIcon = Textures.BlockIcons.TURBINE1[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINE_EMPTY1[iconIndex].getIcon();
                break;
            }
            case 11: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ACTIVE2[iconIndex].getIcon();
                    break;
                }
                if (hasTurbine) {
                    iIcon = Textures.BlockIcons.TURBINE2[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINE_EMPTY2[iconIndex].getIcon();
                break;
            }
            case 12: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ACTIVE3[iconIndex].getIcon();
                    break;
                }
                if (hasTurbine) {
                    iIcon = Textures.BlockIcons.TURBINE3[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINE_EMPTY3[iconIndex].getIcon();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + meta);
            }
        }
        return iIcon;
    }

    private static int isTurbineControllerWithSide(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return 0;
        }
        IGregTechTileEntity tTile = (IGregTechTileEntity)tTileEntity;
        IMetaTileEntity iMetaTileEntity = tTile.getMetaTileEntity();
        if (iMetaTileEntity instanceof MTELargeTurbine) {
            MTELargeTurbine turbine = (MTELargeTurbine)iMetaTileEntity;
            if (tTile.getFrontFacing().ordinal() == ordinalSide) {
                if (turbine.isNewStyleRendering()) {
                    return 0;
                }
                if (tTile.isActive()) {
                    return 1;
                }
                return turbine.hasTurbine() ? 2 : 3;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aWorld, int xCoord, int yCoord, int zCoord, int ordinalSide) {
        int tMeta = (aWorld = GTRenderingWorld.getInstance(aWorld)).func_72805_g(xCoord, yCoord, zCoord);
        if (tMeta != 6 && tMeta != 8 && tMeta != 9 && tMeta != 10 && tMeta != 11 && tMeta != 12 || !mConnectedMachineTextures) {
            return this.func_149691_a(ordinalSide, tMeta);
        }
        if (tMeta > 8 && tMeta < 13) {
            IIcon iIcon;
            int tInvertLeftRightMod = ordinalSide % 2 * 2 - 1;
            switch (ordinalSide / 2) {
                case 0: {
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            int tState;
                            if (i == 0 && j == 0 || (tState = BlockCasings4.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord, zCoord + i, ordinalSide)) == 0) continue;
                            return this.getTurbineCasing(tMeta, 4 - i * 3 - j, tState == 1, tState == 2);
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            int tState;
                            if (i == 0 && j == 0 || (tState = BlockCasings4.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord + i, zCoord, ordinalSide)) == 0) continue;
                            return this.getTurbineCasing(tMeta, 4 + i * 3 - j * tInvertLeftRightMod, tState == 1, tState == 2);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            int tState;
                            if (i == 0 && j == 0 || (tState = BlockCasings4.isTurbineControllerWithSide(aWorld, xCoord, yCoord + i, zCoord + j, ordinalSide)) == 0) continue;
                            return this.getTurbineCasing(tMeta, 4 + i * 3 + j * tInvertLeftRightMod, tState == 1, tState == 2);
                        }
                    }
                    break;
                }
            }
            switch (tMeta) {
                case 9: {
                    iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_STEEL.getIcon();
                    break;
                }
                case 10: {
                    iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_STAINLESSSTEEL.getIcon();
                    break;
                }
                case 11: {
                    iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_TITANIUM.getIcon();
                    break;
                }
                case 12: {
                    iIcon = Textures.BlockIcons.MACHINE_CASING_TURBINE_TUNGSTENSTEEL.getIcon();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + tMeta);
                }
            }
            return iIcon;
        }
        int tStartIndex = tMeta == 6 ? 1 : 13;
        int tIndexIntoMapping = 0;
        if (this.isSameBlock(aWorld, xCoord, yCoord - 1, zCoord, tMeta)) {
            tIndexIntoMapping |= 1;
        }
        if (this.isSameBlock(aWorld, xCoord, yCoord + 1, zCoord, tMeta)) {
            tIndexIntoMapping |= 2;
        }
        if (this.isSameBlock(aWorld, xCoord + 1, yCoord, zCoord, tMeta)) {
            tIndexIntoMapping |= 4;
        }
        if (this.isSameBlock(aWorld, xCoord, yCoord, zCoord + 1, tMeta)) {
            tIndexIntoMapping |= 8;
        }
        if (this.isSameBlock(aWorld, xCoord - 1, yCoord, zCoord, tMeta)) {
            tIndexIntoMapping |= 0x10;
        }
        if (this.isSameBlock(aWorld, xCoord, yCoord, zCoord - 1, tMeta)) {
            tIndexIntoMapping |= 0x20;
        }
        return Textures.BlockIcons.CONNECTED_HULLS[tStartIndex + mapping[ordinalSide][tIndexIntoMapping]].getIcon();
    }

    private boolean isSameBlock(IBlockAccess aWorld, int aX, int aY, int aZ, int aMeta) {
        return aWorld.func_147439_a(aX, aY, aZ) == this && aWorld.func_72805_g(aX, aY, aZ) == aMeta;
    }
}

