/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTRecipe;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class OverclockCalculator {
    private long recipeEUt = 0L;
    private long machineVoltage = 0L;
    private long machineAmperage = 1L;
    private int duration = 0;
    private Supplier<Double> durationUnderOneTickSupplier;
    private int parallel = 1;
    private double eutModifier = 1.0;
    private double durationModifier = 1.0;
    private double eutIncreasePerOC = 4.0;
    private double durationDecreasePerOC = 2.0;
    private boolean laserOC;
    private boolean amperageOC;
    private int maxOverclocks = Integer.MAX_VALUE;
    private int overclocks = 0;
    private boolean noOverclock;
    private int currentParallel;
    private int recipeHeat = 0;
    private int machineHeat = 0;
    private final double durationDecreasePerHeatOC = 4.0;
    private boolean heatOC;
    private boolean heatDiscount;
    private double heatDiscountExponent = 0.95;
    private boolean calculated;
    private int calculatedDuration;
    private long calculatedConsumption;
    private static final int HEAT_DISCOUNT_THRESHOLD = 900;
    private static final int HEAT_OVERCLOCK_THRESHOLD = 1800;
    private static final double LOG4 = Math.log(4.0);

    public static OverclockCalculator ofNoOverclock(@Nonnull GTRecipe recipe) {
        return OverclockCalculator.ofNoOverclock(recipe.mEUt, recipe.mDuration);
    }

    public static OverclockCalculator ofNoOverclock(long eut, int duration) {
        return new OverclockCalculator().setRecipeEUt(eut).setDuration(duration).setEUt(eut).setNoOverclock(true);
    }

    @Nonnull
    public OverclockCalculator setRecipeEUt(long recipeEUt) {
        this.recipeEUt = recipeEUt;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUt(long machineVoltage) {
        this.machineVoltage = machineVoltage;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public OverclockCalculator setAmperage(long machineAmperage) {
        this.machineAmperage = machineAmperage;
        return this;
    }

    @Nonnull
    public OverclockCalculator enablePerfectOC() {
        this.durationDecreasePerOC = 4.0;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatOC(boolean heatOC) {
        this.heatOC = heatOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatDiscount(boolean heatDiscount) {
        this.heatDiscount = heatDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator setRecipeHeat(int recipeHeat) {
        this.recipeHeat = recipeHeat;
        return this;
    }

    @Nonnull
    public OverclockCalculator setMachineHeat(int machineHeat) {
        this.machineHeat = machineHeat;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUtDiscount(double aEUtDiscount) {
        this.eutModifier = aEUtDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationModifier(double aSpeedBoost) {
        this.durationModifier = aSpeedBoost;
        return this;
    }

    @Nonnull
    public OverclockCalculator setParallel(int aParallel) {
        this.parallel = aParallel;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatDiscountMultiplier(double heatDiscountExponent) {
        this.heatDiscountExponent = heatDiscountExponent;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUtIncreasePerOC(double eutIncreasePerOC) {
        if (eutIncreasePerOC <= 0.0) {
            throw new IllegalArgumentException("EUt increase can't be a negative number or zero");
        }
        this.eutIncreasePerOC = eutIncreasePerOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationDecreasePerOC(double durationDecreasePerOC) {
        if (durationDecreasePerOC <= 0.0) {
            throw new IllegalArgumentException("Duration decrease can't be a negative number or zero");
        }
        this.durationDecreasePerOC = durationDecreasePerOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator limitOverclockCount(int maxOverclocks) {
        this.maxOverclocks = maxOverclocks;
        return this;
    }

    @Nonnull
    public OverclockCalculator setLaserOC(boolean laserOC) {
        this.laserOC = laserOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationUnderOneTickSupplier(Supplier<Double> supplier) {
        this.durationUnderOneTickSupplier = supplier;
        return this;
    }

    @Nonnull
    public OverclockCalculator setNoOverclock(boolean noOverclock) {
        this.noOverclock = noOverclock;
        return this;
    }

    public OverclockCalculator setCurrentParallel(int currentParallel) {
        this.currentParallel = currentParallel;
        this.parallel = Math.min(this.parallel, currentParallel);
        return this;
    }

    public long getConsumption() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get consumption before calculating");
        }
        return this.calculatedConsumption;
    }

    public int getDuration() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get duration before calculating");
        }
        return this.calculatedDuration;
    }

    public int getPerformedOverclocks() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get performed overclocks before calculating");
        }
        return this.overclocks;
    }

    @Nonnull
    public OverclockCalculator calculate() {
        if (this.calculated) {
            throw new IllegalStateException("Tried to calculate overclocks twice");
        }
        this.calculateOverclock();
        this.calculated = true;
        return this;
    }

    public double calculateHeatDiscountMultiplier() {
        int heatDiscounts = this.heatDiscount ? (this.machineHeat - this.recipeHeat) / 900 : 0;
        return Math.pow(this.heatDiscountExponent, heatDiscounts);
    }

    private void calculateOverclock() {
        double duration = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : (double)this.duration * this.durationModifier;
        this.currentParallel = Math.max(this.currentParallel, this.parallel);
        double recipePower = (double)(this.recipeEUt * (long)this.parallel) * this.eutModifier * this.calculateHeatDiscountMultiplier();
        double recipePowerTier = Math.max(Math.log(recipePower / 8.0) / LOG4, 1.0);
        double machinePower = this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel));
        double machinePowerTier = Math.max(Math.log(machinePower / 8.0) / LOG4, 1.0);
        if (this.noOverclock) {
            this.calculatedConsumption = (long)Math.ceil(recipePower);
            this.calculatedDuration = (int)Math.ceil(duration);
            return;
        }
        if (this.laserOC) {
            double eutLaserOverclock = recipePower;
            this.overclocks = 0;
            while (eutLaserOverclock * (4.0 + 0.3 * (double)(this.overclocks + 1)) < machinePower) {
                eutLaserOverclock *= 4.0 + 0.3 * (double)(this.overclocks + 1);
                ++this.overclocks;
            }
            this.calculatedConsumption = (long)Math.ceil(eutLaserOverclock);
            this.calculatedDuration = (int)Math.max(duration /= Math.pow(this.durationDecreasePerOC, this.overclocks), 1.0);
            return;
        }
        this.overclocks = Math.min(this.maxOverclocks, (int)(machinePowerTier - recipePowerTier));
        if (!this.amperageOC) {
            int voltageTierMachine = (int)Math.max(Math.ceil(Math.log((double)this.machineVoltage / 8.0) / LOG4), 1.0);
            int voltageTierRecipe = (int)Math.max(Math.ceil(Math.log((double)this.recipeEUt / 8.0) / LOG4), 1.0);
            this.overclocks = Math.min(this.overclocks, voltageTierMachine - voltageTierRecipe);
        }
        this.overclocks = Math.max(this.overclocks, 0);
        int heatOverclocks = Math.min(this.heatOC ? (this.machineHeat - this.recipeHeat) / 1800 : 0, this.overclocks);
        int regularOverclocks = this.overclocks - heatOverclocks;
        this.calculatedConsumption = (long)Math.ceil(recipePower * Math.pow(this.eutIncreasePerOC, this.overclocks));
        duration /= Math.pow(4.0, heatOverclocks);
        this.calculatedDuration = (int)Math.max(duration /= Math.pow(this.durationDecreasePerOC, regularOverclocks), 1.0);
    }

    public double calculateDurationUnderOneTick() {
        double duration = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : (double)this.duration * this.durationModifier;
        double recipePower = (double)(this.recipeEUt * (long)this.parallel) * this.eutModifier * this.calculateHeatDiscountMultiplier();
        double recipePowerTier = Math.max(Math.log(recipePower / 8.0) / LOG4, 1.0);
        double machinePower = this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel));
        double machinePowerTier = Math.max(Math.log(machinePower / 8.0) / LOG4, 1.0);
        if (this.noOverclock) {
            return duration;
        }
        if (this.laserOC) {
            double eutLaserOverclock = recipePower;
            int overclocks = 0;
            while (eutLaserOverclock * (4.0 + 0.3 * (double)(overclocks + 1)) < machinePower) {
                eutLaserOverclock *= 4.0 + 0.3 * (double)(overclocks + 1);
                ++overclocks;
            }
            return duration / Math.pow(this.durationDecreasePerOC, overclocks);
        }
        int overclocks = Math.min(this.maxOverclocks, (int)(machinePowerTier - recipePowerTier));
        if (!this.amperageOC) {
            int voltageTierMachine = (int)Math.max(Math.ceil(Math.log((double)this.machineVoltage / 8.0) / LOG4), 1.0);
            int voltageTierRecipe = (int)Math.max(Math.ceil(Math.log((double)this.recipeEUt / 8.0) / LOG4), 1.0);
            overclocks = Math.min(overclocks, voltageTierMachine - voltageTierRecipe);
        }
        overclocks = Math.max(overclocks, 0);
        int heatOverclocks = Math.min(this.heatOC ? (this.machineHeat - this.recipeHeat) / 1800 : 0, overclocks);
        int regularOverclocks = overclocks - heatOverclocks;
        duration /= Math.pow(4.0, heatOverclocks);
        return duration /= Math.pow(this.durationDecreasePerOC, regularOverclocks);
    }
}

