/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.IRecipeMetadataStorage;
import gregtech.api.recipe.metadata.RecipeMetadataStorage;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTRecipeMapUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.extensions.ArrayExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

public class GTRecipeBuilder {
    private static final boolean DEBUG_MODE_NULL;
    private static boolean PANIC_MODE_NULL;
    private static final boolean DEBUG_MODE_INVALID;
    private static final boolean DEBUG_MODE_FULL_ENERGY;
    private static final boolean PANIC_MODE_INVALID;
    public static final boolean DEBUG_MODE_COLLISION;
    private static final boolean PANIC_MODE_COLLISION;
    public static final boolean ENABLE_COLLISION_CHECK;
    public static final int WILDCARD = Short.MAX_VALUE;
    public static final int HOURS = 72000;
    public static final int MINUTES = 1200;
    public static final int SECONDS = 20;
    public static final int TICKS = 1;
    public static final int INGOTS = 144;
    public static final int HALF_INGOT = 72;
    public static final int QUARTER_INGOT = 36;
    public static final int EIGHTH_INGOT = 18;
    public static final int NUGGETS = 16;
    public static final int BUCKETS = 1000;
    protected ItemStack[] inputsBasic = new ItemStack[0];
    protected Object[] inputsOreDict;
    protected ItemStack[] outputs = new ItemStack[0];
    protected ItemStack[][] alts;
    protected FluidStack[] fluidInputs = new FluidStack[0];
    protected FluidStack[] fluidOutputs = new FluidStack[0];
    protected int[] chances;
    protected Object special;
    protected int duration = -1;
    protected int eut = -1;
    protected int specialValue;
    protected boolean enabled = true;
    protected boolean hidden = false;
    protected boolean fakeRecipe = false;
    protected boolean mCanBeBuffered = true;
    protected boolean mNeedsEmptyOutput = false;
    protected boolean nbtSensitive = false;
    protected String[] neiDesc;
    protected RecipeCategory recipeCategory;
    @Nullable
    protected IRecipeMetadataStorage metadataStorage;
    protected boolean checkForCollision = true;
    protected boolean skip = false;
    protected boolean valid = true;

    GTRecipeBuilder() {
    }

    private GTRecipeBuilder(ItemStack[] inputsBasic, Object[] inputsOreDict, ItemStack[] outputs, ItemStack[][] alts, FluidStack[] fluidInputs, FluidStack[] fluidOutputs, int[] chances, Object special, int duration, int eut, int specialValue, boolean enabled, boolean hidden, boolean fakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, boolean nbtSensitive, String[] neiDesc, RecipeCategory recipeCategory, @Nullable IRecipeMetadataStorage metadataStorage, boolean checkForCollision, boolean skip, boolean valid) {
        this.inputsBasic = inputsBasic;
        this.inputsOreDict = inputsOreDict;
        this.outputs = outputs;
        this.alts = alts;
        this.fluidInputs = fluidInputs;
        this.fluidOutputs = fluidOutputs;
        this.chances = chances;
        this.special = special;
        this.duration = duration;
        this.eut = eut;
        this.specialValue = specialValue;
        this.enabled = enabled;
        this.hidden = hidden;
        this.fakeRecipe = fakeRecipe;
        this.mCanBeBuffered = mCanBeBuffered;
        this.mNeedsEmptyOutput = mNeedsEmptyOutput;
        this.nbtSensitive = nbtSensitive;
        this.neiDesc = neiDesc;
        this.recipeCategory = recipeCategory;
        this.metadataStorage = metadataStorage;
        if (this.metadataStorage != null) {
            this.metadataStorage = this.metadataStorage.copy();
        }
        this.checkForCollision = checkForCollision;
        this.skip = skip;
        this.valid = valid;
    }

    private static FluidStack[] fix(FluidStack[] fluidInputs) {
        return (FluidStack[])Arrays.stream(fluidInputs).filter(Objects::nonNull).map(FluidStack::copy).toArray(FluidStack[]::new);
    }

    private static ItemStack[] fix(ItemStack[] inputs, boolean aUnsafe) {
        return GTOreDictUnificator.setStackArray(true, aUnsafe, ArrayExt.withoutTrailingNulls(inputs, ItemStack[]::new));
    }

    public static GTRecipeBuilder builder() {
        return new GTRecipeBuilder();
    }

    public static GTRecipeBuilder empty() {
        return new GTRecipeBuilder().duration(0).eut(0);
    }

    private static boolean containsNull(Object[] arr) {
        return arr == null || Arrays.stream(arr).anyMatch(Objects::isNull);
    }

    private static void handleNullRecipeComponents(String componentType) {
        GTLog.err.print("null detected in ");
        GTLog.err.println(componentType);
        new NullPointerException().printStackTrace(GTLog.err);
        if (PANIC_MODE_NULL) {
            throw new IllegalArgumentException("null in argument");
        }
    }

    private static boolean debugNull() {
        return DEBUG_MODE_NULL || PANIC_MODE_NULL;
    }

    public static void handleInvalidRecipe() {
        if (!DEBUG_MODE_INVALID && !PANIC_MODE_INVALID) {
            return;
        }
        GTLog.err.print("invalid recipe");
        new IllegalArgumentException().printStackTrace(GTLog.err);
        if (PANIC_MODE_INVALID) {
            throw new IllegalArgumentException("invalid recipe");
        }
    }

    public static void handleInvalidRecipeLowFluids() {
        if (!DEBUG_MODE_INVALID && !PANIC_MODE_INVALID) {
            return;
        }
        GTLog.err.println("invalid recipe: not enough input fluids");
        new IllegalArgumentException().printStackTrace(GTLog.err);
        if (PANIC_MODE_INVALID) {
            throw new IllegalArgumentException("invalid recipe");
        }
    }

    public static void handleInvalidRecipeLowItems() {
        if (!DEBUG_MODE_INVALID && !PANIC_MODE_INVALID) {
            return;
        }
        GTLog.err.println("invalid recipe: not enough input items");
        new IllegalArgumentException().printStackTrace(GTLog.err);
        if (PANIC_MODE_INVALID) {
            throw new IllegalArgumentException("invalid recipe");
        }
    }

    public static void handleRecipeCollision(String details) {
        if (!DEBUG_MODE_COLLISION && !PANIC_MODE_COLLISION) {
            return;
        }
        GTLog.err.print("Recipe collision resulting in recipe loss detected with ");
        GTLog.err.println(details);
        if (PANIC_MODE_COLLISION) {
            throw new IllegalArgumentException("Recipe Collision");
        }
        new IllegalArgumentException().printStackTrace(GTLog.err);
    }

    public static void onConfigLoad() {
        PANIC_MODE_NULL |= GTMod.gregtechproxy.crashOnNullRecipeInput;
    }

    public GTRecipeBuilder itemInputsUnified(ItemStack ... inputs) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(inputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("itemInputUnified");
        }
        this.inputsBasic = ArrayExt.withoutTrailingNulls(inputs, ItemStack[]::new);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GTRecipeBuilder itemInputsAllowNulls(ItemStack ... inputs) {
        if (this.skip) {
            return this;
        }
        this.inputsBasic = GTRecipeBuilder.fix(inputs, false);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GTRecipeBuilder itemInputs(ItemStack ... inputs) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(inputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("itemInputs");
        }
        this.inputsBasic = GTRecipeBuilder.fix(inputs, false);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GTRecipeBuilder itemInputsUnsafe(ItemStack ... inputs) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(inputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("itemInputs");
        }
        this.inputsBasic = GTRecipeBuilder.fix(inputs, true);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GTRecipeBuilder itemInputs(Object ... inputs) {
        if (this.skip) {
            return this;
        }
        this.inputsOreDict = inputs;
        this.alts = new ItemStack[inputs.length][];
        int inputsLength = inputs.length;
        for (int i = 0; i < inputsLength; ++i) {
            Object input = inputs[i];
            if (input instanceof ItemStack) {
                this.alts[i] = new ItemStack[]{(ItemStack)input};
                continue;
            }
            if (input instanceof ItemStack[]) {
                this.alts[i] = (ItemStack[])((ItemStack[])input).clone();
                continue;
            }
            if (input instanceof Object[]) {
                ArrayList<ItemStack> ores;
                Object[] arr = (Object[])input;
                if (arr.length != 2 || (ores = GTOreDictUnificator.getOres(arr[0])).isEmpty()) continue;
                int size = ((Number)arr[1]).intValue();
                this.alts[i] = (ItemStack[])ores.stream().map(s -> GTUtility.copyAmount(size, s)).filter(GTUtility::isStackValid).toArray(ItemStack[]::new);
                continue;
            }
            if (input == null) {
                GTRecipeBuilder.handleNullRecipeComponents("recipe oredict input");
                this.alts[i] = new ItemStack[0];
                continue;
            }
            throw new IllegalArgumentException("index " + i + ", unexpected type: " + input.getClass());
        }
        this.inputsBasic = (ItemStack[])Arrays.stream(this.alts).map(ss -> ((ItemStack[])ss).length > 0 ? ss[0] : null).toArray(ItemStack[]::new);
        return this;
    }

    public GTRecipeBuilder itemOutputs(ItemStack ... outputs) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(outputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("itemOutputs");
        }
        this.outputs = outputs;
        if (this.chances != null && this.chances.length != outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        return this;
    }

    public GTRecipeBuilder itemOutputs(ItemStack[] outputs, int[] chances) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(outputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("itemOutputs");
        }
        this.outputs = outputs;
        this.chances = chances;
        if (chances != null && chances.length != outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        return this;
    }

    public GTRecipeBuilder fluidInputs(FluidStack ... fluidInputs) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(fluidInputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("fluidInputs");
        }
        this.fluidInputs = GTRecipeBuilder.fix(fluidInputs);
        return this;
    }

    public GTRecipeBuilder fluidOutputs(FluidStack ... fluidOutputs) {
        if (this.skip) {
            return this;
        }
        if (GTRecipeBuilder.debugNull() && GTRecipeBuilder.containsNull(fluidOutputs)) {
            GTRecipeBuilder.handleNullRecipeComponents("fluidOutputs");
        }
        this.fluidOutputs = GTRecipeBuilder.fix(fluidOutputs);
        return this;
    }

    public GTRecipeBuilder outputChances(int ... chances) {
        if (this.skip) {
            return this;
        }
        if (this.outputs != null && chances.length != this.outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        this.chances = chances;
        return this;
    }

    public GTRecipeBuilder special(Object special) {
        this.special = special;
        return this;
    }

    public GTRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public GTRecipeBuilder duration(long duration) {
        this.duration = (int)duration;
        return this;
    }

    public GTRecipeBuilder eut(int eut) {
        if (DEBUG_MODE_FULL_ENERGY) {
            for (int i = 1; i < GTValues.VP.length; ++i) {
                if ((long)eut > GTValues.V[i] || (long)eut <= GTValues.VP[i]) continue;
                GTLog.err.println("EUt > Practical Voltage detected. EUt: " + eut + ", Practical Voltage: " + GTValues.VP[i]);
                new IllegalArgumentException().printStackTrace(GTLog.err);
                break;
            }
        }
        this.eut = eut;
        return this;
    }

    public GTRecipeBuilder eut(long eut) {
        return this.eut((int)eut);
    }

    public GTRecipeBuilder specialValue(int specialValue) {
        this.specialValue = specialValue;
        return this;
    }

    public GTRecipeBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public GTRecipeBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public GTRecipeBuilder fake() {
        this.fakeRecipe = true;
        return this;
    }

    public GTRecipeBuilder noBuffer() {
        this.mCanBeBuffered = false;
        return this;
    }

    public GTRecipeBuilder needsEmptyOutput() {
        this.mNeedsEmptyOutput = true;
        return this;
    }

    public GTRecipeBuilder nbtSensitive() {
        this.nbtSensitive = true;
        return this;
    }

    public GTRecipeBuilder setNEIDesc(String ... neiDesc) {
        this.neiDesc = neiDesc;
        return this;
    }

    public GTRecipeBuilder recipeCategory(RecipeCategory recipeCategory) {
        this.recipeCategory = recipeCategory;
        return this;
    }

    public GTRecipeBuilder ignoreCollision() {
        this.checkForCollision = false;
        return this;
    }

    public <T> GTRecipeBuilder metadata(RecipeMetadataKey<T> key, T value) {
        if (this.skip) {
            return this;
        }
        if (this.metadataStorage == null) {
            this.metadataStorage = new RecipeMetadataStorage();
        }
        this.metadataStorage.store(key, value);
        return this;
    }

    @Nullable
    public <T> T getMetadata(RecipeMetadataKey<T> key) {
        if (this.metadataStorage == null) {
            return null;
        }
        return key.cast(this.metadataStorage.getMetadata(key));
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public <T> T getMetadataOrDefault(RecipeMetadataKey<T> key, T defaultValue) {
        if (this.metadataStorage == null) {
            return defaultValue;
        }
        return key.cast(this.metadataStorage.getMetadataOrDefault(key, defaultValue));
    }

    public GTRecipeBuilder requireMods(Mods ... mods) {
        this.skip = Stream.of(mods).anyMatch(mod -> !mod.isModLoaded());
        return this;
    }

    public GTRecipeBuilder requiresCleanRoom() {
        return this.metadata(GTRecipeConstants.CLEANROOM, true);
    }

    public GTRecipeBuilder requiresLowGravity() {
        return this.metadata(GTRecipeConstants.LOW_GRAVITY, true);
    }

    private static <T> T[] copy(T[] arr) {
        return arr == null ? null : (Object[])arr.clone();
    }

    private static int[] copy(int[] arr) {
        return arr == null ? null : (int[])arr.clone();
    }

    public GTRecipeBuilder copy() {
        return new GTRecipeBuilder(GTUtility.copyItemArray(this.inputsBasic), GTRecipeBuilder.copy(this.inputsOreDict), GTUtility.copyItemArray(this.outputs), (ItemStack[][])GTRecipeBuilder.copy(this.alts), GTUtility.copyFluidArray(this.fluidInputs), GTUtility.copyFluidArray(this.fluidOutputs), GTRecipeBuilder.copy(this.chances), this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, GTRecipeBuilder.copy(this.neiDesc), this.recipeCategory, this.metadataStorage, this.checkForCollision, this.skip, this.valid);
    }

    public GTRecipeBuilder copyNoMetadata() {
        return new GTRecipeBuilder(GTUtility.copyItemArray(this.inputsBasic), GTRecipeBuilder.copy(this.inputsOreDict), GTUtility.copyItemArray(this.outputs), (ItemStack[][])GTRecipeBuilder.copy(this.alts), GTUtility.copyFluidArray(this.fluidInputs), GTUtility.copyFluidArray(this.fluidOutputs), GTRecipeBuilder.copy(this.chances), this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, GTRecipeBuilder.copy(this.neiDesc), this.recipeCategory, null, this.checkForCollision, this.skip, this.valid);
    }

    public ItemStack getItemInputBasic(int index) {
        return index < this.inputsBasic.length ? this.inputsBasic[index] : null;
    }

    public Object getItemInputOreDict(int index) {
        return index < this.inputsOreDict.length ? this.inputsOreDict[index] : null;
    }

    public ItemStack getItemOutput(int index) {
        return index < this.outputs.length ? this.outputs[index] : null;
    }

    public FluidStack getFluidInput(int index) {
        return index < this.fluidInputs.length ? this.fluidInputs[index] : null;
    }

    public FluidStack getFluidOutput(int index) {
        return index < this.fluidOutputs.length ? this.fluidOutputs[index] : null;
    }

    public ItemStack[] getItemInputsBasic() {
        return this.inputsBasic;
    }

    public Object[] getItemInputsOreDict() {
        return this.inputsOreDict;
    }

    public ItemStack[] getItemOutputs() {
        return this.outputs;
    }

    public FluidStack[] getFluidInputs() {
        return this.fluidInputs;
    }

    public FluidStack[] getFluidOutputs() {
        return this.fluidOutputs;
    }

    public int getDuration() {
        return this.duration;
    }

    public int[] getChances() {
        return this.chances;
    }

    public int getEUt() {
        return this.eut;
    }

    public RecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public boolean isCheckForCollision() {
        return this.checkForCollision;
    }

    public GTRecipeBuilder clearInvalid() {
        this.valid = true;
        return this;
    }

    public GTRecipeBuilder invalidate() {
        this.valid = false;
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    private static boolean isArrayValid(@Nonnull Object[] arr, int min, int max) {
        int count = 0;
        for (Object o : arr) {
            if (o == null) continue;
            ++count;
        }
        return min <= count && max >= count;
    }

    public GTRecipeBuilder validateNoInput() {
        if (this.skip) {
            return this;
        }
        return GTUtility.isArrayEmptyOrNull(this.inputsBasic) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateNoInputFluid() {
        if (this.skip) {
            return this;
        }
        return GTUtility.isArrayEmptyOrNull(this.fluidInputs) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateNoOutput() {
        if (this.skip) {
            return this;
        }
        return GTUtility.isArrayEmptyOrNull(this.outputs) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateNoOutputFluid() {
        if (this.skip) {
            return this;
        }
        return GTUtility.isArrayEmptyOrNull(this.fluidOutputs) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateInputCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.inputsBasic == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GTRecipeBuilder.isArrayValid(this.inputsBasic, min, max) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateInputFluidCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.fluidInputs == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GTRecipeBuilder.isArrayValid(this.fluidInputs, min, max) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateOutputCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.outputs == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GTRecipeBuilder.isArrayValid(this.outputs, min, max) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateOutputFluidCount(int min, int max) {
        if (this.skip) {
            return this;
        }
        if (this.fluidOutputs == null) {
            return min < 0 ? this : this.invalidate();
        }
        return GTRecipeBuilder.isArrayValid(this.fluidOutputs, min, max) ? this : this.invalidate();
    }

    public GTRecipeBuilder validateAnyInput() {
        if (this.skip) {
            return this;
        }
        if (this.fluidInputs != null && GTRecipeBuilder.isArrayValid(this.fluidInputs, 1, Integer.MAX_VALUE)) {
            return this;
        }
        if (this.inputsBasic != null && GTRecipeBuilder.isArrayValid(this.inputsBasic, 1, Integer.MAX_VALUE)) {
            return this;
        }
        return this.invalidate();
    }

    public GTRecipeBuilder validateAnyOutput() {
        if (this.skip) {
            return this;
        }
        if (this.fluidOutputs != null && GTRecipeBuilder.isArrayValid(this.fluidOutputs, 1, Integer.MAX_VALUE)) {
            return this;
        }
        if (this.outputs != null && GTRecipeBuilder.isArrayValid(this.outputs, 1, Integer.MAX_VALUE)) {
            return this;
        }
        return this.invalidate();
    }

    public Optional<GTRecipe> build() {
        if (this.skip) {
            return Optional.empty();
        }
        if (!this.valid) {
            GTRecipeBuilder.handleInvalidRecipe();
            return Optional.empty();
        }
        this.preBuildChecks();
        return Optional.of(this.decorate(new GTRecipe(this.inputsBasic, this.outputs, this.fluidInputs, this.fluidOutputs, this.chances, this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, this.neiDesc, this.metadataStorage, this.recipeCategory)));
    }

    public GTRecipeBuilder forceOreDictInput() {
        if (this.inputsOreDict != null || this.inputsBasic == null) {
            return this;
        }
        return this.itemInputs((Object[])this.inputsBasic);
    }

    public Optional<GTRecipe.GTRecipe_WithAlt> buildWithAlt() {
        if (this.skip) {
            return Optional.empty();
        }
        if (this.inputsOreDict == null) {
            throw new UnsupportedOperationException();
        }
        if (!this.valid) {
            GTRecipeBuilder.handleInvalidRecipe();
            return Optional.empty();
        }
        this.preBuildChecks();
        return Optional.of(this.decorate(new GTRecipe.GTRecipe_WithAlt(this.inputsBasic, this.outputs, this.fluidInputs, this.fluidOutputs, this.chances, this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.nbtSensitive, this.neiDesc, this.metadataStorage, this.recipeCategory, this.alts)));
    }

    private void preBuildChecks() {
        if (this.duration == -1) {
            throw new IllegalStateException("no duration");
        }
        if (this.eut == -1) {
            throw new IllegalStateException("no eut");
        }
    }

    private <T extends GTRecipe> T decorate(T r) {
        r.mHidden = this.hidden;
        r.mCanBeBuffered = this.mCanBeBuffered;
        r.mNeedsEmptyOutput = this.mNeedsEmptyOutput;
        r.isNBTSensitive = this.nbtSensitive;
        r.mFakeRecipe = this.fakeRecipe;
        r.mEnabled = this.enabled;
        if (this.neiDesc != null) {
            r.setNeiDesc(this.neiDesc);
        }
        this.applyDefaultSpecialValues(r);
        return r;
    }

    private void applyDefaultSpecialValues(GTRecipe recipe) {
        if (recipe.mSpecialValue != 0) {
            return;
        }
        int specialValue = 0;
        if (this.getMetadataOrDefault(GTRecipeConstants.LOW_GRAVITY, false).booleanValue()) {
            specialValue -= 100;
        }
        if (this.getMetadataOrDefault(GTRecipeConstants.CLEANROOM, false).booleanValue()) {
            specialValue -= 200;
        }
        for (RecipeMetadataKey<Integer> ident : GTRecipeMapUtil.SPECIAL_VALUE_ALIASES) {
            Integer metadata = this.getMetadataOrDefault(ident, null);
            if (metadata == null) continue;
            specialValue = metadata;
            break;
        }
        recipe.mSpecialValue = specialValue;
    }

    public Collection<GTRecipe> addTo(IRecipeMap recipeMap) {
        if (this.skip) {
            return Collections.emptyList();
        }
        return recipeMap.doAdd(this);
    }

    public GTRecipeBuilder reset() {
        this.metadataStorage = null;
        this.alts = null;
        this.chances = null;
        this.duration = -1;
        this.enabled = true;
        this.eut = -1;
        this.fakeRecipe = false;
        this.fluidInputs = null;
        this.fluidOutputs = null;
        this.hidden = false;
        this.inputsBasic = null;
        this.inputsOreDict = null;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.nbtSensitive = false;
        this.neiDesc = null;
        this.recipeCategory = null;
        this.outputs = null;
        this.special = null;
        this.specialValue = 0;
        this.skip = false;
        this.valid = true;
        return this;
    }

    static {
        boolean debugAll = System.getProperties().containsKey("gt.recipebuilder.debug") ? Boolean.getBoolean("gt.recipebuilder.debug") : (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        DEBUG_MODE_NULL = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.null");
        DEBUG_MODE_INVALID = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.invalid");
        DEBUG_MODE_COLLISION = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.collision");
        DEBUG_MODE_FULL_ENERGY = debugAll || Boolean.getBoolean("gt.recipebuilder.debug.fullenergy");
        boolean panicAll = Boolean.getBoolean("gt.recipebuilder.panic");
        PANIC_MODE_NULL = panicAll || Boolean.getBoolean("gt.recipebuilder.panic.null");
        PANIC_MODE_INVALID = panicAll || Boolean.getBoolean("gt.recipebuilder.panic.invalid");
        PANIC_MODE_COLLISION = panicAll || Boolean.getBoolean("gt.recipebuilder.panic.collision");
        ENABLE_COLLISION_CHECK = Boolean.getBoolean("gt.recipebuilder.recipe_collision_check");
    }
}

