/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.structure;

import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.StructureError;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.structure.CasingInfo;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StructureWrapperInstanceInfo<MTE extends MTEMultiBlockBase & IStructureProvider<MTE>>
implements IStructureInstance {
    public final StructureWrapper<MTE> structure;
    public Char2IntArrayMap actualCasingCounts = new Char2IntArrayMap();
    public final Reference2IntOpenHashMap<ICasingGroup> casingTiers = new Reference2IntOpenHashMap();

    public StructureWrapperInstanceInfo(StructureWrapper<MTE> structure) {
        this.structure = structure;
    }

    public void clearHatches() {
        this.actualCasingCounts.clear();
        this.casingTiers.clear();
    }

    public void validate(Collection<StructureError> errors, NBTTagCompound context) {
        NBTTagList data = new NBTTagList();
        for (Char2ObjectMap.Entry e : this.structure.casings.char2ObjectEntrySet()) {
            int minCasings;
            int presentCasings;
            if (!this.actualCasingCounts.containsKey(e.getCharKey()) || (presentCasings = this.actualCasingCounts.get(e.getCharKey())) >= (minCasings = this.structure.getCasingMin(e.getCharKey()))) continue;
            NBTTagCompound error = new NBTTagCompound();
            error.func_74778_a("casing", Character.toString(e.getCharKey()));
            error.func_74768_a("req", minCasings);
            error.func_74768_a("pres", presentCasings);
            data.func_74742_a((NBTBase)error);
        }
        if (!data.field_74747_a.isEmpty()) {
            errors.add(StructureError.MISSING_STRUCTURE_WRAPPER_CASINGS);
            context.func_74782_a("structureWrapper", (NBTBase)data);
        }
    }

    public void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        if (!errors.contains((Object)StructureError.MISSING_STRUCTURE_WRAPPER_CASINGS)) {
            return;
        }
        NBTTagList list = context.func_150295_c("structureWrapper", 10);
        for (NBTTagCompound tag : list.field_74747_a) {
            char casing = tag.func_74779_i("casing").charAt(0);
            lines.add(GTUtility.translate("GT5U.gui.missing_casings_specific", ((CasingInfo)this.structure.casings.get((char)casing)).casing.getLocalizedName(), tag.func_74762_e("req"), tag.func_74762_e("pres")));
        }
    }

    @Override
    public void onCasingEncountered(char casing) {
        this.actualCasingCounts.put(casing, this.actualCasingCounts.get(casing) + 1);
    }

    @Override
    public int getCasingTier(ICasingGroup casing, int unset) {
        return this.casingTiers.getOrDefault((Object)casing, unset);
    }

    @Override
    public void setCasingTier(ICasingGroup casing, int tier) {
        this.casingTiers.put((Object)casing, tier);
    }
}

