/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.api.enums.SteamVariant;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamOverclockDescriber
extends OverclockDescriber {
    private final SteamVariant steamVariant;
    private final int euPerTickMultiplier;
    private final int durationMultiplier;

    public SteamOverclockDescriber(SteamVariant steamVariant, int euPerTickMultiplier, int durationMultiplier) {
        super((byte)1);
        this.steamVariant = steamVariant;
        this.euPerTickMultiplier = euPerTickMultiplier;
        this.durationMultiplier = durationMultiplier;
    }

    @Override
    public String getTierString() {
        return StatCollector.func_74838_a((String)("GT5U.steam_variant." + this.steamVariant.toString()));
    }

    @Override
    public OverclockCalculator createCalculator(OverclockCalculator template, GTRecipe recipe) {
        return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(this.euPerTickMultiplier).setDurationModifier(this.durationMultiplier);
    }

    @Override
    public void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getConsumption() <= 0L) {
            return;
        }
        recipeInfo.drawText(GTUtility.trans("152", "Total: ") + this.getTotalPowerString(recipeInfo.calculator));
        recipeInfo.drawText(GTUtility.trans("153", "Usage: ") + this.getSteamUsageString(recipeInfo.calculator));
    }

    private String getTotalPowerString(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(SteamOverclockDescriber.convertEUToSteam(calculator.getConsumption() * (long)calculator.getDuration())) + " Steam";
    }

    private String getSteamUsageString(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(20L * SteamOverclockDescriber.convertEUToSteam(calculator.getConsumption())) + " L/s Steam";
    }

    private static long convertEUToSteam(long eu) {
        return 2L * eu;
    }
}

