/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.crossmod.ae2.IMEAwareItemInventory;
import gregtech.crossmod.ae2.MEItemInventoryHandler;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MTEHatchNonConsumableBase
extends MTEHatch
implements IMEMonitor<IAEItemStack>,
IMEAwareItemInventory,
IAddUIWidgets {
    private ItemStack itemStack = null;
    private int itemCount = 0;
    private boolean isOutputSlotLocked = true;
    private final MEItemInventoryHandler<?> meInventoryHandler = new MEItemInventoryHandler<MTEHatchNonConsumableBase>(this);
    protected int clientItemCount;

    public MTEHatchNonConsumableBase(int ID, String name, String nameRegional, int tier, String description) {
        super(ID, name, nameRegional, tier, 3, new String[]{description, "Will keep its contents when broken"}, new ITexture[0]);
    }

    public MTEHatchNonConsumableBase(String name, int tier, String[] description, ITexture[][][] textures) {
        super(name, tier, 3, description, textures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public void setItemStack(ItemStack stack) {
        this.itemStack = stack;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public void setItemCount(int amount) {
        this.itemCount = amount;
    }

    @Override
    public abstract int getItemCapacity();

    @Override
    public abstract boolean isValidItem(ItemStack var1);

    @Override
    public ItemStack getExtraItemStack() {
        return this.mInventory[1];
    }

    @Override
    public void setExtraItemStack(ItemStack stack) {
        this.mInventory[1] = stack;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_OUT}).setPos(79, 52))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)2).disableInteraction().setBackground(new IDrawable[]{GTUITextures.TRANSPARENT}).setPos(59, 42))).widget(new TextWidget("Item Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(new TextWidget().setStringSupplier(() -> numberFormat.format((long)this.clientItemCount)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.isOutputSlotLocked = !this.isOutputSlotLocked;
        }).setBackground(() -> new UITexture[]{this.isOutputSlotLocked ? GTUITextures.BUTTON_STANDARD_PRESSED : GTUITextures.BUTTON_STANDARD, this.isOutputSlotLocked ? GTUITextures.OVERLAY_BUTTON_RECIPE_LOCKED : GTUITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED}).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.toggle_output_slot_lock")).setTooltipShowUpDelay(5).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.isOutputSlotLocked, val -> {
            this.isOutputSlotLocked = val;
        }), (IWidgetBuilder)builder).setPos(100, 52).setSize(18, 18))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.itemCount, value -> {
            this.clientItemCount = value;
        }));
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add("Capacity: " + EnumChatFormatting.GOLD + this.getItemCapacity() + EnumChatFormatting.GRAY + " Items");
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("itemStack")) {
            ItemStack tContents = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("itemStack"));
            int tSize = stack.field_77990_d.func_74762_e("itemCount");
            if (tContents != null && tSize > 0) {
                tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_CHEST_INFO", "Contains Item: ") + EnumChatFormatting.YELLOW + tContents.func_82833_r() + EnumChatFormatting.GRAY);
                tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_CHEST_AMOUNT", "Item Amount: ") + EnumChatFormatting.GREEN + GTUtility.formatNumbers(tSize) + EnumChatFormatting.GRAY);
            }
        }
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> meMonitorHandlerReceiver, Object o) {
        this.meInventoryHandler.addListener(meMonitorHandlerReceiver, o);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> meMonitorHandlerReceiver) {
        this.meInventoryHandler.removeListener(meMonitorHandlerReceiver);
    }

    public AccessRestriction getAccess() {
        return this.meInventoryHandler.getAccess();
    }

    public boolean isPrioritized(IAEItemStack aeItemStack) {
        return this.meInventoryHandler.isPrioritized(aeItemStack);
    }

    public boolean canAccept(IAEItemStack aeItemStack) {
        return this.meInventoryHandler.canAccept(aeItemStack);
    }

    public int getPriority() {
        return this.meInventoryHandler.getPriority();
    }

    public int getSlot() {
        return this.meInventoryHandler.getSlot();
    }

    public boolean validForPass(int i) {
        return this.meInventoryHandler.validForPass(i);
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        return this.meInventoryHandler.getAvailableItems(out, iteration);
    }

    public IItemList<IAEItemStack> getStorageList() {
        return this.meInventoryHandler.getStorageList();
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        return this.meInventoryHandler.injectItems(input, mode, src);
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        return this.meInventoryHandler.extractItems(request, mode, src);
    }

    public StorageChannel getChannel() {
        return this.meInventoryHandler.getChannel();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.setItemStack(null);
                this.setItemCount(0);
            }
            if (this.getItemStack() == null && this.mInventory[0] != null && this.isValidItem(this.mInventory[0])) {
                this.setItemStack(this.mInventory[0].func_77946_l());
            }
            int count = this.getItemCount();
            ItemStack stack = this.getItemStack();
            int savedCount = count;
            if (this.mInventory[0] != null && count < this.getItemCapacity() && GTUtility.areStacksEqual(this.mInventory[0], stack)) {
                if ((count += this.mInventory[0].field_77994_a) <= this.getItemCapacity()) {
                    this.mInventory[0] = null;
                } else {
                    this.mInventory[0].field_77994_a = count - this.getItemCapacity();
                    count = this.getItemCapacity();
                }
            }
            if (this.mInventory[1] == null && stack != null && !this.isOutputSlotLocked) {
                this.mInventory[1] = stack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(stack.func_77976_d(), count);
                count -= this.mInventory[1].field_77994_a;
            } else if (count > 0 && GTUtility.areStacksEqual(this.mInventory[1], stack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a && !this.isOutputSlotLocked) {
                int tmp = Math.min(count, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                count -= tmp;
            }
            this.setItemCount(count);
            if (stack != null) {
                this.mInventory[2] = stack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(stack.func_77976_d(), count);
            } else {
                this.mInventory[2] = null;
            }
            this.meInventoryHandler.notifyListeners(count - savedCount, stack);
            if (count != savedCount) {
                this.getBaseMetaTileEntity().func_70296_d();
            }
        }
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        NBTTagList invData = new NBTTagList();
        boolean hasInvData = false;
        for (int i = 0; i < 3; ++i) {
            if (this.mInventory[i] == null) continue;
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74774_a("count", (byte)this.mInventory[i].field_77994_a);
            tNBT.func_74777_a("damage", (short)this.mInventory[i].func_77960_j());
            tNBT.func_74777_a("id", (short)Item.func_150891_b((Item)this.mInventory[i].func_77973_b()));
            tNBT.func_74768_a("intSlot", i);
            if (this.mInventory[i].func_77942_o()) {
                tNBT.func_74782_a("tag", (NBTBase)this.mInventory[i].func_77978_p());
            }
            invData.func_74742_a((NBTBase)tNBT);
            hasInvData = true;
        }
        if (this.getItemStack() != null) {
            aNBT.func_74782_a("itemStack", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        if (hasInvData) {
            aNBT.func_74782_a("inventory", (NBTBase)invData);
        }
        if (this.getItemCount() > 0) {
            aNBT.func_74768_a("itemCount", this.getItemCount());
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("itemCount", this.getItemCount());
        if (this.getItemStack() != null) {
            aNBT.func_74782_a("itemStack", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("itemCount")) {
            this.setItemCount(aNBT.func_74762_e("itemCount"));
        }
        if (aNBT.func_74764_b("itemStack")) {
            this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("itemStack"))));
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (GTValues.disableDigitalChestsExternalAccess && this.meInventoryHandler.hasActiveMEConnection()) {
            return false;
        }
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (GTValues.disableDigitalChestsExternalAccess && this.meInventoryHandler.hasActiveMEConnection()) {
            return false;
        }
        if (aIndex != 0) {
            return false;
        }
        if (this.mInventory[0] != null && !GTUtility.areStacksEqual(this.mInventory[0], aStack)) {
            return false;
        }
        if (this.getItemStack() == null) {
            return this.mInventory[1] == null || GTUtility.areStacksEqual(this.mInventory[1], aStack);
        }
        return GTUtility.areStacksEqual(this.getItemStack(), aStack);
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return this.mInventory;
    }
}

