/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTClientPreference;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTTooltipDataCache;
import gregtech.api.util.GTUtility;
import gregtech.api.util.extensions.ArrayExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchInputBus
extends MTEHatch
implements IConfigurationCircuitSupport,
IAddUIWidgets {
    private static final String SORTING_MODE_TOOLTIP = "GT5U.machines.sorting_mode.tooltip";
    private static final String ONE_STACK_LIMIT_TOOLTIP = "GT5U.machines.one_stack_limit.tooltip";
    private static final int BUTTON_SIZE = 18;
    public RecipeMap<?> mRecipeMap = null;
    public boolean disableSort;
    public boolean disableFilter = true;
    public boolean disableLimited = true;
    private int uiButtonCount = 0;

    public MTEHatchInputBus(int id, String name, String nameRegional, int tier) {
        this(id, name, nameRegional, tier, MTEHatchInputBus.getSlots(tier) + 1);
    }

    protected MTEHatchInputBus(int id, String name, String nameRegional, int tier, int slots, String[] description) {
        super(id, name, nameRegional, tier, slots, description, new ITexture[0]);
    }

    public MTEHatchInputBus(int id, String name, String nameRegional, int tier, int slots) {
        super(id, name, nameRegional, tier, slots, ArrayExt.of("Item Input for Multiblocks", "Shift + right click with screwdriver to turn Sort mode on/off", "Capacity: " + MTEHatchInputBus.getSlots(tier) + " stack" + (MTEHatchInputBus.getSlots(tier) >= 2 ? "s" : "")), new ITexture[0]);
    }

    public MTEHatchInputBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, MTEHatchInputBus.getSlots(aTier) + 1, aDescription, aTextures);
    }

    public MTEHatchInputBus(String aName, int aTier, int aSlots, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aSlots, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex != this.getCircuitSlot();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchInputBus(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public int getCircuitSlotX() {
        return 153;
    }

    @Override
    public int getCircuitSlotY() {
        return 63;
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        GTClientPreference tPreference;
        if (!this.getBaseMetaTileEntity().getWorld().field_72995_K && (tPreference = GTMod.gregtechproxy.getClientPreference(this.getBaseMetaTileEntity().getOwnerUuid())) != null) {
            this.disableFilter = !tPreference.isInputBusInitialFilterEnabled();
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.updateSlots();
        }
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length - 1; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        if (!this.disableSort) {
            this.fillStacksIntoFirstSlots();
        }
    }

    protected void fillStacksIntoFirstSlots() {
        int L = this.mInventory.length - 1;
        HashMap<GTUtility.ItemId, Integer> slots = new HashMap<GTUtility.ItemId, Integer>(L);
        HashMap<GTUtility.ItemId, ItemStack> stacks = new HashMap<GTUtility.ItemId, ItemStack>(L);
        ArrayList<GTUtility.ItemId> order = new ArrayList<GTUtility.ItemId>(L);
        ArrayList<Integer> validSlots = new ArrayList<Integer>(L);
        for (int i = 0; i < L; ++i) {
            if (!this.isValidSlot(i)) continue;
            validSlots.add(i);
            ItemStack s = this.mInventory[i];
            if (s == null) continue;
            GTUtility.ItemId sID = GTUtility.ItemId.createNoCopy(s);
            slots.merge(sID, s.field_77994_a, Integer::sum);
            if (!stacks.containsKey(sID)) {
                stacks.put(sID, s);
            }
            order.add(sID);
            this.mInventory[i] = null;
        }
        int slotindex = 0;
        for (GTUtility.ItemId sID : order) {
            int toSet = (Integer)slots.get(sID);
            if (toSet == 0) continue;
            int slot = (Integer)validSlots.get(slotindex);
            ++slotindex;
            this.mInventory[slot] = ((ItemStack)stacks.get(sID)).func_77946_l();
            this.mInventory[slot].field_77994_a = toSet = Math.min(toSet, this.mInventory[slot].func_77976_d());
            slots.merge(sID, toSet, (a, b) -> a - b);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("disableSort", this.disableSort);
        aNBT.func_74757_a("disableFilter", this.disableFilter);
        aNBT.func_74757_a("disableLimited", this.disableLimited);
        if (this.mRecipeMap != null) {
            aNBT.func_74778_a("recipeMap", this.mRecipeMap.unlocalizedName);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.disableSort = aNBT.func_74767_n("disableSort");
        this.disableFilter = aNBT.func_74767_n("disableFilter");
        if (aNBT.func_74764_b("disableLimited")) {
            this.disableLimited = aNBT.func_74767_n("disableLimited");
        }
        this.mRecipeMap = RecipeMap.getFromOldIdentifier(aNBT.func_74779_i("recipeMap"));
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverAtSide(side).isGUIClickable()) {
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (this.disableSort) {
                this.disableSort = false;
            } else if (this.disableLimited) {
                this.disableLimited = false;
            } else {
                this.disableSort = true;
                this.disableLimited = true;
            }
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableSort." + this.disableSort)) + "   " + StatCollector.func_74838_a((String)("GT5U.hatch.disableLimited." + this.disableLimited)));
        } else {
            this.disableFilter = !this.disableFilter;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableFilter." + this.disableFilter)));
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (aIndex == this.getCircuitSlot()) {
            return false;
        }
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return !(side != this.getBaseMetaTileEntity().getFrontFacing() || aIndex == this.getCircuitSlot() || this.mRecipeMap != null && !this.disableFilter && !this.mRecipeMap.containsInput(aStack) || !this.disableLimited && !this.limitedAllowPutStack(aIndex, aStack));
    }

    protected boolean limitedAllowPutStack(int aIndex, ItemStack aStack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!GTUtility.areStacksEqual(GTOreDictUnificator.get_nocopy(aStack), this.mInventory[i])) continue;
            return i == aIndex;
        }
        return this.mInventory[aIndex] == null;
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    public int getCircuitSlot() {
        return MTEHatchInputBus.getSlots(this.mTier);
    }

    private void addSortStacksButton(ModularWindow.Builder builder) {
        builder.widget(this.createToggleButton(() -> !this.disableSort, val -> {
            this.disableSort = val == false;
        }, GTUITextures.OVERLAY_BUTTON_SORTING_MODE, () -> this.mTooltipCache.getData(SORTING_MODE_TOOLTIP, new Object[0])));
    }

    private void addOneStackLimitButton(ModularWindow.Builder builder) {
        builder.widget(this.createToggleButton(() -> !this.disableLimited, val -> {
            this.disableLimited = val == false;
            this.updateSlots();
        }, GTUITextures.OVERLAY_BUTTON_ONE_STACK_LIMIT, () -> this.mTooltipCache.getData(ONE_STACK_LIMIT_TOOLTIP, new Object[0])));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addCloseListener(() -> {
            this.uiButtonCount = 0;
        });
        this.addSortStacksButton(builder);
        this.addOneStackLimitButton(builder);
        int slotCount = this.func_70302_i_();
        if (this.allowSelectCircuit()) {
            --slotCount;
        }
        switch (slotCount) {
            case 1: {
                this.getBaseMetaTileEntity().add1by1Slot(builder, new IDrawable[0]);
                break;
            }
            case 4: {
                this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[0]);
                break;
            }
            case 9: {
                this.getBaseMetaTileEntity().add3by3Slots(builder, new IDrawable[0]);
                break;
            }
            case 16: {
                this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[0]);
                break;
            }
        }
    }

    private Widget createToggleButton(Supplier<Boolean> getter, Consumer<Boolean> setter, UITexture picture, Supplier<GTTooltipDataCache.TooltipData> tooltipDataSupplier) {
        return new CycleButtonWidget().setToggle(getter, setter).setStaticTexture((IDrawable)picture).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setTooltipShowUpDelay(5).setPos(7 + this.uiButtonCount++ * 18, 62).setSize(18, 18).setGTTooltip(tooltipDataSupplier);
    }
}

