/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.tile.powersink.IC2;
import cofh.api.energy.IEnergyReceiver;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.NodeList;
import gregtech.api.graphs.PowerNode;
import gregtech.api.graphs.PowerNodes;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.graphs.paths.PowerNodePath;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTGCCompat;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverSolarPanel;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactorChamber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTECable
extends MetaPipeEntity
implements IMetaTileEntityCable {
    public final float mThickNess;
    public final Materials mMaterial;
    public final long mCableLossPerMeter;
    public final long mAmperage;
    public final long mVoltage;
    public final boolean mInsulated;
    public final boolean mCanShock;
    public int mTransferredAmperage = 0;

    public MTECable(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aID, aName, aNameRegional, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    public MTECable(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mInsulated ? 9 : 8);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, int facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (!this.mInsulated) {
            return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], Dyes.getModulation(colorIndex, this.mMaterial.mRGBa))};
        }
        if (active) {
            float tThickNess = this.getThickness();
            if (tThickNess < 0.124f) {
                return new ITexture[]{TextureFactory.of(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.624f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_MEDIUM_PLUS, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (!this.mCanShock) {
            return;
        }
        BaseMetaPipeEntity baseEntity = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        if (!(aEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase livingEntity = (EntityLivingBase)aEntity;
        NodePath nodePath = baseEntity.getNodePath();
        if (!(nodePath instanceof PowerNodePath)) {
            return;
        }
        PowerNodePath powerPath = (PowerNodePath)nodePath;
        if (this.isCoverOnSide(baseEntity, livingEntity)) {
            return;
        }
        if ((baseEntity.mConnections & 0x80) == 1) {
            return;
        }
        long amperage = powerPath.getAmperage();
        long voltage = powerPath.getVoltage();
        if (amperage == 0L) {
            return;
        }
        GTUtility.applyElectricityDamage(livingEntity, voltage, amperage);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(ForgeDirection side) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.mTransferredAmperage * 64;
    }

    @Override
    public int maxProgresstime() {
        return (int)this.mAmperage * 64;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long voltage, long amperage) {
        if (!this.isConnectedAtSide(side) && side != ForgeDirection.UNKNOWN) {
            return 0L;
        }
        if (!this.getBaseMetaTileEntity().getCoverAtSide(side).letsEnergyIn()) {
            return 0L;
        }
        return this.transferElectricity(side, voltage, amperage, null);
    }

    @Override
    public long transferElectricity(ForgeDirection side, long voltage, long amperage, HashSet<TileEntity> alreadyPassedSet) {
        if (!this.getBaseMetaTileEntity().isServerSide() || !this.isConnectedAtSide(side) && side != ForgeDirection.UNKNOWN) {
            return 0L;
        }
        BaseMetaPipeEntity tBase = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        Node node = tBase.getNode();
        if (!(node instanceof PowerNode)) {
            return 0L;
        }
        PowerNode tNode = (PowerNode)node;
        int tPlace = 0;
        Node[] tToPower = new Node[tNode.mConsumers.size()];
        if (tNode.mHadVoltage) {
            for (ConsumerNode consumer : tNode.mConsumers) {
                if (!consumer.needsEnergy()) continue;
                tToPower[tPlace++] = consumer;
            }
        } else {
            tNode.mHadVoltage = true;
            for (ConsumerNode consumer : tNode.mConsumers) {
                tToPower[tPlace++] = consumer;
            }
        }
        return PowerNodes.powerNode(tNode, null, new NodeList(tToPower), (int)voltage, (int)amperage);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L && aBaseMetaTileEntity.isServerSide() && (!GTMod.gregtechproxy.gt6Cable || this.mCheckConnections)) {
            this.checkConnections();
        }
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!aPlayer.func_70093_af()) {
            return;
        }
        ItemStack handItem = aPlayer.field_71071_by.func_70448_g();
        if (handItem == null) {
            return;
        }
        IMetaTileEntity meta = ItemMachines.getMetaTileEntity(handItem);
        if (!(meta instanceof MTECable)) {
            return;
        }
        MTECable handCable = (MTECable)meta;
        MTECable oldCable = this;
        byte oldConnections = oldCable.mConnections;
        ArrayList<ForgeDirection> oldConnectedSides = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!oldCable.isConnectedAtSide(side)) continue;
            oldConnectedSides.add(side);
        }
        short newMetaID = (short)handItem.func_77960_j();
        long oldVoltage = this.mVoltage;
        long oldAmperage = this.mAmperage;
        if (this.getClass() == handCable.getClass() && this.mMaterial == handCable.mMaterial && this.mVoltage == handCable.mVoltage && this.mAmperage == handCable.mAmperage) {
            return;
        }
        short oldMetaID = (short)aBaseMetaTileEntity.getMetaTileID();
        MTECable newCable = new MTECable(handCable.mName, handCable.mThickNess, handCable.mMaterial, handCable.mCableLossPerMeter, handCable.mAmperage, handCable.mVoltage, handCable.mInsulated, handCable.mCanShock);
        aBaseMetaTileEntity.setMetaTileID(newMetaID);
        aBaseMetaTileEntity.setMetaTileEntity(newCable);
        aBaseMetaTileEntity.func_70296_d();
        aBaseMetaTileEntity.issueBlockUpdate();
        if (newCable.getBaseMetaTileEntity() != null) {
            for (ForgeDirection side : oldConnectedSides) {
                IGregTechTileEntity neighborTile = newCable.getBaseMetaTileEntity().getIGregTechTileEntityAtSide(side);
                int result = newCable.connect(side);
                if (neighborTile != null) {
                    if (!(neighborTile.getMetaTileEntity() instanceof IConnectable)) continue;
                    if (result > 0) {
                        ((IConnectable)((Object)neighborTile.getMetaTileEntity())).connect(side.getOpposite());
                        continue;
                    }
                    newCable.disconnect(side);
                    continue;
                }
                newCable.disconnect(side);
            }
        }
        aBaseMetaTileEntity.issueTextureUpdate();
        if (!aPlayer.field_71075_bZ.field_75098_d) {
            ItemStack oldCableStack = new ItemStack(handItem.func_77973_b(), 1, (int)oldMetaID);
            boolean addedToInventory = false;
            if (oldCableStack != null) {
                for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
                    ItemStack slot = aPlayer.field_71071_by.field_70462_a[i];
                    if (slot == null || slot.func_77973_b() != oldCableStack.func_77973_b() || slot.func_77960_j() != oldCableStack.func_77960_j() || slot.field_77994_a >= slot.func_77976_d()) continue;
                    ++slot.field_77994_a;
                    addedToInventory = true;
                    break;
                }
                if (!addedToInventory) {
                    addedToInventory = aPlayer.field_71071_by.func_70441_a(oldCableStack);
                }
                if (!addedToInventory) {
                    aPlayer.func_71019_a(oldCableStack, false);
                }
            }
            --handItem.field_77994_a;
            if (handItem.field_77994_a <= 0) {
                aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, null);
            }
        }
        if (oldAmperage != handCable.mAmperage || oldVoltage != handCable.mVoltage) {
            StringBuilder message = new StringBuilder();
            if (oldAmperage != handCable.mAmperage) {
                message.append(oldAmperage).append("A \u2192 ").append(handCable.mAmperage > oldAmperage ? EnumChatFormatting.GREEN : EnumChatFormatting.RED).append(handCable.mAmperage).append("A").append(EnumChatFormatting.RESET);
            }
            if (oldAmperage != handCable.mAmperage && oldVoltage != handCable.mVoltage) {
                message.append(" | ");
            }
            if (oldVoltage != handCable.mVoltage) {
                message.append(oldVoltage).append("V \u2192 ").append(handCable.mVoltage > oldVoltage ? EnumChatFormatting.GREEN : EnumChatFormatting.RED).append(handCable.mVoltage).append("V").append(EnumChatFormatting.RESET);
            }
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.item.cable.swapped") + " " + message);
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GTMod.gregtechproxy.gt6Cable && GTModHandler.damageOrDechargeItem(aPlayer.field_71071_by.func_70448_g(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(wrenchingSide)) {
                this.disconnect(wrenchingSide);
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("215", "Disconnected"));
            } else if (!GTMod.gregtechproxy.costlyCableConnection && this.connect(wrenchingSide) > 0) {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("214", "Connected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GTMod.gregtechproxy.gt6Cable && GTModHandler.damageOrDechargeItem(aPlayer.field_71071_by.func_70448_g(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(wrenchingSide)) {
                this.disconnect(wrenchingSide);
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("215", "Disconnected"));
            } else if ((!GTMod.gregtechproxy.costlyCableConnection || GTModHandler.consumeSolderingMaterial(aPlayer)) && this.connect(wrenchingSide) > 0) {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("214", "Connected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(Cover cover) {
        return cover.letsEnergyIn();
    }

    @Override
    public boolean letsOut(Cover cover) {
        return cover.letsEnergyOut();
    }

    @Override
    public boolean canConnect(ForgeDirection side, TileEntity tileEntity) {
        TileEntity ic2Energy;
        IC2 ic2sink;
        IEnergyConnected energyConnected;
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        ForgeDirection oppositeSide = side.getOpposite();
        if (tileEntity instanceof IEnergyConnected && ((energyConnected = (IEnergyConnected)tileEntity).inputEnergyFrom(oppositeSide, false) || energyConnected.outputsEnergyTo(oppositeSide, false))) {
            return true;
        }
        if (baseMetaTile.getCoverAtSide(side) instanceof CoverSolarPanel) {
            return true;
        }
        if (Mods.GalacticraftCore.isModLoaded() && GTGCCompat.canConnect(tileEntity, oppositeSide)) {
            return true;
        }
        if (tileEntity instanceof IC2 && (ic2sink = (IC2)tileEntity).acceptsEnergyFrom((TileEntity)baseMetaTile, oppositeSide)) {
            return true;
        }
        if (tileEntity instanceof IReactorChamber) {
            ic2Energy = (TileEntity)((IReactorChamber)tileEntity).getReactor();
        } else {
            TileEntity tileEntity2 = ic2Energy = tileEntity == null || tileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tileEntity : EnergyNet.instance.getTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        }
        if (ic2Energy instanceof IEnergySink && ((IEnergySink)ic2Energy).acceptsEnergyFrom((TileEntity)baseMetaTile, oppositeSide)) {
            return true;
        }
        if (GTMod.gregtechproxy.ic2EnergySourceCompat && ic2Energy instanceof IEnergySource && ((IEnergySource)ic2Energy).emitsEnergyTo((TileEntity)baseMetaTile, oppositeSide)) {
            return true;
        }
        if (GregTechAPI.mOutputRF && tileEntity instanceof IEnergyReceiver && ((IEnergyReceiver)tileEntity).canConnectEnergy(oppositeSide)) {
            return true;
        }
        return GregTechAPI.mInputRF && tileEntity instanceof IEnergyEmitter && ((IEnergyEmitter)tileEntity).emitsEnergyTo((TileEntity)baseMetaTile, oppositeSide);
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GTMod.gregtechproxy.gt6Cable;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.item.cable.max_voltage") + ": %%%" + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mVoltage) + " (" + GTUtility.getColoredTierNameFromVoltage(this.mVoltage) + EnumChatFormatting.GREEN + ")" + EnumChatFormatting.GRAY, StatCollector.func_74838_a((String)"GT5U.item.cable.max_amperage") + ": %%%" + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mAmperage) + EnumChatFormatting.GRAY, StatCollector.func_74838_a((String)"GT5U.item.cable.loss") + ": %%%" + EnumChatFormatting.RED + GTUtility.formatNumbers(this.mCableLossPerMeter) + EnumChatFormatting.GRAY + "%%% " + StatCollector.func_74838_a((String)"GT5U.item.cable.eu_volt")};
    }

    @Override
    public float getCollisionThickness() {
        return this.mThickNess;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (GTMod.gregtechproxy.gt6Cable) {
            aNBT.func_74774_a("mConnections", this.mConnections);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (GTMod.gregtechproxy.gt6Cable) {
            this.mConnections = aNBT.func_74771_c("mConnections");
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        BaseMetaPipeEntity base = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        PowerNodePath path = (PowerNodePath)base.getNodePath();
        path.reloadLocks();
        if (path == null) {
            return new String[]{EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.infodata.cable.failed") + EnumChatFormatting.RESET};
        }
        long currAmp = path.getAmperage();
        long currVoltage = path.getVoltage();
        double avgAmp = path.getAvgAmperage();
        double avgVoltage = path.getAvgVoltage();
        long maxVoltageOut = (this.mVoltage - this.mCableLossPerMeter) * this.mAmperage;
        return new String[]{StatCollector.func_74837_a((String)"GT5U.infodata.cable.amperage", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(currAmp) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mAmperage) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.cable.voltage_out", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(currVoltage) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxVoltageOut) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.cable.avg_amperage", (Object[])new Object[]{EnumChatFormatting.YELLOW + GTUtility.formatNumbers(avgAmp) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.cable.avg_output", (Object[])new Object[]{EnumChatFormatting.YELLOW + GTUtility.formatNumbers(avgVoltage) + EnumChatFormatting.RESET})};
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        if (!GTMod.gregtechproxy.ic2EnergySourceCompat) {
            return false;
        }
        if (this.mConnections != 0) {
            IGregTechTileEntity baseMeta = this.getBaseMetaTileEntity();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tEmitter;
                if (!this.isConnectedAtSide(side)) continue;
                TileEntity tTileEntity = baseMeta.getTileEntityAtSide(side);
                TileEntity tileEntity = tEmitter = tTileEntity == null || tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e);
                if (!(tEmitter instanceof IEnergyEmitter)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void reloadLocks() {
        BaseMetaPipeEntity pipe = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        if (pipe.getNode() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Cover cover;
                if (!this.isConnectedAtSide(side) || !(cover = pipe.getCoverAtSide(side)).isValid()) continue;
                if (!this.letsIn(cover) || !this.letsOut(cover)) {
                    pipe.addToLock(pipe, side);
                    continue;
                }
                pipe.removeFromLock(pipe, side);
            }
        } else {
            boolean dontAllow = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Cover cover;
                if (!this.isConnectedAtSide(side) || !(cover = pipe.getCoverAtSide(side)).isValid() || this.letsIn(cover) && this.letsOut(cover)) continue;
                dontAllow = true;
            }
            if (dontAllow) {
                pipe.addToLock(pipe, ForgeDirection.DOWN);
            } else {
                pipe.removeFromLock(pipe, ForgeDirection.DOWN);
            }
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.item.cable.max_voltage") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mVoltage) + " (" + GTUtility.getColoredTierNameFromVoltage(this.mVoltage) + EnumChatFormatting.GREEN + ")");
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.item.cable.max_amperage") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mAmperage));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.item.cable.loss") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.mCableLossPerMeter) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.item.cable.eu_volt"));
    }
}

