/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.GTPPCore;
import java.util.HashMap;
import java.util.HashSet;

public class TAE {
    public static int gtPPLastUsedIndex = 64;
    public static int secondaryIndex = 0;
    public static HashMap<Integer, ITexture> mTAE = new HashMap();
    private static final HashSet<Integer> mFreeSlots = new HashSet(64);

    public static boolean registerTexture(int aPage, int aID, ITexture texture) {
        int aRealID = aID + aPage * 16;
        return TAE.registerTexture(64 + aRealID, texture);
    }

    public static boolean registerTexture(int aID, ITexture texture) {
        if (mFreeSlots.contains(aID)) {
            mFreeSlots.remove(aID);
            mTAE.put(aID, texture);
            return true;
        }
        GTPPCore.crash("Tried to register texture with ID " + aID + " to TAE, but it is already in use.");
        return false;
    }

    public static void finalizeTAE() {
        int j;
        StringBuilder aFreeSpaces = new StringBuilder();
        StringBuilder aPageAndSlotFree = new StringBuilder();
        Integer[] aTemp = mFreeSlots.toArray(new Integer[0]);
        for (int i = 0; i < mFreeSlots.size(); ++i) {
            j = aTemp[i];
            aFreeSpaces.append(j);
            aPageAndSlotFree.append(TAE.getPageFromIndex(j));
            if (i == mFreeSlots.size() - 1) continue;
            aFreeSpaces.append(", ");
            aPageAndSlotFree.append(", ");
        }
        Logger.INFO("Free Indexes within TAE: " + aFreeSpaces);
        Logger.INFO("Free Page slots within TAE: " + aPageAndSlotFree);
        Logger.INFO("Filling them with ERROR textures.");
        Object object = aTemp;
        j = ((Integer[])object).length;
        for (int i = 0; i < j; ++i) {
            int aFreeSlot = object[i];
            TAE.registerTexture(aFreeSlot, TextureFactory.of(ModBlocks.blockCasingsTieredGTPP, 15));
        }
        Logger.INFO("Finalising TAE.");
        object = mTAE.keySet().iterator();
        while (object.hasNext()) {
            int aKeyTae = (Integer)object.next();
            Textures.BlockIcons.setCasingTextureForId(aKeyTae, mTAE.get(aKeyTae));
        }
        Logger.INFO("Finalised TAE.");
    }

    public static ITexture getTexture(int index) {
        if (gtPPLastUsedIndex >= 128) {
            return Textures.BlockIcons.getCasingTextureForId(8192 + index);
        }
        return Textures.BlockIcons.getCasingTextureForId(64 + index);
    }

    public static int GTPP_INDEX(int ID) {
        if (ID >= 64 && gtPPLastUsedIndex >= 128) {
            return 128 + ID;
        }
        return 64 + ID;
    }

    public static int getIndexFromPage(int page, int blockMeta) {
        int id = 64;
        id += page == 0 ? 0 : (page == 1 ? 16 : (page == 2 ? 32 : (page == 3 ? 48 : (page == 4 ? 64 : 0))));
        return id += blockMeta;
    }

    public static String getPageFromIndex(int aIndex) {
        int aPage = 0;
        int aSlot = 0;
        int aAdjustedIndex = aIndex > 64 ? aIndex - 64 : aIndex;
        aPage = aAdjustedIndex / 16;
        aSlot = aAdjustedIndex - 16 * aPage;
        return "[" + aIndex + " | " + aPage + ", " + aSlot + "]";
    }

    static {
        for (int i = 64; i < 128; ++i) {
            mFreeSlots.add(i);
        }
        Logger.INFO("Initialising TAE.");
    }
}

