/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.casing;

import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ICasing
extends ImmutableBlockMeta {
    public int getTextureId();

    default public ItemStack toStack(int amount) {
        return new ItemStack(this.getBlock(), amount, this.getBlockMeta());
    }

    default public String getLocalizedName() {
        return new ItemStack(this.getBlock(), 1, this.getBlockMeta()).func_82833_r();
    }

    default public <T> IStructureElement<T> asElement(CasingElementContext context) {
        return StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)this.getBlock(), (int)this.getBlockMeta()));
    }

    default public ITexture getCasingTexture() {
        return Textures.BlockIcons.getCasingTextureForId(this.getTextureId());
    }

    default public boolean isTiered() {
        return false;
    }

    public static ICasing ofBlock(final Block block, final int meta) {
        return new ICasing(){

            @Override
            public int getTextureId() {
                return -1;
            }

            @NotNull
            public Block getBlock() {
                return block;
            }

            public int getBlockMeta() {
                return meta;
            }
        };
    }

    public static interface CasingElementContext {
        public ICasingGroup getGroup();
    }
}

