/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import com.google.common.collect.SetMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.internal.IThaumcraftCompat;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GTHashSet;
import gregtech.api.objects.GTItemStack;
import gregtech.api.threads.RunnableCableUpdate;
import gregtech.api.threads.RunnableMachineUpdate;
import gregtech.api.util.CircuitryBehavior;
import gregtech.api.util.GTCreativeTab;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.world.GTWorldgen;
import gregtech.common.GTDummyWorld;
import gregtech.common.covers.CoverPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GregTechAPI {
    public static final Collection<Map<?, ?>> sItemStackMappings = new ArrayList();
    public static final Collection<SetMultimap<GTItemStack, ?>> itemStackMultiMaps = new ArrayList();
    public static final short MAXIMUM_METATILE_IDS = 32766;
    public static final CreativeTabs TAB_GREGTECH = new GTCreativeTab("Main", "Main");
    public static final CreativeTabs TAB_GREGTECH_MATERIALS = new GTCreativeTab("Materials", "Materials");
    public static final CreativeTabs TAG_GREGTECH_CASINGS = new GTCreativeTab("Casings", "Casings"){

        @Override
        public ItemStack func_151244_d() {
            return ItemList.Casing_RobustTungstenSteel.get(1L, new Object[0]);
        }
    };
    public static final CreativeTabs TAB_GREGTECH_ORES = new GTCreativeTab("Ores", "Ores");
    public static final IMetaTileEntity[] METATILEENTITIES = new IMetaTileEntity[32766];
    public static final Map<Integer, CircuitryBehavior> sCircuitryBehaviors = new ConcurrentHashMap<Integer, CircuitryBehavior>();
    public static final Map<Block, Integer> sMachineIDs = new ConcurrentHashMap<Block, Integer>();
    public static final Map<Integer, Byte> sWirelessRedstone = new ConcurrentHashMap<Integer, Byte>();
    public static final Map<String, Map<String, Map<CoverPosition, Byte>>> sAdvancedWirelessRedstone = new ConcurrentHashMap<String, Map<String, Map<CoverPosition, Byte>>>();
    public static final Map<Integer, Integer> sIDSUList = new ConcurrentHashMap<Integer, Integer>();
    public static final Map<String, ItemStack> sBookList = new ConcurrentHashMap<String, ItemStack>();
    public static final GTHashSet sToolList = new GTHashSet();
    public static final GTHashSet sCrowbarList = new GTHashSet();
    public static final GTHashSet sScrewdriverList = new GTHashSet();
    public static final GTHashSet sWrenchList = new GTHashSet();
    public static final GTHashSet sSoftHammerList = new GTHashSet();
    public static final GTHashSet sHardHammerList = new GTHashSet();
    public static final GTHashSet sWireCutterList = new GTHashSet();
    public static final GTHashSet sSolderingToolList = new GTHashSet();
    public static final GTHashSet sSolderingMetalList = new GTHashSet();
    public static final GTHashSet sJackhammerList = new GTHashSet();
    public static final GTHashSet sGasHazmatList = new GTHashSet();
    public static final GTHashSet sBioHazmatList = new GTHashSet();
    public static final GTHashSet sFrostHazmatList = new GTHashSet();
    public static final GTHashSet sHeatHazmatList = new GTHashSet();
    public static final GTHashSet sRadioHazmatList = new GTHashSet();
    public static final GTHashSet sElectroHazmatList = new GTHashSet();
    public static final Collection<Integer> sDimensionalList = new HashSet<Integer>();
    public static final List<GTWorldgen> sWorldgenList = new ArrayList<GTWorldgen>();
    public static final Materials[] sGeneratedMaterials = new Materials[1000];
    public static volatile int VERSION = 509;
    public static IThaumcraftCompat sThaumcraftCompat;
    public static List<Runnable> sBeforeGTPreload;
    public static List<Runnable> sAfterGTPreload;
    public static List<Runnable> sBeforeGTLoad;
    public static List<Runnable> sAfterGTLoad;
    public static List<Runnable> sBeforeGTPostload;
    public static List<Runnable> sAfterGTPostload;
    public static List<Runnable> sFirstWorldTick;
    public static List<Runnable> sBeforeGTServerstart;
    public static List<Runnable> sAfterGTServerstart;
    public static List<Runnable> sBeforeGTServerstop;
    public static List<Runnable> sAfterGTServerstop;
    public static List<Runnable> sGTBlockIconload;
    public static List<Runnable> sGTItemIconload;
    public static List<Runnable> sGTCompleteLoad;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sBlockIcons;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sItemIcons;
    public static int TICKS_FOR_LAG_AVERAGING;
    public static int MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING;
    public static Block sBlockMachines;
    public static Block sBlockOres1;
    public static Block sBlockOresUb1;
    public static Block sBlockOresUb2;
    public static Block sBlockOresUb3;
    public static Block sBlockMetal1;
    public static Block sBlockMetal2;
    public static Block sBlockMetal3;
    public static Block sBlockMetal4;
    public static Block sBlockMetal5;
    public static Block sBlockMetal6;
    public static Block sBlockMetal7;
    public static Block sBlockMetal8;
    public static Block sBlockMetal9;
    public static Block sBlockGem1;
    public static Block sBlockGem2;
    public static Block sBlockGem3;
    public static Block sBlockReinforced;
    public static Block sBlockGranites;
    public static Block sBlockConcretes;
    public static Block sBlockStones;
    public static Block sBlockCasings1;
    public static Block sBlockCasings2;
    public static Block sBlockCasings3;
    public static Block sBlockCasings4;
    public static Block sBlockCasings5;
    public static Block sBlockCasings6;
    public static Block sBlockCasings8;
    public static Block sBlockCasings9;
    public static Block sBlockCasings10;
    public static Block sBlockCasings11;
    public static Block sBlockCasings12;
    public static Block sBlockCasingsSteam;
    public static Block sSolenoidCoilCasings;
    public static Block sBlockCasingsNH;
    public static Block sBlockLongDistancePipes;
    public static Block sDroneRender;
    public static Block sBlockFrames;
    public static Block sBlockGlass1;
    public static Block sBlockTintedGlass;
    public static Block sLaserRender;
    public static Block sWormholeRender;
    public static Block sBlackholeRender;
    public static boolean sTimber;
    public static boolean sDrinksAlwaysDrinkable;
    public static boolean sMultiThreadedSounds;
    public static boolean sDoShowAllItemsInCreative;
    public static boolean sColoredGUI;
    public static boolean sMachineMetalGUI;
    public static boolean sMachineExplosions;
    public static boolean sMachineFlammable;
    public static boolean sMachineNonWrenchExplosions;
    public static boolean sMachineRainExplosions;
    public static boolean sMachineThunderExplosions;
    public static boolean sMachineFireExplosions;
    public static boolean sMachineWireFire;
    public static boolean mOutputRF;
    public static boolean mInputRF;
    public static boolean mRFExplosions;
    public static boolean mServerStarted;
    public static int mEUtoRF;
    public static int mRFtoEU;
    public static boolean sUseMachineMetal;
    public static boolean mUseOnlyGoodSolderingMaterials;
    private static final String aTextIC2Lower;
    public static boolean sUnificationEntriesRegistered;
    public static boolean sPreloadStarted;
    public static boolean sPreloadFinished;
    public static boolean sLoadStarted;
    public static boolean sLoadFinished;
    public static boolean sPostloadStarted;
    public static boolean sPostloadFinished;
    public static boolean sFullLoadFinished;
    private static final IntFunction<TileEntity>[] teCreators;
    private static final Set<Class<?>> dummyWorlds;

    public static void addDummyWorld(Class<?> clazz) {
        dummyWorlds.add(clazz);
    }

    public static boolean isDummyWorld(@Nonnull World w) {
        return dummyWorlds.contains(w.getClass());
    }

    public static ItemStack getUnificatedOreDictStack(ItemStack aOreStack) {
        if (!sPreloadFinished) {
            GTLog.err.println("GregTechAPI ERROR: " + aOreStack.func_77973_b() + "." + aOreStack.func_77960_j() + " - OreDict Unification Entries are not registered now, please call it in the postload phase.");
        }
        return GTOreDictUnificator.get(true, aOreStack);
    }

    public static boolean causeMachineUpdate(World aWorld, int aX, int aY, int aZ) {
        if (aWorld != null && !aWorld.field_72995_K && !GregTechAPI.isDummyWorld(aWorld)) {
            RunnableMachineUpdate.setMachineUpdateValues(aWorld, aX, aY, aZ);
            return true;
        }
        return false;
    }

    public static boolean causeCableUpdate(World aWorld, int aX, int aY, int aZ) {
        if (aWorld == null || aWorld.field_72995_K || GregTechAPI.isDummyWorld(aWorld)) {
            return false;
        }
        RunnableCableUpdate.setCableUpdateValues(aWorld, aX, aY, aZ);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, int aMeta) {
        if (aBlock == null) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        sMachineIDs.put(aBlock, aMeta);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, boolean ... aMeta) {
        if (aBlock == null || aMeta == null || aMeta.length == 0) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        int rMeta = 0;
        for (int i = 0; i < aMeta.length && i < 16; i = (int)((byte)(i + 1))) {
            if (!aMeta[i]) continue;
            rMeta |= GTValues.B[i];
        }
        sMachineIDs.put(aBlock, rMeta);
        return true;
    }

    public static boolean isMachineBlock(Block aBlock, int aMeta) {
        Integer id;
        if (aBlock != null && (id = sMachineIDs.get(aBlock)) != null) {
            if (id == -1) {
                return true;
            }
            return (id & GTValues.B[aMeta]) != 0;
        }
        return false;
    }

    public static BaseMetaTileEntity constructBaseMetaTileEntity() {
        try {
            return new BaseMetaTileEntity();
        }
        catch (Throwable e) {
            GTLog.err.println("GTMod: Fatal Error occurred while initializing TileEntities, crashing Minecraft.");
            e.printStackTrace(GTLog.err);
            throw new RuntimeException(e);
        }
    }

    public static boolean registerWrench(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sWrenchList);
    }

    public static boolean registerCrowbar(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sCrowbarList);
    }

    public static boolean registerScrewdriver(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sScrewdriverList);
    }

    public static boolean registerSoftHammer(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sSoftHammerList);
    }

    public static boolean registerHardHammer(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sHardHammerList);
    }

    public static boolean registerWireCutter(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sWireCutterList);
    }

    public static boolean registerSolderingTool(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sSolderingToolList);
    }

    public static boolean registerSolderingMetal(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sSolderingMetalList);
    }

    public static boolean registerTool(ItemStack aTool, Collection<GTItemStack> aToolList) {
        if (aTool == null || GTUtility.isStackInList(aTool, (Collection<GTItemStack>)sToolList) || !aTool.func_77973_b().func_77645_m() && !GTModHandler.isElectricItem(aTool) && !(aTool.func_77973_b() instanceof IDamagableItem)) {
            return false;
        }
        aToolList.add(new GTItemStack(GTUtility.copyAmount(1, aTool)));
        sToolList.add(new GTItemStack(GTUtility.copyAmount(1, aTool)));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setBlockIconRegister(IIconRegister aIconRegister) {
        sBlockIcons = aIconRegister;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setItemIconRegister(IIconRegister aIconRegister) {
        sItemIcons = aIconRegister;
    }

    public static void registerTileEntityConstructor(int meta, IntFunction<TileEntity> constructor) {
        if (meta < 0 || meta > 15 || constructor == null) {
            throw new IllegalArgumentException();
        }
        if (teCreators[meta] != null) {
            throw new IllegalStateException("previous constructor: " + teCreators[meta] + " new constructor: " + constructor + " meta:" + meta);
        }
        GregTechAPI.teCreators[meta] = constructor;
    }

    public static TileEntity createTileEntity(int meta) {
        if (teCreators[meta = GTUtility.clamp(meta, 0, 15)] == null) {
            return null;
        }
        return teCreators[meta].apply(meta);
    }

    static {
        sBeforeGTPreload = new ArrayList<Runnable>();
        sAfterGTPreload = new ArrayList<Runnable>();
        sBeforeGTLoad = new ArrayList<Runnable>();
        sAfterGTLoad = new ArrayList<Runnable>();
        sBeforeGTPostload = new ArrayList<Runnable>();
        sAfterGTPostload = new ArrayList<Runnable>();
        sFirstWorldTick = new ArrayList<Runnable>();
        sBeforeGTServerstart = new ArrayList<Runnable>();
        sAfterGTServerstart = new ArrayList<Runnable>();
        sBeforeGTServerstop = new ArrayList<Runnable>();
        sAfterGTServerstop = new ArrayList<Runnable>();
        sGTBlockIconload = new ArrayList<Runnable>();
        sGTItemIconload = new ArrayList<Runnable>();
        sGTCompleteLoad = new ArrayList<Runnable>();
        TICKS_FOR_LAG_AVERAGING = 25;
        MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING = 100;
        sTimber = true;
        sDrinksAlwaysDrinkable = false;
        sMultiThreadedSounds = false;
        sDoShowAllItemsInCreative = false;
        sColoredGUI = true;
        sMachineMetalGUI = false;
        sMachineExplosions = true;
        sMachineFlammable = true;
        sMachineNonWrenchExplosions = true;
        sMachineRainExplosions = true;
        sMachineThunderExplosions = true;
        sMachineFireExplosions = true;
        sMachineWireFire = true;
        mOutputRF = false;
        mInputRF = false;
        mRFExplosions = false;
        mServerStarted = false;
        mEUtoRF = 360;
        mRFtoEU = 20;
        sUseMachineMetal = false;
        mUseOnlyGoodSolderingMaterials = false;
        aTextIC2Lower = Mods.IndustrialCraft2.ID.toLowerCase(Locale.ENGLISH);
        sUnificationEntriesRegistered = false;
        sPreloadStarted = false;
        sPreloadFinished = false;
        sLoadStarted = false;
        sLoadFinished = false;
        sPostloadStarted = false;
        sPostloadFinished = false;
        sFullLoadFinished = false;
        teCreators = new IntFunction[16];
        dummyWorlds = new HashSet();
        dummyWorlds.add(GTDummyWorld.class);
    }
}

