/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.loader;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.loader.ComponentAssemblyLineMiscRecipes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsKevlar;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import net.minecraft.item.ItemStack;

public class ComponentAssemblyLineLoader {
    private static final int L = 144;
    private static final int COAL_LV = 1;
    private static final int COAL_MV = 2;
    private static final int COAL_HV = 3;
    private static final int COAL_EV = 4;
    private static final int COAL_IV = 5;
    private static final int COAL_LuV = 6;
    private static final int COAL_ZPM = 7;
    private static final int COAL_UV = 8;
    private static final int COAL_UHV = 9;
    private static final int COAL_UEV = 10;
    private static final int COAL_UIV = 11;
    private static final int COAL_UMV = 12;
    private static final int COAL_UXV = 13;
    private static final int MOTOR_CIRCUIT = 1;
    private static final int PISTON_CIRCUIT = 2;
    private static final int PUMP_CIRCUIT = 3;
    private static final int ROBOT_ARM_CIRCUIT = 4;
    private static final int CONVEYOR_CIRCUIT = 5;
    private static final int EMITTER_CIRCUIT = 6;
    private static final int SENSOR_CIRCUIT = 7;

    public static void run() {
        ComponentAssemblyLineMiscRecipes.run();
        ComponentAssemblyLineLoader.lvRecipes();
        ComponentAssemblyLineLoader.mvRecipes();
        ComponentAssemblyLineLoader.hvRecipes();
        ComponentAssemblyLineLoader.evRecipes();
        ComponentAssemblyLineLoader.ivRecipes();
        ComponentAssemblyLineLoader.luvRecipes();
        ComponentAssemblyLineLoader.zpmRecipes();
        ComponentAssemblyLineLoader.uvRecipes();
        ComponentAssemblyLineLoader.uhvRecipes();
        ComponentAssemblyLineLoader.uevRecipes();
        ComponentAssemblyLineLoader.uivRecipes();
        ComponentAssemblyLineLoader.umvRecipes();
        ComponentAssemblyLineLoader.uxvRecipes();
    }

    private static void lvRecipes() {
        for (Materials copper : new Materials[]{Materials.Copper, Materials.AnnealedCopper}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.IronMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Iron, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, copper, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 6)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.SteelMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Steel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, copper, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 6)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Steel, 16), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Steel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 6), ComponentAssemblyLineLoader.get(OrePrefixes.gearGt, Materials.Steel, 12)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_LV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Steel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LV, 3), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 9)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Rubber, Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.rotor, Materials.Tin, 48), ComponentAssemblyLineLoader.get(OrePrefixes.screw, Materials.Tin, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 3), ComponentAssemblyLineLoader.get(OrePrefixes.pipeMedium, Materials.Bronze, 48)).fluidInputs(rubber.getMolten(3456L)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, rubber, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 3)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gem, Materials.CertusQuartz, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Steel, 21), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Brass, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LV, 3)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gem, Materials.CertusQuartz, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tin, 6)).fluidInputs(Materials.Brass.getMolten(13824L)).duration(960).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_LV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.plate, Materials.EnderPearl, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.HV, 12)).fluidInputs(Materials.RedSteel.getMolten(13824L)).duration(28800).eut(TierEU.RECIPE_ULV).metadata(GTRecipeConstants.COAL_CASING_TIER, 1).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void mvRecipes() {
        for (Materials copper : new Materials[]{Materials.Copper, Materials.AnnealedCopper}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.SteelMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Aluminium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, Materials.Cupronickel, 24), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, copper, 6)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_MV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Aluminium, 16), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Aluminium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Copper, 6), ComponentAssemblyLineLoader.get(OrePrefixes.gearGt, Materials.Aluminium, 12)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_MV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_MV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Aluminium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.MV, 3), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Copper, 9)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Rubber, Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_MV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.rotor, Materials.Bronze, 48), ComponentAssemblyLineLoader.get(OrePrefixes.screw, Materials.Bronze, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Copper, 3), ComponentAssemblyLineLoader.get(OrePrefixes.pipeMedium, Materials.Steel, 48)).fluidInputs(rubber.getMolten(3456L)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_MV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, rubber, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Copper, 3)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gemFlawless, Materials.Emerald, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Aluminium, 21), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Electrum, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.MV, 3)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gem, Materials.EnderPearl, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.MV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Copper, 6)).fluidInputs(Materials.Electrum.getMolten(13824L)).duration(960).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_MV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.plate, Materials.EnderEye, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.EV, 12)).fluidInputs(Materials.TungstenSteel.getMolten(13824L)).duration(28800).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COAL_CASING_TIER, 2).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void hvRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.SteelMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.StainlessSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, Materials.Electrum, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Silver, 12)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_HV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.StainlessSteel, 16), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.StainlessSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Gold, 6), ComponentAssemblyLineLoader.get(OrePrefixes.gearGt, Materials.StainlessSteel, 12)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_HV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_HV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.StainlessSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.HV, 3), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Gold, 9)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Rubber, Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_HV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.rotor, Materials.Steel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.screw, Materials.Steel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Gold, 3), ComponentAssemblyLineLoader.get(OrePrefixes.pipeMedium, Materials.StainlessSteel, 48)).fluidInputs(rubber.getMolten(3456L)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_HV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, rubber, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Gold, 3)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gem, Materials.EnderEye, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.StainlessSteel, 21), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Chrome, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.HV, 3)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gem, Materials.EnderEye, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.HV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Gold, 6)).fluidInputs(Materials.Chrome.getMolten(13824L)).duration(960).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_HV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.QuantumEye, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.IV, 12)).fluidInputs(Materials.NiobiumTitanium.getMolten(27648L)).duration(28800).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COAL_CASING_TIER, 3).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void evRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.NeodymiumMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Titanium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, Materials.BlackSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Aluminium, 12)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_EV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Titanium, 16), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Titanium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Aluminium, 6), ComponentAssemblyLineLoader.get(OrePrefixes.gearGt, Materials.Titanium, 12)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_EV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_EV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Titanium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.EV, 3), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Aluminium, 9)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Rubber, Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_EV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.rotor, Materials.StainlessSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.screw, Materials.StainlessSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Aluminium, 3), ComponentAssemblyLineLoader.get(OrePrefixes.pipeMedium, Materials.Titanium, 48)).fluidInputs(rubber.getMolten(3456L)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_EV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, rubber, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Aluminium, 3)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.QuantumEye, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Titanium, 21), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Platinum, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.EV, 3)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.QuantumEye, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.EV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Aluminium, 6)).fluidInputs(Materials.Platinum.getMolten(13824L)).duration(960).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_EV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.gem, Materials.NetherStar, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LuV, 12)).fluidInputs(Materials.HSSG.getMolten(27648L)).duration(28800).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COAL_CASING_TIER, 4).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void ivRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.NeodymiumMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.TungstenSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, Materials.Graphene, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tungsten, 12)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_IV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.TungstenSteel, 16), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.TungstenSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tungsten, 6), ComponentAssemblyLineLoader.get(OrePrefixes.gearGt, Materials.TungstenSteel, 12)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_IV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_IV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.TungstenSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.IV, 3), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tungsten, 9)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_IV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.rotor, Materials.TungstenSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.screw, Materials.TungstenSteel, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tungsten, 3), ComponentAssemblyLineLoader.get(OrePrefixes.pipeMedium, Materials.TungstenSteel, 48)).fluidInputs(rubber.getMolten(3456L)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_IV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, rubber, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tungsten, 3)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.TungstenSteel, 21), ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.Iridium, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.IV, 3)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.IV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Tungsten, 6)).fluidInputs(Materials.Iridium.getMolten(13824L)).duration(960).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_IV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 12)).fluidInputs(Materials.HSSS.getMolten(27648L)).duration(28800).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COAL_CASING_TIER, 5).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void luvRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.SamariumMagnetic, 24), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 6), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(6912), Materials.Lubricant.getFluid(12000L), WerkstoffLoader.Ruridit.getMolten(110592), Materials.HSSS.getMolten(13824L)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LuV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.HSSS, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 12), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(6912), Materials.Lubricant.getFluid(12000L), Materials.HSSS.getMolten(86784L)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LuV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.HSSS, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 6), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(6912), Materials.Lubricant.getFluid(12000L), Materials.HSSS.getMolten(64896L), Materials.NiobiumTitanium.getMolten(13824L), rubber.getMolten(6912L)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LuV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.HSSS, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 6), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, rubber, 53), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(6912), Materials.Lubricant.getFluid(12000L), Materials.HSSS.getMolten(31488L)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LuV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_LuV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LuV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.IV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.EV, 24), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 18), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(27648), Materials.Lubricant.getFluid(12000L), Materials.HSSS.getMolten(76032L)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.HSSS, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LuV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, WerkstoffLoader.Ruridit, 42), ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LuV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 21), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(27648), Materials.Gallium.getMolten(331776L)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.HSSS, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_LuV, 48), ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LuV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 21), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(27648), Materials.Gallium.getMolten(331776L), WerkstoffLoader.Ruridit.getMolten(27648)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_LuV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.HSSS, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.HSSS, 32), ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 96), ComponentAssemblyLineLoader.get(ItemList.Emitter_LuV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.YttriumBariumCuprate, 24)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(27648), WerkstoffLoader.Ruridit.getMolten(221184)).duration(28800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COAL_CASING_TIER, 6).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void zpmRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.stickLong, Materials.SamariumMagnetic, 48), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.VanadiumGallium, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(13824), Materials.Lubricant.getFluid(36000L), Materials.Europium.getMolten(165888L), Materials.NaquadahAlloy.getMolten(46848L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_ZPM, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.NaquadahAlloy, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.VanadiumGallium, 48), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(13824), Materials.Lubricant.getFluid(36000L), Materials.NaquadahAlloy.getMolten(86784L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_ZPM, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_ZPM, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LuV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.IV, 24), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(55296), Materials.Lubricant.getFluid(36000L), Materials.VanadiumGallium.getMolten(82944L), Materials.NaquadahAlloy.getMolten(76032L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_ZPM, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.NaquadahAlloy, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.VanadiumGallium, 24), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(13824), Materials.Lubricant.getFluid(36000L), Materials.NaquadahAlloy.getMolten(64896L), Materials.Enderium.getMolten(41472L), rubber.getMolten(13824L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_ZPM, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.NaquadahAlloy, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.VanadiumGallium, 24), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(13824), Materials.Lubricant.getFluid(36000L), rubber.getMolten(137376L), Materials.NaquadahAlloy.getMolten(31488L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.NaquadahAlloy, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_ZPM, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Osmiridium, 42), ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 96), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 12), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(55296), Materials.Trinium.getMolten(331776L), Materials.VanadiumGallium.getMolten(96768L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.NaquadahAlloy, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_ZPM, 48), ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 96), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 12), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(55296), Materials.Trinium.getMolten(331776L), Materials.VanadiumGallium.getMolten(96768L), Materials.Osmiridium.getMolten(27648L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_ZPM.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.NaquadahAlloy, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.NaquadahAlloy, 32), ComponentAssemblyLineLoader.get(ItemList.QuantumStar, 96), ComponentAssemblyLineLoader.get(ItemList.Emitter_ZPM, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UV, 12)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(55296), Materials.Europium.getMolten(221184L), Materials.VanadiumGallium.getMolten(110592L)).duration(28800).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.COAL_CASING_TIER, 7).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void uvRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NaquadahAlloy, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(62208), Materials.Lubricant.getFluid(96000L), Materials.Americium.getMolten(331776L), Materials.Naquadria.getMolten(62208L), Materials.Neutronium.getMolten(46848L), Materials.Samarium.getMolten(13824L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Neutronium, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NaquadahAlloy, 48), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(62208), Materials.Lubricant.getFluid(96000L), Materials.Neutronium.getMolten(86784L), Materials.Naquadria.getMolten(62208L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_UV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.LuV, 24), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(110592), Materials.Lubricant.getFluid(96000L), Materials.NaquadahAlloy.getMolten(82944L), Materials.Neutronium.getMolten(76032L), Materials.Naquadria.getMolten(62208L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Neutronium, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NaquadahAlloy, 24), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(62208), Materials.Lubricant.getFluid(96000L), Materials.Naquadah.getMolten(82944L), Materials.Neutronium.getMolten(64896L), Materials.Naquadria.getMolten(62208L), rubber.getMolten(27648L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Neutronium, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NaquadahAlloy, 24), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(62208), Materials.Lubricant.getFluid(96000L), rubber.getMolten(276048L), Materials.Naquadria.getMolten(62208L), Materials.Neutronium.getMolten(31488L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.Neutronium, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Neutronium, 42), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UV, 12), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(110592), Materials.Naquadria.getMolten(393984L), Materials.NaquadahAlloy.getMolten(96768L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.Neutronium, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UV, 48), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UV, 12), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(110592), Materials.Naquadria.getMolten(393984L), Materials.NaquadahAlloy.getMolten(96768L), Materials.Neutronium.getMolten(27648L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.Neutronium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Neutronium, 32), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 96), ComponentAssemblyLineLoader.get(ItemList.Emitter_UV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 12)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(110592), Materials.Americium.getMolten(331776L), Materials.NaquadahAlloy.getMolten(110592L), Materials.Naquadria.getMolten(62208L)).duration(28800).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.COAL_CASING_TIER, 8).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void uhvRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Bedrockium, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.Neutronium.getMolten(442368L), Materials.Naquadria.getMolten(124416L), Materials.CosmicNeutronium.getMolten(93696L), Materials.Samarium.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UHV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.CosmicNeutronium, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Bedrockium, 48), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.CosmicNeutronium.getMolten(173568L), Materials.Naquadria.getMolten(124416L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UHV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_UHV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.ZPM, 24), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.CosmicNeutronium.getMolten(152064L), Materials.Naquadria.getMolten(124416L), Materials.Bedrockium.getMolten(82944L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UHV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.CosmicNeutronium, 21), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Bedrockium, 24), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.CosmicNeutronium.getMolten(129792L), Materials.Naquadria.getMolten(124416L), Materials.Neutronium.getMolten(82944L), rubber.getMolten(55296L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UHV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.CosmicNeutronium, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Bedrockium, 24), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), rubber.getMolten(276048L), Materials.Naquadria.getMolten(124416L), Materials.CosmicNeutronium.getMolten(62976L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.CosmicNeutronium, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UHV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.CosmicNeutronium, 42), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 384), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 12), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.ElectrumFlux.getMolten(442368L), Materials.Naquadria.getMolten(124416L), Materials.Bedrockium.getMolten(96768L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.CosmicNeutronium, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UHV, 48), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 384), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 12), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.ElectrumFlux.getMolten(442368L), Materials.Naquadria.getMolten(124416L), Materials.Bedrockium.getMolten(96768L), Materials.CosmicNeutronium.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UHV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.CosmicNeutronium, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.CosmicNeutronium, 32), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 192), ComponentAssemblyLineLoader.get(ItemList.Emitter_UHV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UEV, 12)).fluidInputs(MaterialsAlloy.INDALLOY_140.getFluidStack(124416), Materials.Neutronium.getMolten(442368L), Materials.Naquadria.getMolten(124416L), Materials.Bedrockium.getMolten(110592L)).duration(48000).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.COAL_CASING_TIER, 9).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void uevRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Draconium, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.CosmicNeutronium.getMolten(442368L), Materials.Infinity.getMolten(148992L), Materials.Quantium.getMolten(124416L), Materials.TengamPurified.getMolten(55296L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UEV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Infinity, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Draconium, 48), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.Infinity.getMolten(173568L), Materials.Quantium.getMolten(124416L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UEV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_UEV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UEV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UV, 24), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.Infinity.getMolten(152064L), Materials.Quantium.getMolten(124416L), Materials.Draconium.getMolten(82944L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UEV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.pipeLarge, Materials.NetherStar, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Infinity, 21), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Draconium, 24), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), Materials.Infinity.getMolten(129792L), Materials.Quantium.getMolten(124416L), rubber.getMolten(110592L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UEV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Infinity, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Draconium, 24), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.Lubricant.getFluid(192000L), rubber.getMolten(552096L), Materials.Quantium.getMolten(124416L), Materials.Infinity.getMolten(62976L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.Infinity, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UEV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Infinity, 42), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 768), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UEV, 12), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.InfinityCatalyst.getMolten(442368L), Materials.Quantium.getMolten(124416L), Materials.Draconium.getMolten(96768L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.Infinity, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UEV, 48), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 768), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UEV, 12), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.InfinityCatalyst.getMolten(442368L), Materials.Quantium.getMolten(124416L), Materials.Draconium.getMolten(96768L), Materials.Infinity.getMolten(55296L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UEV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, Materials.Infinity, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, Materials.Infinity, 32), ComponentAssemblyLineLoader.get(ItemList.Gravistar, 384), ComponentAssemblyLineLoader.get(ItemList.Emitter_UEV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UIV, 12)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), Materials.Tritanium.getMolten(442368L), Materials.Quantium.getMolten(124416L), Materials.Draconium.getMolten(110592L)).duration(48000).eut(TierEU.RECIPE_UHV).metadata(GTRecipeConstants.COAL_CASING_TIER, 10).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void uivRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(302592L), MaterialsUEVplus.MoltenProtoHalkoniteBase.getFluid(442368L), Materials.Infinity.getMolten(442368L), MaterialsUEVplus.TranscendentMetal.getMolten(148992L), Materials.TengamPurified.getMolten(110592L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(302592L), MaterialsUEVplus.MoltenProtoHalkoniteBase.getFluid(221184L), MaterialsUEVplus.Creon.getMolten(221184L), MaterialsUEVplus.Mellion.getMolten(221184L), MaterialsUEVplus.TranscendentMetal.getMolten(148992L), Materials.TengamPurified.getMolten(110592L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UIV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.TranscendentMetal, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 48), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsUEVplus.TranscendentMetal.getMolten(173568L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UIV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_UIV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UIV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UEV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 24), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 72), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsUEVplus.TranscendentMetal.getMolten(152064L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UIV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.TranscendentMetal, 21), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 24), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsUEVplus.TranscendentMetal.getMolten(129792L), rubber.getMolten(110592L), Materials.DraconiumAwakened.getMolten(82944L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UIV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.TranscendentMetal, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 24), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), rubber.getMolten(552096L), MaterialsUEVplus.TranscendentMetal.getMolten(62976L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.TranscendentMetal, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UIV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.TranscendentMetal, 42), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 96), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UIV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 84), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsAlloy.TRINIUM_REINFORCED_STEEL.getFluidStack(110592), MaterialsAlloy.LAFIUM.getFluidStack(110592), MaterialsAlloy.CINOBITE.getFluidStack(110592), MaterialsAlloy.PIKYONIUM.getFluidStack(110592), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.TranscendentMetal, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UIV, 48), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 96), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UIV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 84), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsAlloy.TRINIUM_REINFORCED_STEEL.getFluidStack(110592), MaterialsAlloy.LAFIUM.getFluidStack(110592), MaterialsAlloy.CINOBITE.getFluidStack(110592), MaterialsAlloy.PIKYONIUM.getFluidStack(110592), MaterialsUEVplus.TranscendentMetal.getMolten(55296L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.TranscendentMetal, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.TranscendentMetal, 32), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 48), ComponentAssemblyLineLoader.get(ItemList.Emitter_UIV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UMV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 96)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(110592L), MaterialsUEVplus.MoltenProtoHalkoniteBase.getFluid(442368L), Materials.Infinity.getMolten(442368L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UIV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.TranscendentMetal, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.TranscendentMetal, 32), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 48), ComponentAssemblyLineLoader.get(ItemList.Emitter_UIV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UMV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.NetherStar, 96)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(110592L), MaterialsUEVplus.MoltenProtoHalkoniteBase.getFluid(221184L), MaterialsUEVplus.Creon.getMolten(221184L), MaterialsUEVplus.Mellion.getMolten(221184L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UEV).metadata(GTRecipeConstants.COAL_CASING_TIER, 11).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void umvRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Quantium, 24), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(470016), Materials.TengamPurified.getMolten(221184L), MaterialsUEVplus.SpaceTime.getMolten(148992L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UMV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.SpaceTime, 32), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Quantium, 48), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsUEVplus.SpaceTime.getMolten(173568L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(27648), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UMV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_UMV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UMV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UIV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UEV, 24), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsUEVplus.SpaceTime.getMolten(152064L), Materials.Quantium.getMolten(82944L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(27648), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        for (Materials rubber : new Materials[]{Materials.Silicone, Materials.StyreneButadieneRubber}) {
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UMV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.SpaceTime, 21), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Quantium, 24), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), MaterialsUEVplus.SpaceTime.getMolten(129792L), rubber.getMolten(110592L), Materials.Infinity.getMolten(82944L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(27648), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UMV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.SpaceTime, 10), ComponentAssemblyLineLoader.get(OrePrefixes.cableGt16, Materials.Quantium, 24), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(192000L), rubber.getMolten(552096L), MaterialsUEVplus.SpaceTime.getMolten(62976L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(27648), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.SpaceTime, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UMV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.SpaceTime, 42), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UMV, 12), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(138240), MaterialsAlloy.QUANTUM.getFluidStack(110592), MaterialsElements.STANDALONE.ASTRAL_TITANIUM.getFluidStack(110592), MaterialsAlloy.TITANSTEEL.getFluidStack(110592), Materials.Quantium.getMolten(96768L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.SpaceTime, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UMV, 48), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UMV, 12), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(138240), MaterialsAlloy.QUANTUM.getFluidStack(110592), MaterialsElements.STANDALONE.ASTRAL_TITANIUM.getFluidStack(110592), MaterialsAlloy.TITANSTEEL.getFluidStack(110592), Materials.Quantium.getMolten(96768L), MaterialsUEVplus.SpaceTime.getMolten(55296L), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UMV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.SpaceTime, 48), ComponentAssemblyLineLoader.get(OrePrefixes.plateDense, MaterialsUEVplus.SpaceTime, 32), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 96), ComponentAssemblyLineLoader.get(ItemList.Emitter_UMV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UXV, 12)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(124416), MaterialsElements.STANDALONE.HYPOGEN.getFluidStack(470016), Materials.Quantium.getMolten(110592L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(27648)).duration(48000).eut(TierEU.RECIPE_UIV).metadata(GTRecipeConstants.COAL_CASING_TIER, 12).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static void uxvRecipes() {
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Motor_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.EnergisedTesseract, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 114), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, MaterialsUEVplus.SpaceTime, 48), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 12), GTUtility.getIntegratedCircuit(1)).fluidInputs(MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(384000L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(287232L), MaterialsUEVplus.Eternity.getMolten(259584L), MaterialsUEVplus.Universium.getMolten(138240L), MaterialsUEVplus.MagMatter.getMolten(110592L), Materials.SuperconductorUMVBase.getMolten(110592L), MaterialsUEVplus.SpaceTime.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Piston_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UXV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 84), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 12), GTUtility.getIntegratedCircuit(2)).fluidInputs(MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(384000L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(242688L), MaterialsUEVplus.Eternity.getMolten(215040L), MaterialsUEVplus.SpaceTime.getMolten(138240L), MaterialsUEVplus.MagMatter.getMolten(82944L), MaterialsUEVplus.Universium.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Robot_Arm_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UXV, 96), ComponentAssemblyLineLoader.get(ItemList.Electric_Piston_UXV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UXV, 6), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UMV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UIV, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 54), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 24), GTUtility.getIntegratedCircuit(4)).fluidInputs(MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(384000L), MaterialsUEVplus.SpaceTime.getMolten(193536L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(179712L), MaterialsUEVplus.Eternity.getMolten(152064L), MaterialsUEVplus.MagMatter.getMolten(96768L), MaterialsUEVplus.Universium.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Electric_Pump_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UXV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 42), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, MaterialsUEVplus.SpaceTime, 48), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 12), GTUtility.getIntegratedCircuit(3)).fluidInputs(MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(384000L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(185088L), MaterialsUEVplus.Eternity.getMolten(157440L), MaterialsUEVplus.MagMatter.getMolten(117504L), Materials.RadoxPolymer.getMolten(110592L), MaterialsKevlar.Kevlar.getMolten(110592L), MaterialsUEVplus.SpaceTime.getMolten(110592L), MaterialsUEVplus.Universium.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Conveyor_Module_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UXV, 96), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 36), ComponentAssemblyLineLoader.get(OrePrefixes.wireGt16, MaterialsUEVplus.SpaceTime, 48), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 12), GTUtility.getIntegratedCircuit(5)).fluidInputs(MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(384000L), Materials.RadoxPolymer.getMolten(552096L), MaterialsKevlar.Kevlar.getMolten(552096L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(104448L), MaterialsUEVplus.Eternity.getMolten(76800L), MaterialsUEVplus.SpaceTime.getMolten(27648L), MaterialsUEVplus.Universium.getMolten(27648L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Sensor_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UXV, 48), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 768), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UXV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 24), GTUtility.getIntegratedCircuit(7)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(691200), MaterialsUEVplus.SpaceTime.getMolten(331776L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(193536L), MaterialsUEVplus.Eternity.getMolten(165888L), MaterialsUEVplus.Universium.getMolten(138240L), MaterialsUEVplus.MagMatter.getMolten(110592L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Emitter_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, 48), ComponentAssemblyLineLoader.get(ItemList.Electric_Motor_UXV, 48), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 768), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UXV, 12), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 48), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 24), GTUtility.getIntegratedCircuit(6)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(691200), MaterialsUEVplus.SpaceTime.getMolten(331776L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(193536L), MaterialsUEVplus.Eternity.getMolten(165888L), MaterialsUEVplus.Universium.getMolten(138240L), MaterialsUEVplus.MagMatter.getMolten(110592L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemList.Field_Generator_UXV.get(64L, new Object[0])).itemInputsUnsafe(ComponentAssemblyLineLoader.get(OrePrefixes.frameGt, MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, 48), ComponentAssemblyLineLoader.get(ItemList.NuclearStar, 3072), ComponentAssemblyLineLoader.get(ItemList.Emitter_UXV, 192), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UXV, 24), ComponentAssemblyLineLoader.get(OrePrefixes.wrapCircuit, Materials.UHV, 66), ComponentAssemblyLineLoader.get(OrePrefixes.nanite, Materials.Gold, 36)).fluidInputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(691200), MaterialsUEVplus.SpaceTime.getMolten(248832L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(179712L), MaterialsUEVplus.Eternity.getMolten(152064L), MaterialsUEVplus.Universium.getMolten(138240L), MaterialsUEVplus.MagMatter.getMolten(110592L), Materials.SuperconductorUMVBase.getMolten(110592L)).duration(48000).eut(TierEU.RECIPE_UMV).metadata(GTRecipeConstants.COAL_CASING_TIER, 13).addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
    }

    private static ItemStack get(OrePrefixes prefix, Object material, int amount) {
        if (material instanceof Werkstoff) {
            Werkstoff w = (Werkstoff)material;
            return GTUtility.copyAmountUnsafe(amount, w.get(prefix, 1));
        }
        return GTUtility.copyAmountUnsafe(amount, GTOreDictUnificator.get(prefix, material, 1L));
    }

    private static ItemStack get(ItemList item, int amount) {
        return GTUtility.copyAmountUnsafe(amount, item.get(1L, new Object[0]));
    }
}

