/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class MTECoolantTower
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    protected IStructureDefinition<MTECoolantTower> multiDefinition = null;
    private static final int CASING_INDEX = 1539;

    public MTECoolantTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTECoolantTower(String name) {
        super(name);
    }

    @Override
    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B     B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   BBBBB   ", "  BB   BB  ", "  BB   BB  ", "  BB   BB  ", "   BBBBB   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   B   B   ", "   B   B   ", "   B   B   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   B   B   ", "   B   B   ", "   B   B   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   B   B   ", "   B   B   ", "   B   B   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   BBBBB   ", "  BB   BB  ", "  BB   BB  ", "  BB   BB  ", "   BBBBB   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B     B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B     B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}, {"           ", "    BBB    ", "   BBBBB   ", "  BB   BB  ", " BB     BB ", " BB     BB ", " BB     BB ", "  BB   BB  ", "   BBBBB   ", "    BBB    ", "           "}, {"           ", "    BBB    ", "   B   B   ", "  B     B  ", " B       B ", " B       B ", " B       B ", "  B     B  ", "   B   B   ", "    BBB    ", "           "}, {"           ", "   BBBBB   ", "  BB   BB  ", " BB     BB ", " B       B ", " B       B ", " B       B ", " BB     BB ", "  BB   BB  ", "   BBBBB   ", "           "}, {"   HH~HH   ", "  HBBBBBH  ", " HB     BH ", "HB       BH", "HB       BH", "HB       BH", "HB       BH", "HB       BH", " HB     BH ", "  HBBBBBH  ", "   HHHHH   "}, {"   CCCCC   ", "  C     C  ", " C       C ", "C         C", "C         C", "C         C", "C         C", "C         C", " C       C ", "  C     C  ", "   CCCCC   "}})).addElement('B', StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockConcretes, (int)8)).addElement('C', GTStructureUtility.ofFrame(Materials.TungstenCarbide)).addElement('H', GTStructureUtility.buildHatchAdder(MTECoolantTower.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(1539).dot(1).buildAndChain(StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockConcretes, (int)8))).build();
        }
        return this.multiDefinition;
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(this.mName, 5, 11, 0);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Coolant Tower").addInfo("Turn Steam back to Distilled Water.").addController("Mid of the second layer").addCasingInfoExactly("Light Concrete", 277, false).addCasingInfoExactly("Tungstencarbide Frame Box", 28, false).addInputHatch("Input Hatch", 1).addOutputHatch("Output Hatch", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 5, 11, 0, stackSize, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("CoolantTower.hint", 3);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECoolantTower(this.mName);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        return true;
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.mMaxProgresstime = 20;
        int steam = 0;
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            steam += this.maybeDrainHatch(tHatch);
        }
        this.addOutput(GTModHandler.getDistilledWater(steam / 160));
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private int maybeDrainHatch(MTEHatchInput tHatch) {
        if (tHatch instanceof MTEHatchMultiInput) {
            int drained = 0;
            for (FluidStack maybeSteam : ((MTEHatchMultiInput)tHatch).getStoredFluid()) {
                drained += this.maybeDrainSteam(tHatch, maybeSteam);
            }
            return drained;
        }
        return this.maybeDrainSteam(tHatch, tHatch.getFillableStack());
    }

    private int maybeDrainSteam(MTEHatchInput tHatch, FluidStack maybeSteam) {
        if (maybeSteam == null) {
            return 0;
        }
        if (!GTUtility.areFluidsEqual(maybeSteam, GTModHandler.getSteam(1L))) {
            return 0;
        }
        FluidStack defoSteam = tHatch.drain(ForgeDirection.UNKNOWN, maybeSteam, true);
        return defoSteam.amount;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][3], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][3], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][3]};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 5, 11, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

