/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.galacticgreg;

import bwcrossmod.galacticgreg.VoidMinerUtility;
import com.google.common.collect.ImmutableList;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class MTEVoidMinerBase
extends MTEDrillerBase {
    private VoidMinerUtility.DropMap dropMap = null;
    private VoidMinerUtility.DropMap extraDropMap = null;
    private float totalWeight;
    private int multiplier = 1;
    protected final byte TIER_MULTIPLIER;
    private boolean mBlacklist = false;

    public MTEVoidMinerBase(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
        this.TIER_MULTIPLIER = (byte)Math.max(tier, 1);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mBlacklist", this.mBlacklist);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mBlacklist = aNBT.func_74767_n("mBlacklist");
    }

    public MTEVoidMinerBase(String aName, int tier) {
        super(aName);
        this.TIER_MULTIPLIER = (byte)tier;
    }

    @Override
    protected int getMinTier() {
        return this.TIER_MULTIPLIER + 5;
    }

    @Override
    protected boolean checkHatches() {
        return true;
    }

    @Override
    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? 60 : Math.toIntExact(GTValues.V[this.getMinTier()]);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mOutputItems = new ItemStack[0];
        this.mProgresstime = 0;
        this.mMaxProgresstime = this.calculateMaxProgressTime(0);
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.mEUt > 0 ? -this.mEUt : this.mEUt;
    }

    @Override
    public int calculateMaxProgressTime(int tier, boolean simulateWorking) {
        return 10;
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.dropMap == null || this.totalWeight == 0.0f) {
            this.calculateDropMap();
        }
        if (this.totalWeight != 0.0f) {
            this.handleFluidConsumption();
            this.handleOutputs();
            return true;
        }
        this.stopMachine(ShutDownReasonRegistry.NONE);
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Miner").addInfo("Consumes " + GTValues.V[this.getMinTier()] + "EU/t").addInfo("Can be supplied with 2L/s of Neon(x4), Krypton(x8), Xenon(x16) or Oganesson(x64) for higher outputs.").addInfo("Will output " + 2 * this.TIER_MULTIPLIER + " Ores per Second depending on the Dimension it is build in").addInfo("Put the Ore into the input bus to set the Whitelist/Blacklist").addInfo("Use a screwdriver to toggle Whitelist/Blacklist").addInfo("Blacklist or non Whitelist Ore will be " + EnumChatFormatting.DARK_RED + "VOIDED" + EnumChatFormatting.RESET + ".").beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GTValues.VN[this.getMinTier()] + "+, Any base casing").addMaintenanceHatch("Any base casing").addInputBus("Mining Pipes or Ores, optional, any base casing").addInputHatch("Optional noble gas, any base casing").addOutputBus("Any base casing").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected List<IHatchElement<? super MTEDrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.InputBus, (Object)HatchElement.OutputBus, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy);
    }

    private ItemStack nextOre() {
        Map.Entry<GTUtility.ItemId, Float> entry2;
        float currentWeight = 0.0f;
        block0: while (true) {
            float randomNumber = XSTR.XSTR_INSTANCE.nextFloat() * this.totalWeight;
            for (Map.Entry<GTUtility.ItemId, Float> entry2 : this.dropMap.getInternalMap().entrySet()) {
                if (!(randomNumber < (currentWeight += entry2.getValue().floatValue()))) continue;
                return entry2.getKey().getItemStack();
            }
            Iterator<Map.Entry<GTUtility.ItemId, Float>> iterator = this.extraDropMap.getInternalMap().entrySet().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(randomNumber < (currentWeight += (entry2 = iterator.next()).getValue().floatValue())));
            break;
        }
        return entry2.getKey().getItemStack();
    }

    private FluidStack getNobleGasInputAndSetMultiplier() {
        for (FluidStack s : this.getStoredFluids()) {
            for (int i = 0; i < VoidMinerUtility.NOBLE_GASSES.length; ++i) {
                FluidStack ng = VoidMinerUtility.NOBLE_GASSES[i];
                if (!ng.isFluidEqual(s)) continue;
                this.multiplier = this.TIER_MULTIPLIER * VoidMinerUtility.NOBEL_GASSES_MULTIPLIER[i];
                return s;
            }
        }
        return null;
    }

    private boolean consumeNobleGas(FluidStack gasToConsume) {
        for (FluidStack s : this.getStoredFluids()) {
            if (!s.isFluidEqual(gasToConsume) || s.amount < 1) continue;
            --s.amount;
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void handleFluidConsumption() {
        FluidStack storedNobleGas = this.getNobleGasInputAndSetMultiplier();
        if (storedNobleGas == null || !this.consumeNobleGas(storedNobleGas)) {
            this.multiplier = this.TIER_MULTIPLIER;
        }
    }

    private void handleExtraDrops(int id) {
        if (VoidMinerUtility.extraDropsDimMap.containsKey(id)) {
            this.extraDropMap = VoidMinerUtility.extraDropsDimMap.get(id);
        }
    }

    private void handleModDimDef(int id) {
        if (VoidMinerUtility.dropMapsByDimId.containsKey(id)) {
            this.dropMap = VoidMinerUtility.dropMapsByDimId.get(id);
        } else {
            String chunkProviderName = ((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().func_72863_F()).field_73246_d.getClass().getName();
            if (VoidMinerUtility.dropMapsByChunkProviderName.containsKey(chunkProviderName)) {
                this.dropMap = VoidMinerUtility.dropMapsByChunkProviderName.get(chunkProviderName);
            }
        }
    }

    private void calculateDropMap() {
        this.dropMap = new VoidMinerUtility.DropMap();
        this.extraDropMap = new VoidMinerUtility.DropMap();
        int id = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
        this.handleModDimDef(id);
        this.handleExtraDrops(id);
        this.totalWeight = this.dropMap.getTotalWeight() + this.extraDropMap.getTotalWeight();
    }

    private void handleOutputs() {
        List inputOres = this.getStoredInputs().stream().filter(GTUtility::isOre).collect(Collectors.toList());
        ItemStack output = this.nextOre();
        output.field_77994_a = this.multiplier;
        if (inputOres.isEmpty() || this.mBlacklist && inputOres.stream().noneMatch(is -> GTUtility.areStacksEqual(is, output)) || !this.mBlacklist && inputOres.stream().anyMatch(is -> GTUtility.areStacksEqual(is, output))) {
            this.addOutput(output);
        }
        this.updateSlots();
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mBlacklist = !this.mBlacklist;
        GTUtility.sendChatToPlayer(aPlayer, "Mode: " + (this.mBlacklist ? "Blacklist" : "Whitelist"));
    }
}

