/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class DustLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.dust)) {
            ArrayList<FluidStack> flOutputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> stOutputs = new ArrayList<ItemStack>();
            HashMap<ISubTagContainer, Pair> tracker = new HashMap<ISubTagContainer, Pair>();
            Werkstoff.Stats werkstoffStats = werkstoff.getStats();
            int cells = 0;
            if (werkstoff.getGenerationFeatures().hasMixerRecipes() || werkstoffStats.isElektrolysis() || werkstoffStats.isCentrifuge() || werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                if (((LinkedHashSet)werkstoff.getContents().getValue()).size() > 0) {
                    for (Pair container : ((LinkedHashSet)werkstoff.getContents().getValue()).toArray(new Pair[0])) {
                        FluidStack tmpFl;
                        ISubTagContainer key = (ISubTagContainer)container.getKey();
                        int value = (Integer)container.getValue();
                        if (key instanceof Materials) {
                            Materials materialKey = (Materials)key;
                            if ((materialKey.getGas(0L) != null || materialKey.getFluid(0L) != null || materialKey.mIconSet == TextureSet.SET_FLUID) && materialKey.getDust(0) == null) {
                                tmpFl = materialKey.getGas(1000L * (long)value);
                                if (tmpFl == null || tmpFl.getFluid() == null) {
                                    tmpFl = materialKey.getFluid(1000L * (long)value);
                                }
                                flOutputs.add(tmpFl);
                                if (flOutputs.size() <= 1) continue;
                                if (!tracker.containsKey(key)) {
                                    stOutputs.add(materialKey.getCells(value));
                                    tracker.put(key, Pair.of((Object)value, (Object)(stOutputs.size() - 1)));
                                } else {
                                    stOutputs.add(materialKey.getCells((Integer)((Pair)tracker.get(key)).getKey() + value));
                                    stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                                }
                                cells += value;
                                continue;
                            }
                            if (materialKey.getDust(value) == null) {
                                if (materialKey.getCells(value) == null || materialKey.getMolten(0L) == null && materialKey.getSolid(0L) == null) continue;
                                tmpFl = materialKey.getMolten(1000L * (long)value);
                                if (tmpFl == null || tmpFl.getFluid() == null) {
                                    tmpFl = materialKey.getSolid(1000L * (long)value);
                                }
                                flOutputs.add(tmpFl);
                                if (flOutputs.size() > 1) {
                                    if (!tracker.containsKey(key)) {
                                        stOutputs.add(materialKey.getCells(value));
                                        tracker.put(key, Pair.of((Object)value, (Object)(stOutputs.size() - 1)));
                                    } else {
                                        stOutputs.add(materialKey.getCells((Integer)((Pair)tracker.get(key)).getKey() + value));
                                        stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                                    }
                                    cells += value;
                                }
                            }
                            if (!tracker.containsKey(key)) {
                                stOutputs.add(materialKey.getDust(value));
                                tracker.put(key, Pair.of((Object)value, (Object)(stOutputs.size() - 1)));
                                continue;
                            }
                            stOutputs.add(materialKey.getDust((Integer)((Pair)tracker.get(key)).getKey() + value));
                            stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                            continue;
                        }
                        if (!(key instanceof Werkstoff)) continue;
                        Werkstoff werkstoffKey = (Werkstoff)key;
                        if (werkstoffKey.getStats().isGas() || werkstoffKey.hasItemType(OrePrefixes.cell)) {
                            tmpFl = werkstoffKey.getFluidOrGas(1000 * value);
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = werkstoffKey.getFluidOrGas(1000 * value);
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() <= 1) continue;
                            if (!tracker.containsKey(key)) {
                                stOutputs.add(werkstoffKey.get(OrePrefixes.cell, value));
                                tracker.put(key, Pair.of((Object)value, (Object)(stOutputs.size() - 1)));
                            } else {
                                stOutputs.add(werkstoffKey.get(OrePrefixes.cell, (Integer)((Pair)tracker.get(key)).getKey() + value));
                                stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                            }
                            cells += value;
                            continue;
                        }
                        if (!werkstoffKey.hasItemType(OrePrefixes.dust)) continue;
                        if (!tracker.containsKey(key)) {
                            stOutputs.add(werkstoffKey.get(OrePrefixes.dust, value));
                            tracker.put(key, Pair.of((Object)value, (Object)(stOutputs.size() - 1)));
                            continue;
                        }
                        stOutputs.add(werkstoffKey.get(OrePrefixes.dust, (Integer)((Pair)tracker.get(key)).getKey() + value));
                        stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                    }
                    ItemStack input = werkstoff.get(OrePrefixes.dust);
                    input.field_77994_a = (Integer)werkstoff.getContents().getKey();
                    if (werkstoffStats.isElektrolysis()) {
                        GTRecipe tRecipe = new GTRecipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{!flOutputs.isEmpty() ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoffStats.getProtons() / (long)((LinkedHashSet)werkstoff.getContents().getValue()).size())), Math.min(4, ((LinkedHashSet)werkstoff.getContents().getValue()).size()) * 30, 0);
                        RecipeMaps.electrolyzerRecipes.add(tRecipe);
                    }
                    if (werkstoffStats.isCentrifuge()) {
                        RecipeMaps.centrifugeRecipes.add(new GTRecipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{!flOutputs.isEmpty() ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoffStats.getMass() / (long)((LinkedHashSet)werkstoff.getContents().getValue()).size())), Math.min(4, ((LinkedHashSet)werkstoff.getContents().getValue()).size()) * 5, 0));
                    }
                    if (werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                        if (cells > 0) {
                            stOutputs.add(Materials.Empty.getCells(cells));
                        }
                        GTValues.RA.stdBuilder().itemInputs(stOutputs.toArray(new ItemStack[0])).itemOutputs(input).fluidInputs(flOutputs.toArray(new FluidStack[0])).duration((int)Math.max(1L, Math.abs(werkstoffStats.getProtons() / (long)((LinkedHashSet)werkstoff.getContents().getValue()).size()))).eut(Math.min(4, ((LinkedHashSet)werkstoff.getContents().getValue()).size()) * 30).addTo(GTRecipeConstants.UniversalChemical);
                    }
                    if (werkstoff.getGenerationFeatures().hasMixerRecipes()) {
                        short circuitID;
                        ItemStack circuit;
                        if (cells > 0) {
                            stOutputs.add(Materials.Empty.getCells(cells));
                        }
                        ItemStack itemStack = circuit = (circuitID = werkstoff.getMixCircuit()) == -1 ? null : GTUtility.getIntegratedCircuit(circuitID);
                        if (circuit != null) {
                            stOutputs.add(circuit);
                        }
                        RecipeMaps.mixerRecipes.add(new GTRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{!flOutputs.isEmpty() ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoffStats.getMass() / (long)((LinkedHashSet)werkstoff.getContents().getValue()).size())), Math.min(4, ((LinkedHashSet)werkstoff.getContents().getValue()).size()) * 5, 0));
                    }
                } else {
                    GTLog.err.println("Autogenerated recipe(s) using Werkstoff material '" + werkstoff.getDefaultName() + "' (dust) removed due to no contents in material definition.");
                }
            }
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.dust), new Object[]{"TTT", "TTT", "TTT", Character.valueOf('T'), werkstoff.get(OrePrefixes.dustTiny)});
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.dust), new Object[]{"TT ", "TT ", Character.valueOf('T'), WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff)});
            GTModHandler.addCraftingRecipe(WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff, 4), new Object[]{" T ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GTModHandler.addCraftingRecipe(WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustTiny, werkstoff, 9), new Object[]{"T  ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.dust)).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.dust)).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_3by3.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.dust)).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_2by2.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.dust)).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
            if (werkstoff.hasItemType(OrePrefixes.ingot) && !werkstoffStats.isBlastFurnace()) {
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.dust), werkstoff.get(OrePrefixes.ingot));
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.dustTiny), werkstoff.get(OrePrefixes.nugget));
            } else if (werkstoff.hasItemType(OrePrefixes.ingot) && werkstoffStats.isBlastFurnace() && werkstoffStats.getMeltingPoint() != 0 && werkstoffStats.autoGenerateBlastFurnaceRecipes()) {
                if (werkstoff.contains(WerkstoffLoader.ANAEROBE_SMELTING)) {
                    GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(11)).itemOutputs(werkstoffStats.getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot)).fluidInputs(Materials.Nitrogen.getGas(1000L)).duration(Math.max(werkstoffStats.getMass() / 40L, 1L) * (long)werkstoffStats.getMeltingPoint()).eut(werkstoffStats.getMeltingVoltage()).metadata(GTRecipeConstants.COIL_HEAT, werkstoffStats.getMeltingPoint()).addTo(RecipeMaps.blastFurnaceRecipes);
                } else if (werkstoff.contains(WerkstoffLoader.NOBLE_GAS_SMELTING)) {
                    GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(11)).itemOutputs(werkstoffStats.getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot)).fluidInputs(Materials.Argon.getGas(1000L)).duration(Math.max(werkstoffStats.getMass() / 40L, 1L) * (long)werkstoffStats.getMeltingPoint()).eut(werkstoffStats.getMeltingVoltage()).metadata(GTRecipeConstants.COIL_HEAT, werkstoffStats.getMeltingPoint()).addTo(RecipeMaps.blastFurnaceRecipes);
                } else {
                    GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(1)).itemOutputs(werkstoffStats.getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot)).duration(Math.max(werkstoffStats.getMass() / 40L, 1L) * (long)werkstoffStats.getMeltingPoint()).eut(werkstoffStats.getMeltingVoltage()).metadata(GTRecipeConstants.COIL_HEAT, werkstoffStats.getMeltingPoint()).addTo(RecipeMaps.blastFurnaceRecipes);
                    if (werkstoffStats.getMeltingPoint() <= 1000) {
                        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dust)).itemOutputs(werkstoff.get(OrePrefixes.ingot)).duration((int)Math.max(werkstoffStats.getMass() / 40L, 1L) * werkstoffStats.getMeltingPoint()).eut(0).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 9).addTo(RecipeMaps.primitiveBlastRecipes);
                    }
                }
            }
            if (werkstoffStats.isBlastFurnace() && werkstoffStats.getMeltingPoint() > 1750 && werkstoffStats.autoGenerateVacuumFreezerRecipes()) {
                GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingotHot)).itemOutputs(werkstoff.get(OrePrefixes.ingot)).duration((int)Math.max(werkstoffStats.getMass() * 3L, 1L)).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
            }
            if (werkstoff.hasItemType(OrePrefixes.ingot)) {
                GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot)).itemOutputs(werkstoff.get(OrePrefixes.dust)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.nugget)).itemOutputs(werkstoff.get(OrePrefixes.dustTiny)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
            }
        }
    }
}

