/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material;

import bartworks.system.material.BWMetaGeneratedBlocks;
import bartworks.system.material.BWTileEntityMetaGeneratedOre;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.MathUtils;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTLanguageManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class BWMetaGeneratedOres
extends BWMetaGeneratedBlocks {
    public BWMetaGeneratedOres(Material p_i45386_1_, Class<? extends TileEntity> tileEntity, String blockName) {
        super(p_i45386_1_, tileEntity, blockName);
        this.blockTypeLocalizedName = GTLanguageManager.addStringLocalization("bw.blocktype." + (Object)((Object)OrePrefixes.ore), OrePrefixes.ore.mLocalizedMaterialPre + "%material" + OrePrefixes.ore.mLocalizedMaterialPost);
    }

    @Override
    protected void doRegistrationStuff(Werkstoff w) {
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean air, Block block, int[] aBlockMeta) {
        if (!air) {
            aY = MathUtils.clamp(aY, 1, aWorld.func_72940_L());
        }
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        Block tOreBlock = WerkstoffLoader.BWOres;
        if (aMetaData < 0 || tBlock == Blocks.field_150350_a && !air || Block.func_149682_b((Block)tBlock) != Block.func_149682_b((Block)block)) {
            return false;
        }
        int aaY = aY;
        if (Arrays.stream(aBlockMeta).noneMatch(e -> e == aWorld.func_72805_g(aX, aaY, aZ))) {
            return false;
        }
        aWorld.func_147465_d(aX, aY, aZ, tOreBlock, aMetaData, 0);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BWTileEntityMetaGeneratedOre) {
            BWTileEntityMetaGeneratedOre metaTE = (BWTileEntityMetaGeneratedOre)tTileEntity;
            metaTE.mMetaData = (short)aMetaData;
            metaTE.mNatural = true;
        }
        return true;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon func_149673_e(IBlockAccess worldIn, int x, int y, int z, int side) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public int getHarvestLevel(int metadata) {
        return 3;
    }

    public String func_149739_a() {
        return "bw.blockores.01";
    }

    public void func_149666_a(Item aItem, CreativeTabs aTab, List<ItemStack> aList) {
        for (Werkstoff tMaterial : Werkstoff.werkstoffHashSet) {
            if (tMaterial == null || !tMaterial.hasItemType(OrePrefixes.ore) || (tMaterial.getGenerationFeatures().blacklist & 8) != 0) continue;
            aList.add(new ItemStack(aItem, 1, (int)tMaterial.getmID()));
        }
    }

    public void func_149636_a(World worldIn, EntityPlayer player, int x, int y, int z, int meta) {
        if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            BWTileEntityMetaGeneratedOre.shouldSilkTouch = true;
            super.func_149636_a(worldIn, player, x, y, z, meta);
            if (BWTileEntityMetaGeneratedOre.shouldSilkTouch) {
                BWTileEntityMetaGeneratedOre.shouldSilkTouch = false;
            }
            return;
        }
        if (!(player instanceof FakePlayer)) {
            BWTileEntityMetaGeneratedOre.shouldFortune = true;
        }
        super.func_149636_a(worldIn, player, x, y, z, meta);
        if (BWTileEntityMetaGeneratedOre.shouldFortune) {
            BWTileEntityMetaGeneratedOre.shouldFortune = false;
        }
    }
}

