/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.client.utils.ConstructableData;
import blockrenderer6343.client.world.DummyWorld;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementChain;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.ReflectionHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureHacks {
    private static final int MAX_TIERS_TO_CHECK = 50;
    private static final List<String> TIERED_ELEMENTS = new ArrayList<String>();
    private static final String CHANNEL_ELEMENT;
    public static final String LAZY_ELEMENT = "com.gtnewhorizon.structurelib.structure.LazyStructureElement";
    private static final MethodHandle CHAIN_GETTER;
    private static final MethodHandle CHANNEL_GETTER;
    private static final MethodHandle LAZY_ELEMENT_GETTER;
    public static final ItemStack HOLO_STACK;
    public static final Collection<String> SKIP_ELEMENTS;

    public static void addTieredElement(String className) {
        TIERED_ELEMENTS.add(className);
    }

    @Nullable
    public static <T> Iterable<ItemStack> getStacksForElement(T multi, IStructureElement<T> element, ConstructableData data) {
        String name = element.getClass().getName();
        if (name.equals(LAZY_ELEMENT)) {
            if ((element = StructureHacks.getUnderlyingElement(multi, element)) == null) {
                return Collections.emptyList();
            }
            name = element.getClass().getName();
        }
        if (SKIP_ELEMENTS.contains(name)) {
            return Collections.emptyList();
        }
        if (element instanceof IStructureElementChain) {
            IStructureElement<T>[] elements = StructureHacks.unwrapChainElement(element);
            if (elements == null) {
                return Collections.emptyList();
            }
            ObjectOpenHashSet chainStacks = new ObjectOpenHashSet();
            for (IStructureElement<T> e : elements) {
                Iterable<ItemStack> stacks = StructureHacks.getStacksForElement(multi, e, data);
                if (stacks == null) continue;
                stacks.forEach(arg_0 -> ((ObjectSet)chainStacks).add(arg_0));
            }
            return chainStacks;
        }
        IStructureElement.BlocksToPlace blocks = element.getBlocksToPlace(multi, (World)DummyWorld.INSTANCE, 0, 0, 0, HOLO_STACK, BRUtil.AUTO_PLACE_ENVIRONMENT);
        if (TIERED_ELEMENTS.contains(name)) {
            return StructureHacks.extractTieredBlocks(multi, element, data, StructureHacks.getChannel(name, element));
        }
        if (blocks == null) {
            return Collections.emptyList();
        }
        return blocks.getStacks();
    }

    private static <T> ObjectSet<ItemStack> extractTieredBlocks(T multi, IStructureElement<T> element, ConstructableData data, String channel) {
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        ItemStack holo = HOLO_STACK.func_77946_l();
        int tier = 0;
        boolean doBreak = false;
        do {
            Iterator iterator;
            holo.field_77994_a = tier++ + 1;
            IStructureElement.BlocksToPlace toPlace = element.getBlocksToPlace(multi, (World)DummyWorld.INSTANCE, 0, 0, 0, holo, BRUtil.AUTO_PLACE_ENVIRONMENT);
            if (toPlace == null || toPlace.getStacks() == null || !(iterator = toPlace.getStacks().iterator()).hasNext()) break;
            ItemStack firstStack = (ItemStack)iterator.next();
            if (!data.addItemTier(firstStack, channel, tier)) {
                doBreak = true;
            }
            result.add((Object)firstStack);
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                data.addItemTier(stack, channel, tier);
                result.add((Object)stack);
            }
        } while (!doBreak && tier < 50);
        data.setMaxTier(tier - 1, channel);
        return result;
    }

    private static String getChannel(String className, IStructureElement<?> element) {
        if (className.equals(CHANNEL_ELEMENT)) {
            try {
                return (String)CHANNEL_GETTER.invokeWithArguments(element);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    public static <T> boolean anyElementMatches(@NotNull Collection<String> elementsToFind, @NotNull T multi, @Nullable IStructureElement<T> element) {
        if (element == null) {
            return false;
        }
        String name = element.getClass().getName();
        if (elementsToFind.contains(name)) {
            return true;
        }
        for (String ele : elementsToFind) {
            IStructureElement<T> result = StructureHacks.getFirstMatchingElement(ele, multi, element);
            if (result == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> IStructureElement<T> getFirstMatchingElement(String elementToFind, T multi, IStructureElement<T> element) {
        if (element == null) {
            return null;
        }
        String name = element.getClass().getName();
        if (elementToFind.equals(name)) {
            return element;
        }
        if (LAZY_ELEMENT.equals(name)) {
            return StructureHacks.getFirstMatchingElement(elementToFind, multi, StructureHacks.getUnderlyingElement(multi, element));
        }
        if (element instanceof IStructureElementChain) {
            IStructureElement<T>[] elements = StructureHacks.unwrapChainElement(element);
            if (elements == null) {
                return null;
            }
            for (IStructureElement<T> e : elements) {
                IStructureElement<T> result = StructureHacks.getFirstMatchingElement(elementToFind, multi, e);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public static <T> IStructureElement<T>[] unwrapChainElement(IStructureElement<T> element) {
        if (!(element instanceof IStructureElementChain)) {
            return null;
        }
        try {
            return (IStructureElement[])CHAIN_GETTER.invokeWithArguments(element);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> IStructureElement<T> getUnderlyingElement(T multi, IStructureElement<?> element) {
        if (!LAZY_ELEMENT.equals(element.getClass().getName())) {
            return element;
        }
        try {
            return (IStructureElement)LAZY_ELEMENT_GETTER.invokeWithArguments(element, multi);
        }
        catch (Throwable ignored) {
            throw new RuntimeException();
        }
    }

    public static boolean isSafeStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null;
    }

    private static ObjectSet<String> getClassNames(Object ... elements) {
        ObjectOpenHashSet classNames = new ObjectOpenHashSet();
        for (Object elem : elements) {
            classNames.add((Object)elem.getClass().getName());
        }
        return classNames;
    }

    static {
        HOLO_STACK = new ItemStack(StructureLibAPI.getDefaultHologramItem());
        SKIP_ELEMENTS = StructureHacks.getClassNames(StructureUtility.isAir(), StructureUtility.notAir(), StructureUtility.error());
        StructureHacks.addTieredElement(StructureUtility.ofBlocksTiered((a, b) -> 0, null, Collections.emptyList(), (c, d) -> {}, e -> -1).getClass().getName());
        IStructureElementCheckOnly elem = StructureUtility.ofBlocksTiered((a, b) -> 0, null, (c, d) -> {}, e -> -1);
        StructureHacks.addTieredElement(elem.getClass().getName());
        IStructureElement channelElem = StructureUtility.withChannel((String)"blah", (IStructureElement)elem);
        CHANNEL_ELEMENT = channelElem.getClass().getName();
        StructureHacks.addTieredElement(CHANNEL_ELEMENT);
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            LAZY_ELEMENT_GETTER = lookup.unreflect(ReflectionHelper.findMethod(Class.forName(LAZY_ELEMENT), null, (String[])new String[]{"get"}, (Class[])new Class[]{Object.class}));
            CHAIN_GETTER = lookup.findVirtual(IStructureElementChain.class, "fallbacks", MethodType.methodType(IStructureElement[].class));
            CHANNEL_GETTER = lookup.unreflectGetter(ReflectionHelper.findField(channelElem.getClass(), (String[])new String[]{"val$channel"}));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e2) {
            throw new RuntimeException(e2);
        }
    }
}

