/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.client.renderer.ImmediateWorldSceneRenderer;
import blockrenderer6343.client.renderer.WorldSceneRenderer;
import blockrenderer6343.client.utils.BRButton;
import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.client.utils.ConstructableData;
import blockrenderer6343.client.utils.GuiSlider;
import blockrenderer6343.client.world.TrackedDummyWorld;
import blockrenderer6343.integration.nei.MultiblockHandler;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.structurelib.StructureEvent;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@EventBusSubscriber(side={Side.CLIENT})
public abstract class GuiMultiblockHandler {
    protected static ImmediateWorldSceneRenderer renderer;
    private final RenderBlocks renderBlocks = new RenderBlocks();
    public static final int SLOT_SIZE = 18;
    public static final int ICON_SIZE_X = 20;
    public static final int ICON_SIZE_Y = 12;
    public static final long NO_SELECTED_BLOCK;
    public static final int UNDER_PREVIEW_Y = 136;
    public static final int BUTTON_RIGHT = 145;
    public static final int RECIPE_LAYOUT_X = 6;
    public static final int RECIPE_LAYOUT_Y = 33;
    public static final int RECIPE_WIDTH = 163;
    public static final int SCENE_HEIGHT = 153;
    public static final Long2ObjectMap<IStructureElement<Object>> structureElementMap;
    protected static final int BETWEEN_BUTTON_X = 22;
    protected static final int SLIDER_WIDTH = 121;
    protected static final float DEFAULT_RANGE_MULTIPLIER = 3.5f;
    protected static final int MAX_PLACE_ROUNDS = 2000;
    protected static final BlockPos MB_PLACE_POS;
    protected static final BlockPos SELECTED_BLOCK;
    protected static final ItemStack DEFAULT_TRIGGER;
    protected static int guiMouseX;
    protected static int guiMouseY;
    protected static int guiLeft;
    protected static int guiTop;
    protected static int lastGuiMouseX;
    protected static int lastGuiMouseY;
    protected static Vector3f center;
    protected static float rotationYaw;
    protected static float rotationPitch;
    protected static float zoom;
    protected static IConstructable renderingController;
    protected static IConstructable lastRenderingController;
    protected ItemStack tooltipBlockStack;
    protected ConstructableData constructableData;
    protected ItemStack stackForm;
    protected Consumer<List<List<ItemStack>>> onCandidateChanged;
    protected Consumer<List<ItemStack>> onIngredientChanged;
    protected static int layerIndex;
    protected int scrolled = 0;
    protected float scaleFactor;
    protected ItemStack trigger;
    protected int lastHeight;
    protected final ObjectList<BRButton> allButtons = new ObjectArrayList();
    protected GuiSlider tierSlider;
    protected Vector2i relativeMousePos = new Vector2i();
    protected GuiRecipe<?> recipeGui;
    private int buttonsInRow;
    protected String lastSearch = "";
    protected static Minecraft mc;

    protected abstract void placeMultiblock();

    public void loadMultiblock(IConstructable multiblock, ItemStack stackForm, @NotNull ConstructableData data) {
        renderingController = multiblock;
        this.constructableData = data;
        this.recipeGui = (GuiRecipe)NEIClientUtils.getGuiContainer();
        this.stackForm = stackForm;
        if (stackForm.field_77994_a == 0) {
            stackForm.field_77994_a = 1;
        }
        if (lastRenderingController != renderingController) {
            this.initGui();
            this.loadNewMultiblock();
        } else {
            this.initializeSceneRenderer(false);
        }
    }

    protected void initGui() {
        this.allButtons.clear();
        this.buttonsInRow = 0;
        this.tierSlider = (GuiSlider)new GuiSlider(I18n.func_135052_a((String)"blockrenderer6343.nei.tier", (Object[])new Object[0]), 0, 136, 121, 16, 1, 1, this.constructableData.getMaxTotalTier()).setValueListener(this::setTier).setIndex(0);
        this.allButtons.add((Object)this.tierSlider);
        this.allButtons.add((Object)new GuiSlider(I18n.func_135052_a((String)"blockrenderer6343.nei.layer", (Object[])new Object[0]), 0, 148, 121, 16, -1, -1).setTextSupplier((Int2ObjectFunction<String>)((Int2ObjectFunction)value -> value == -1 ? I18n.func_135052_a((String)"blockrenderer6343.nei.all", (Object[])new Object[0]) : String.valueOf(value + 1))).setMaxValueSupplier(() -> (int)(GuiMultiblockHandler.renderer.world.getMaxPos().y - GuiMultiblockHandler.renderer.world.getMinPos().y)).setValueListener(this::setNextLayer).setIndex(1));
        this.loadChannels();
        this.addButtonInRow("P").setTooltip(I18n.func_135052_a((String)"blockrenderer6343.multiblock.project", (Object[])new Object[0])).setClickAction(() -> BRUtil.projectMultiblock(this.getBuildTriggerStack(), this.stackForm, MathHelper.floor_double((double)((float)GuiMultiblockHandler.MB_PLACE_POS.y - GuiMultiblockHandler.renderer.world.getMinPos().y))));
        this.addButtonInRow("?").setTooltip(I18n.func_135052_a((String)"blockrenderer6343.multiblock.overlay", (Object[])new Object[0])).setClickAction(() -> BRUtil.neiOverlay(renderer));
        if (!this.constructableData.getChannelData().isEmpty()) {
            this.addButtonInRow("C").setTooltip(I18n.func_135052_a((String)"blockrenderer6343.multiblock.copy_channels", (Object[])new Object[0])).setClickAction(() -> BRUtil.copyToHologram(this.trigger));
        }
    }

    protected BRButton addButtonInRow(@NotNull String displayString) {
        int totalButtons = this.buttonsInRow++;
        int yOffset = 136 + totalButtons / 2 * 18;
        BRButton button = new BRButton(145 - totalButtons % 2 * 22, yOffset, displayString).setIndex(totalButtons);
        this.allButtons.add((Object)button);
        return button;
    }

    protected void loadChannels() {
        Object2IntMap<String> channels = this.constructableData.getChannelData();
        int curSliders = this.allButtons.size();
        if (channels.isEmpty()) {
            return;
        }
        int i = 0;
        for (Object2IntMap.Entry entry : channels.object2IntEntrySet()) {
            String channel = (String)entry.getKey();
            int startVal = this.constructableData.getCurrentChannel().equals(channel) ? this.constructableData.getCurrentTier() : 0;
            this.allButtons.add((Object)new GuiSlider(StringUtils.capitalize((String)channel), 0, 136 + 12 * (i + curSliders), 121, 16, startVal, 0, entry.getIntValue()).setValueListener(val -> this.setChannelTier(channel, val)).setTextSupplier((Int2ObjectFunction<String>)((Int2ObjectFunction)value -> value == 0 ? I18n.func_135052_a((String)"blockrenderer6343.nei.not_set", (Object[])new Object[0]) : String.valueOf(value))).setIndex(i + curSliders));
            ++i;
        }
    }

    protected void loadNewMultiblock() {
        this.trigger = DEFAULT_TRIGGER.func_77946_l();
        int tier = this.constructableData.getCurrentTier();
        String channel = this.constructableData.getCurrentChannel();
        if (channel.isEmpty()) {
            this.trigger.field_77994_a = tier;
            this.tierSlider.setValue(this.trigger.field_77994_a, false);
        } else {
            this.setChannelTier(channel, tier, false);
        }
        layerIndex = -1;
        this.lastSearch = "";
        this.initializeSceneRenderer(true);
        lastRenderingController = renderingController;
    }

    private void setTier(int tier) {
        if (tier <= 0) {
            tier = 1;
        }
        if (renderer != null && tier == this.trigger.field_77994_a) {
            return;
        }
        this.trigger.field_77994_a = tier;
        this.initializeSceneRenderer(false);
    }

    private void setChannelTier(String channel, int tier) {
        this.setChannelTier(channel, tier, true);
    }

    private void setChannelTier(String channel, int tier, boolean rebuild) {
        if (tier < 0) {
            return;
        }
        if (tier > 0) {
            ChannelDataAccessor.setChannelData((ItemStack)this.trigger, (String)channel, (int)tier);
        } else {
            ChannelDataAccessor.unsetChannelData((ItemStack)this.trigger, (String)channel);
        }
        if (rebuild) {
            this.initializeSceneRenderer(false);
        }
    }

    private void setNextLayer(int newLayer) {
        LongSet renderBlocks;
        int height = (int)GuiMultiblockHandler.renderer.world.getSize().y() - 1;
        if (newLayer < 0 || newLayer > height) {
            newLayer = -1;
        }
        if (newLayer == layerIndex) {
            return;
        }
        layerIndex = newLayer;
        if (renderer == null) {
            return;
        }
        TrackedDummyWorld world = GuiMultiblockHandler.renderer.world;
        this.resetCenter();
        GuiMultiblockHandler.renderer.renderedBlocks.clear();
        int minY = (int)world.getMinPos().y();
        world.setVisibleYLevel(layerIndex == -1 ? -1 : minY + layerIndex);
        if (newLayer == -1) {
            renderBlocks = world.blockMap.keySet();
            renderer.setRenderAllFaces(false);
        } else {
            renderBlocks = new LongOpenHashSet();
            LongIterator longIterator = world.blockMap.keySet().iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                if (CoordinatePacker.unpackY((long)pos) - minY != newLayer) continue;
                renderBlocks.add(pos);
            }
            renderer.setRenderAllFaces(true);
        }
        renderer.addRenderedBlocks(renderBlocks);
        this.onIngredientChanged.accept(BRUtil.getIngredients(renderer));
    }

    private void resetCenter() {
        TrackedDummyWorld world = GuiMultiblockHandler.renderer.world;
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        center.set(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
    }

    public void drawMultiblock() {
        guiMouseX = GuiDraw.getMousePosition().x;
        guiMouseY = GuiDraw.getMousePosition().y;
        guiLeft = this.recipeGui.field_147003_i;
        guiTop = this.recipeGui.field_147009_r;
        int guiHeight = this.recipeGui.field_146295_m;
        this.scaleFactor = Math.min((float)this.recipeGui.field_146295_m / 500.0f, 1.0f);
        int scaledScene = Math.round(153.0f * this.scaleFactor);
        renderer.render(6 + guiLeft, 33 + guiTop, 163, scaledScene, lastGuiMouseX, lastGuiMouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.tooltipBlockStack = null;
        MovingObjectPosition rayTraceResult = renderer.getLastTraceResult();
        boolean leftClickHeld = Mouse.isButtonDown((int)0);
        boolean rightClickHeld = Mouse.isButtonDown((int)1);
        boolean middleClickHeld = Mouse.isButtonDown((int)2);
        if (this.isInsideView()) {
            int mouseDeltaY;
            if (leftClickHeld) {
                rotationPitch += (float)(guiMouseX - lastGuiMouseX + 360);
                rotationPitch %= 360.0f;
                rotationYaw = (float)MathHelper.clip((double)(rotationYaw + (float)(guiMouseY - lastGuiMouseY)), (double)-89.9, (double)89.9);
            } else if (rightClickHeld && Math.abs(mouseDeltaY = guiMouseY - lastGuiMouseY) > 1) {
                zoom = (float)MathHelper.clip((double)((double)zoom + (mouseDeltaY > 0 ? 0.15 : -0.15)), (double)3.0, (double)999.0);
            }
            if (middleClickHeld) {
                int mouseDeltaX = guiMouseX - lastGuiMouseX;
                int mouseDeltaY2 = guiMouseY - lastGuiMouseY;
                Vector3f lookAt = renderer.getLookAt();
                Vector3f eyePos = renderer.getEyePos();
                Vector3f worldUp = renderer.getWorldUp();
                Vector3f lookDir = new Vector3f((Vector3fc)lookAt).sub((Vector3fc)eyePos);
                Vector3f rightDir = lookDir.cross((Vector3fc)worldUp, new Vector3f()).normalize();
                Vector3f upDir = rightDir.cross((Vector3fc)lookDir, new Vector3f()).normalize();
                Vector3f offset = new Vector3f((float)(-mouseDeltaX) * rightDir.x() + (float)mouseDeltaY2 * upDir.x(), (float)(-mouseDeltaX) * rightDir.y() + (float)mouseDeltaY2 * upDir.y(), (float)(-mouseDeltaX) * rightDir.z() + (float)mouseDeltaY2 * upDir.z()).mul(0.15f);
                center.add((Vector3fc)offset);
            }
            if (this.scrolled != 0) {
                zoom = (float)MathHelper.clip((double)(zoom - (float)(this.scrolled * 5)), (double)3.0, (double)999.0);
                this.scrolled = 0;
            }
            renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        Point recipePos = this.recipeGui.getRecipePosition(0);
        this.relativeMousePos.set(guiMouseX - guiLeft - recipePos.x, guiMouseY - guiTop - recipePos.y);
        for (BRButton button : this.allButtons) {
            button.scalePosition(scaledScene, this.scaleFactor);
            button.func_146112_a(mc, this.relativeMousePos.x, this.relativeMousePos.y);
        }
        if (!(leftClickHeld || rightClickHeld || rayTraceResult == null || GuiMultiblockHandler.renderer.world.func_147437_c(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d))) {
            Block block = GuiMultiblockHandler.renderer.world.func_147439_a(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d);
            this.tooltipBlockStack = block.getPickBlock(rayTraceResult, (World)GuiMultiblockHandler.renderer.world, rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d, (EntityPlayer)GuiMultiblockHandler.mc.field_71439_g);
        }
        this.lastHeight = guiHeight;
        lastGuiMouseX = guiMouseX;
        lastGuiMouseY = guiMouseY;
    }

    private boolean isInsideView() {
        return guiMouseX >= guiLeft + 6 && guiMouseX <= guiLeft + 6 + 163 && guiMouseY >= guiTop + 33 && (float)guiMouseY <= (float)(guiTop + 33) + 153.0f * this.scaleFactor;
    }

    @NotNull
    protected String getMultiblockName() {
        return this.stackForm == null ? "" : I18n.func_135052_a((String)this.stackForm.func_82833_r(), (Object[])new Object[0]);
    }

    protected void initializeSceneRenderer(boolean resetCamera) {
        Vector3f eyePos = new Vector3f();
        Vector3f lookAt = new Vector3f();
        Vector3f worldUp = new Vector3f();
        if (!resetCamera) {
            try {
                eyePos = renderer.getEyePos();
                lookAt = renderer.getLookAt();
                worldUp = renderer.getWorldUp();
            }
            catch (NullPointerException e) {
                BlockRenderer6343.error("please reset camera on your first renderer call!");
            }
        }
        renderer = new ImmediateWorldSceneRenderer(new TrackedDummyWorld());
        GuiMultiblockHandler.renderer.world.updateEntitiesForNEI();
        BRUtil.FAKE_PLAYER.func_70029_a(GuiMultiblockHandler.renderer.world);
        GuiMultiblockHandler.renderer.world.func_72828_b(Collections.singletonList(BRUtil.FAKE_PLAYER));
        if (!StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.enableInstrument((Object)"blockrenderer6343");
        }
        structureElementMap.clear();
        this.placeMultiblock();
        if (StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.disableInstrument();
        }
        Vector3f size = GuiMultiblockHandler.renderer.world.getSize();
        Vector3f minPos = GuiMultiblockHandler.renderer.world.getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        GuiMultiblockHandler.renderer.renderedBlocks.clear();
        renderer.addRenderedBlocks(GuiMultiblockHandler.renderer.world.blockMap.keySet());
        renderer.setOnLookingAt(ray -> {});
        renderer.setOnWorldRender(this::onRendererRender);
        renderer.setPostBlockRender(this::onPostBlocksRendered);
        SELECTED_BLOCK.set(NO_SELECTED_BLOCK);
        this.onCandidateChanged.accept(Collections.emptyList());
        this.setNextLayer(layerIndex);
        if (resetCamera) {
            float max = Math.max(Math.max(size.x, size.y), size.z);
            float baseZoom = (float)(3.5 * Math.sqrt(max));
            float sizeFactor = (float)(1.0 + Math.log(max) / Math.log(10.0));
            zoom = baseZoom * sizeFactor / 1.5f;
            rotationYaw = 20.0f;
            rotationPitch = 50.0f;
            if (renderer != null) {
                this.resetCenter();
            }
        } else {
            renderer.setCameraLookAt(eyePos, lookAt, worldUp);
        }
    }

    public boolean handleMouseScrollUp(int scrolled) {
        if (this.isInsideView()) {
            this.scrolled = scrolled;
            return true;
        }
        for (BRButton button : this.allButtons) {
            if (!button.mouseScrolled(this.relativeMousePos.x, this.relativeMousePos.y, scrolled)) continue;
            return true;
        }
        return false;
    }

    public void onRendererRender(WorldSceneRenderer renderer) {
        MovingObjectPosition lookingPos = renderer.getLastTraceResult();
        long lookingBlock = lookingPos == null ? NO_SELECTED_BLOCK : CoordinatePacker.pack((int)lookingPos.field_72311_b, (int)lookingPos.field_72312_c, (int)lookingPos.field_72309_d);
        long selectedBlock = SELECTED_BLOCK.asLong();
        if (selectedBlock == lookingBlock) {
            this.renderBlockOverLay(selectedBlock, Blocks.field_150359_w.func_149691_a(0, 6));
            return;
        }
        this.renderBlockOverLay(lookingBlock, Blocks.field_150399_cn.func_149691_a(0, 7));
        this.renderBlockOverLay(selectedBlock, Blocks.field_150399_cn.func_149691_a(0, 14));
    }

    private void renderBlockOverLay(long pos, IIcon icon) {
        if (pos == NO_SELECTED_BLOCK) {
            return;
        }
        this.renderBlocks.field_147845_a = GuiMultiblockHandler.renderer.world;
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderBlocks.field_147837_f = true;
        int x = CoordinatePacker.unpackX((long)pos);
        int y = CoordinatePacker.unpackY((long)pos);
        int z = CoordinatePacker.unpackZ((long)pos);
        Block block = GuiMultiblockHandler.renderer.world.func_147439_a(x, y, z);
        this.renderBlocks.func_147792_a(block, x, y, z, icon);
    }

    public boolean mouseClicked(int button) {
        for (BRButton buttons : this.allButtons) {
            if (!buttons.func_146116_c(mc, this.relativeMousePos.x, this.relativeMousePos.y)) continue;
            SELECTED_BLOCK.set(NO_SELECTED_BLOCK);
            this.onCandidateChanged.accept(Collections.emptyList());
            return true;
        }
        if (button == 1 && renderer != null) {
            MovingObjectPosition rayTrace = renderer.getLastTraceResult();
            if (rayTrace == null) {
                if (SELECTED_BLOCK.asLong() != NO_SELECTED_BLOCK) {
                    SELECTED_BLOCK.set(NO_SELECTED_BLOCK);
                    this.onCandidateChanged.accept(Collections.emptyList());
                    return true;
                }
                return false;
            }
            long pos = CoordinatePacker.pack((int)rayTrace.field_72311_b, (int)rayTrace.field_72312_c, (int)rayTrace.field_72309_d);
            this.onCandidateChanged.accept(BRUtil.scanCandidates(this.getContextObject(), (IStructureElement<Object>)((IStructureElement)structureElementMap.get(pos)), this.getOriginalTriggerStack(), SELECTED_BLOCK.set(pos)));
        }
        return false;
    }

    public void onMouseDragged() {
        for (BRButton button : this.allButtons) {
            button.mouseDragged(this.relativeMousePos.x, this.relativeMousePos.y);
        }
    }

    public void onMouseReleased() {
        for (BRButton button : this.allButtons) {
            button.func_146118_a(this.relativeMousePos.x, this.relativeMousePos.y);
        }
    }

    @NotNull
    protected ItemStack getOriginalTriggerStack() {
        return DEFAULT_TRIGGER;
    }

    @NotNull
    protected ItemStack getBuildTriggerStack() {
        return this.trigger;
    }

    public void setOnCandidateChanged(Consumer<List<List<ItemStack>>> callback) {
        this.onCandidateChanged = callback;
    }

    public void setOnIngredientChanged(Consumer<List<ItemStack>> callback) {
        this.onIngredientChanged = callback;
    }

    public void recalculateSearch(String searchText) {
        if (renderer == null) {
            return;
        }
        if (searchText.isEmpty() && !this.lastSearch.isEmpty()) {
            renderer.resetRenderedBlocks();
            renderer.setRenderAllFaces(false);
            renderer.addRenderedBlocks(GuiMultiblockHandler.renderer.world.blockMap.keySet());
        }
        if (searchText.equals(this.lastSearch) || (this.lastSearch = searchText).isEmpty()) {
            return;
        }
        renderer.resetRenderedBlocks();
        boolean foundAny = false;
        Long2BooleanOpenHashMap checkedBlocks = new Long2BooleanOpenHashMap();
        for (Long2ObjectMap.Entry entry : GuiMultiblockHandler.renderer.world.blockMap.long2ObjectEntrySet()) {
            boolean add = checkedBlocks.computeIfAbsent(BRUtil.hashBlock(GuiMultiblockHandler.renderer.world, entry.getLongKey()), b -> {
                Block block = (Block)entry.getValue();
                ItemStack stack = new ItemStack(block, 1, BRUtil.getDamageValue(GuiMultiblockHandler.renderer.world, block, entry.getLongKey()));
                return this.matchesSearch(stack, searchText);
            });
            if (add) {
                foundAny = true;
                GuiMultiblockHandler.renderer.renderedBlocks.add(entry.getLongKey());
                continue;
            }
            GuiMultiblockHandler.renderer.renderOpaqueBlocks.add(entry.getLongKey());
        }
        if (!foundAny) {
            GuiMultiblockHandler.renderer.renderOpaqueBlocks.clear();
            GuiMultiblockHandler.renderer.renderedBlocks.addAll((LongCollection)GuiMultiblockHandler.renderer.world.blockMap.keySet());
            renderer.setRenderAllFaces(false);
        } else {
            renderer.setRenderAllFaces(true);
        }
    }

    public boolean matchesSearch(ItemStack stack, String searchText) {
        boolean matches = StringUtils.containsIgnoreCase((CharSequence)stack.func_82833_r(), (CharSequence)searchText);
        if (!matches) {
            List tooltip = stack.func_82840_a((EntityPlayer)GuiMultiblockHandler.mc.field_71439_g, GuiMultiblockHandler.mc.field_71474_y.field_82882_x);
            matches = tooltip.stream().anyMatch(s -> StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)searchText));
        }
        return matches;
    }

    public List<String> getHoveredTooltip(@NotNull ItemStack stack) {
        return stack.func_82840_a((EntityPlayer)GuiMultiblockHandler.mc.field_71439_g, GuiMultiblockHandler.mc.field_71474_y.field_82882_x);
    }

    @NotNull
    public List<String> getTooltip() {
        if (this.tooltipBlockStack != null) {
            return this.getHoveredTooltip(this.tooltipBlockStack);
        }
        for (BRButton button : this.allButtons) {
            List<String> tooltip = button.getTooltip(this.relativeMousePos);
            if (tooltip.isEmpty()) continue;
            return tooltip;
        }
        return Collections.emptyList();
    }

    protected Object getContextObject() {
        return renderingController;
    }

    protected void onPostBlocksRendered(WorldSceneRenderer renderer) {
    }

    protected void onElementAdded(@NotNull IStructureElement<Object> element, long pos) {
    }

    @SubscribeEvent
    public static void OnStructureEvent(StructureEvent.StructureElementVisitedEvent event) {
        if (!"blockrenderer6343".equals(event.getInstrumentIdentifier())) {
            return;
        }
        GuiMultiblockHandler handler = MultiblockHandler.getCurrentGuiHandler();
        if (handler == null) {
            return;
        }
        IStructureElement element = event.getElement();
        long pos = CoordinatePacker.pack((int)event.getX(), (int)event.getY(), (int)event.getZ());
        handler.onElementAdded((IStructureElement<Object>)element, pos);
        structureElementMap.put(pos, (Object)element);
    }

    static {
        NO_SELECTED_BLOCK = CoordinatePacker.pack((int)-100000, (int)0, (int)-100000);
        structureElementMap = new Long2ObjectOpenHashMap();
        MB_PLACE_POS = new BlockPos(0, 64, 0);
        SELECTED_BLOCK = new BlockPos().set(NO_SELECTED_BLOCK);
        DEFAULT_TRIGGER = new ItemStack(StructureLibAPI.getDefaultHologramItem());
        center = new Vector3f();
        layerIndex = -1;
        mc = Minecraft.func_71410_x();
    }
}

