/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.integration.nei.StructureHacks;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConstructableData {
    private static final Object2ObjectMap<IConstructable, ConstructableData> constructableData = new Object2ObjectOpenHashMap();
    private static final ConstructableData EMPTY = new ConstructableData();
    private final Object2IntMap<String> channelMaxTierMap = new Object2IntOpenHashMap();
    private final Long2IntMap itemTiers = new Long2IntOpenHashMap();
    private final Long2ObjectMap<String> itemChannels = new Long2ObjectOpenHashMap();
    private String currentChannel = "";
    private int maxTotalTier = 1;
    private int currentTier;
    private boolean hasData = false;

    @NotNull
    public static ConstructableData getTierData(IConstructable constructable) {
        return (ConstructableData)constructableData.getOrDefault((Object)constructable, (Object)EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConstructableData(Object2ObjectMap<IConstructable, ConstructableData> data) {
        Object2ObjectMap<IConstructable, ConstructableData> object2ObjectMap = constructableData;
        synchronized (object2ObjectMap) {
            constructableData.putAll(data);
        }
    }

    public boolean addItemTier(@NotNull ItemStack item, @NotNull String channel, int tier) {
        if (this == EMPTY || !StructureHacks.isSafeStack(item)) {
            return false;
        }
        this.hasData = true;
        long hash = BRUtil.hashStack(item);
        if (!channel.isEmpty()) {
            this.itemChannels.put(hash, (Object)channel);
        }
        return this.itemTiers.put(hash, tier) == this.itemTiers.defaultReturnValue();
    }

    public void setMaxTier(int tier, @NotNull String channel) {
        if (this == EMPTY) {
            return;
        }
        this.hasData = true;
        this.maxTotalTier = Math.max(this.maxTotalTier, tier);
        if (!channel.isEmpty() && this.channelMaxTierMap.getInt((Object)channel) < tier) {
            this.channelMaxTierMap.put((Object)channel, tier);
        }
    }

    public boolean hasData() {
        return this.hasData;
    }

    public ConstructableData setTierFromStack(ItemStack stack) {
        long hash = BRUtil.hashStack(stack);
        this.currentTier = this.itemTiers.getOrDefault(hash, 1);
        this.currentChannel = (String)this.itemChannels.getOrDefault(hash, (Object)"");
        return this;
    }

    public int getMaxTotalTier() {
        return this.maxTotalTier;
    }

    public int getCurrentTier() {
        return this.currentTier;
    }

    @NotNull
    public String getCurrentChannel() {
        return this.currentChannel;
    }

    public Object2IntMap<String> getChannelData() {
        return this.channelMaxTierMap;
    }
}

