/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.DrawableArray;
import com.cleanroommc.modularui.drawable.TabTexture;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeSelectable;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.PagedWidget;
import org.jetbrains.annotations.NotNull;

public class PageButton
extends Widget<PageButton>
implements Interactable {
    private final int index;
    private final PagedWidget.Controller controller;
    private IDrawable inactiveTexture = null;
    private boolean invert = false;

    public PageButton(int index, PagedWidget.Controller controller) {
        this.index = index;
        this.controller = controller;
        this.disableHoverBackground();
    }

    @Override
    public WidgetTheme getWidgetThemeInternal(ITheme theme) {
        WidgetThemeSelectable widgetTheme = theme.getToggleButtonTheme();
        return this.isActive() ^ this.invertSelected() ? widgetTheme : widgetTheme.getSelected();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (!this.isActive()) {
            this.controller.setPage(this.index);
            Interactable.playButtonClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public IDrawable getBackground() {
        return this.isActive() || this.inactiveTexture == null ? super.getBackground() : this.inactiveTexture;
    }

    public boolean isActive() {
        return this.controller.getActivePageIndex() == this.index;
    }

    public PageButton background(boolean active, IDrawable ... background) {
        if (active) {
            return (PageButton)this.background(background);
        }
        this.inactiveTexture = background.length == 0 ? null : (background.length == 1 ? background[0] : new DrawableArray(background));
        return this;
    }

    public PageButton tab(TabTexture texture, int location) {
        return (PageButton)((PageButton)this.background(this.invertSelected(), texture.get(location, this.invertSelected())).background(!this.invertSelected(), texture.get(location, !this.invertSelected())).disableHoverBackground()).size(texture.getWidth(), texture.getHeight());
    }

    public PageButton invertSelected(boolean invert) {
        this.invert = invert;
        return (PageButton)this.getThis();
    }

    public boolean invertSelected() {
        return this.invert;
    }
}

