/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IParentWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.AbstractScrollWidget;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.IntFunction;

public class ListWidget<I extends IWidget, W extends ListWidget<I, W>>
extends AbstractScrollWidget<I, W>
implements ILayoutWidget,
IParentWidget<I, W> {
    private ScrollData scrollData;
    private IIcon childSeparator;
    private final IntList separatorPositions = new IntArrayList();

    public ListWidget() {
        super(null, null);
    }

    @Override
    public void onInit() {
        if (this.scrollData == null) {
            this.scrollDirection(new VerticalScrollData());
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        int h;
        int w;
        if (this.childSeparator == null || this.separatorPositions.isEmpty()) {
            return;
        }
        GuiAxis axis = this.scrollData.getAxis();
        int x = this.getArea().getPadding().left;
        int y = this.getArea().getPadding().top;
        if (axis.isHorizontal()) {
            w = this.childSeparator.getWidth();
            h = this.getArea().h() - this.getArea().getPadding().vertical();
        } else {
            w = this.getArea().w() - this.getArea().getPadding().horizontal();
            h = this.childSeparator.getHeight();
        }
        IntListIterator intListIterator = this.separatorPositions.iterator();
        while (intListIterator.hasNext()) {
            int p = (Integer)intListIterator.next();
            if (axis.isHorizontal()) {
                x = p;
            } else {
                y = p;
            }
            this.childSeparator.draw(context, x, y, w, h, widgetTheme);
        }
    }

    @Override
    public void layoutWidgets() {
        this.separatorPositions.clear();
        GuiAxis axis = this.scrollData.getAxis();
        int separatorSize = this.getSeparatorSize();
        int p = this.getArea().getPadding().getStart(axis);
        for (IWidget widget : this.getChildren()) {
            if (!widget.isEnabled() || (axis.isVertical() ? widget.getFlex().hasYPos() || !widget.resizer().isHeightCalculated() : widget.getFlex().hasXPos() || !widget.resizer().isWidthCalculated())) continue;
            widget.getArea().setRelativePoint(axis, p += widget.getArea().getMargin().getStart(axis));
            p += widget.getArea().getSize(axis) + widget.getArea().getMargin().getEnd(axis);
            if (axis.isHorizontal()) {
                widget.resizer().setXResized(true);
            } else {
                widget.resizer().setYResized(true);
            }
            this.separatorPositions.add(p);
            p += separatorSize;
        }
        this.getScrollData().setScrollSize(p + this.getArea().getPadding().getEnd(axis));
    }

    @Override
    public boolean addChild(I child, int index) {
        return super.addChild(child, index);
    }

    @Override
    public void onChildAdd(I child) {
        super.onChildAdd(child);
        if (this.isValid()) {
            this.scrollData.clamp(this.getScrollArea());
        }
    }

    @Override
    public void onChildRemove(I child) {
        super.onChildRemove(child);
        if (this.isValid()) {
            this.scrollData.clamp(this.getScrollArea());
        }
    }

    public int getSeparatorSize() {
        if (this.childSeparator == null) {
            return 0;
        }
        return this.scrollData.getAxis().isHorizontal() ? this.childSeparator.getWidth() : this.childSeparator.getHeight();
    }

    public ScrollData getScrollData() {
        return this.scrollData;
    }

    public W scrollDirection(GuiAxis axis) {
        return this.scrollDirection(ScrollData.of(axis));
    }

    public W scrollDirection(ScrollData data) {
        this.scrollData = data;
        this.getScrollArea().removeScrollData();
        this.getScrollArea().setScrollData(this.scrollData);
        return (W)((ListWidget)this.getThis());
    }

    public W childSeparator(IIcon separator) {
        this.childSeparator = separator;
        return (W)((ListWidget)this.getThis());
    }

    public W children(Iterable<I> widgets) {
        for (IWidget widget : widgets) {
            this.child(widget);
        }
        return (W)((ListWidget)this.getThis());
    }

    public W children(int amount, IntFunction<I> widgetCreator) {
        for (int i = 0; i < amount; ++i) {
            this.child((IWidget)widgetCreator.apply(i));
        }
        return (W)((ListWidget)this.getThis());
    }
}

