/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.value.IValue;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.IPositioned;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.api.widget.ITooltip;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widget.sizer.IUnResizeable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Widget<W extends Widget<W>>
implements IWidget,
IPositioned<W>,
ITooltip<W>,
ISynced<W> {
    @Nullable
    private String debugName;
    private boolean enabled = true;
    private boolean valid = false;
    private IWidget parent = null;
    private ModularPanel panel = null;
    private ModularGuiContext context = null;
    private final Area area = new Area();
    private final Flex flex = new Flex(this);
    private IResizeable resizer = this.flex;
    @Nullable
    private IValue<?> value;
    @Nullable
    private String syncKey;
    @Nullable
    private SyncHandler syncHandler;
    @Nullable
    private IDrawable background = null;
    @Nullable
    private IDrawable overlay = null;
    @Nullable
    private IDrawable hoverBackground = null;
    @Nullable
    private IDrawable hoverOverlay = null;
    @Nullable
    private RichTooltip tooltip;
    @Nullable
    private String widgetThemeOverride = null;
    @Nullable
    private List<IGuiAction> guiActionListeners;
    @Nullable
    private Consumer<W> onUpdateListener;

    @Override
    @ApiStatus.Internal
    public void initialise(@NotNull IWidget parent) {
        if (!(this instanceof ModularPanel)) {
            this.parent = parent;
            this.panel = parent.getPanel();
            this.context = parent.getContext();
            this.getArea().setPanelLayer(this.panel.getArea().getPanelLayer());
            this.getArea().z(parent.getArea().z() + 1);
            if (this.guiActionListeners != null) {
                for (IGuiAction action : this.guiActionListeners) {
                    this.context.getScreen().registerGuiActionListener(action);
                }
            }
        }
        if (this.value != null && this.syncKey != null) {
            throw new IllegalStateException("Widget has a value and a sync key for a synced value. This is not allowed!");
        }
        this.valid = true;
        if (!this.getScreen().isClientOnly()) {
            this.initialiseSyncHandler(this.getScreen().getSyncManager());
        }
        this.onInit();
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.initialise(this);
            }
        }
        this.afterInit();
        this.onUpdate();
    }

    @ApiStatus.OverrideOnly
    public void onInit() {
    }

    @ApiStatus.OverrideOnly
    public void afterInit() {
    }

    @Override
    public void initialiseSyncHandler(ModularSyncManager syncManager) {
        ValueSyncHandler valueSyncHandler;
        if (this.syncKey != null) {
            this.syncHandler = syncManager.getSyncHandler(this.getPanel().getName(), this.syncKey);
        }
        if (!(this.syncKey == null && this.syncHandler == null || this.isValidSyncHandler(this.syncHandler))) {
            String type = this.syncHandler == null ? null : this.syncHandler.getClass().getName();
            this.syncHandler = null;
            throw new IllegalStateException("SyncHandler of type " + type + " is not valid for " + this.getClass().getName() + ", with key " + this.syncKey);
        }
        SyncHandler syncHandler = this.syncHandler;
        if (syncHandler instanceof ValueSyncHandler && (valueSyncHandler = (ValueSyncHandler)syncHandler).getChangeListener() == null) {
            valueSyncHandler.setChangeListener(this::markTooltipDirty);
        }
    }

    @Override
    public void dispose() {
        if (this.isValid() && this.guiActionListeners != null) {
            for (IGuiAction action : this.guiActionListeners) {
                this.context.getScreen().removeGuiActionListener(action);
            }
        }
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.dispose();
            }
        }
        if (!(this instanceof ModularPanel)) {
            this.panel = null;
            this.parent = null;
            this.context = null;
        }
        this.valid = false;
    }

    @Override
    public void drawBackground(ModularGuiContext context, WidgetTheme widgetTheme) {
        IDrawable bg = this.getCurrentBackground(context.getTheme(), widgetTheme);
        if (bg != null) {
            bg.drawAtZero(context, this.getArea().width, this.getArea().height, widgetTheme);
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
    }

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetTheme widgetTheme) {
        IDrawable bg = this.getCurrentOverlay(context.getTheme(), widgetTheme);
        if (bg != null) {
            bg.drawAtZero((GuiContext)context, this.getArea(), widgetTheme);
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw(context);
        }
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getOverlay() {
        return this.overlay;
    }

    @Nullable
    public IDrawable getHoverBackground() {
        return this.hoverBackground;
    }

    @Nullable
    public IDrawable getHoverOverlay() {
        return this.hoverOverlay;
    }

    public IDrawable getCurrentBackground(ITheme theme, WidgetTheme widgetTheme) {
        IDrawable background;
        if (this.isHovering()) {
            IDrawable hoverBackground = this.getHoverBackground();
            if (hoverBackground == null) {
                hoverBackground = widgetTheme.getHoverBackground();
            }
            if (hoverBackground != null && hoverBackground != IDrawable.NONE) {
                return hoverBackground;
            }
        }
        return (background = this.getBackground()) == null ? widgetTheme.getBackground() : background;
    }

    public IDrawable getCurrentOverlay(ITheme theme, WidgetTheme widgetTheme) {
        IDrawable hoverBackground = this.getHoverOverlay();
        return hoverBackground != null && hoverBackground != IDrawable.NONE && this.isHovering() ? hoverBackground : this.getOverlay();
    }

    @Override
    @Nullable
    public RichTooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public RichTooltip tooltip() {
        if (this.tooltip == null) {
            this.tooltip = new RichTooltip(this);
        }
        return this.tooltip;
    }

    @Override
    public W tooltip(RichTooltip tooltip) {
        this.tooltip = tooltip;
        return (W)this.getThis();
    }

    @Override
    public void markTooltipDirty() {
        if (this.tooltip != null) {
            this.tooltip.markDirty();
        }
    }

    @ApiStatus.OverrideOnly
    protected WidgetTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getFallback();
    }

    @Override
    @ApiStatus.NonExtendable
    public final WidgetTheme getWidgetTheme(ITheme theme) {
        if (this.widgetThemeOverride != null) {
            return theme.getWidgetTheme(this.widgetThemeOverride);
        }
        return this.getWidgetThemeInternal(theme);
    }

    public W background(IDrawable ... background) {
        this.background = IDrawable.of(background);
        return (W)this.getThis();
    }

    public W overlay(IDrawable ... overlay) {
        this.overlay = IDrawable.of(overlay);
        return (W)this.getThis();
    }

    public W hoverBackground(IDrawable ... background) {
        this.hoverBackground = IDrawable.of(background);
        return (W)this.getThis();
    }

    public W hoverOverlay(IDrawable ... overlay) {
        this.hoverOverlay = IDrawable.of(overlay);
        return (W)this.getThis();
    }

    public W disableHoverBackground() {
        return this.hoverBackground(IDrawable.NONE);
    }

    public W disableHoverOverlay() {
        return this.hoverOverlay(IDrawable.NONE);
    }

    public W widgetTheme(String s) {
        if (!IThemeApi.get().hasWidgetTheme(s)) {
            throw new IllegalArgumentException("No widget theme for id '" + s + "' exists.");
        }
        this.widgetThemeOverride = s;
        return (W)this.getThis();
    }

    @Override
    @MustBeInvokedByOverriders
    public void onUpdate() {
        if (this.onUpdateListener != null) {
            this.onUpdateListener.accept(this.getThis());
        }
    }

    @Nullable
    public Consumer<W> getOnUpdateListener() {
        return this.onUpdateListener;
    }

    public W listenGuiAction(IGuiAction action) {
        if (this.guiActionListeners == null) {
            this.guiActionListeners = new ArrayList<IGuiAction>();
        }
        this.guiActionListeners.add(action);
        if (this.isValid()) {
            this.context.getScreen().registerGuiActionListener(action);
        }
        return (W)this.getThis();
    }

    public W onUpdateListener(Consumer<W> listener) {
        return this.onUpdateListener(listener, false);
    }

    public W onUpdateListener(Consumer<W> listener, boolean merge) {
        if (merge && this.onUpdateListener != null) {
            if (listener != null) {
                this.onUpdateListener = w -> {
                    this.onUpdateListener.accept(w);
                    listener.accept(w);
                };
            }
        } else {
            this.onUpdateListener = listener;
        }
        return (W)this.getThis();
    }

    public W setEnabledIf(Predicate<W> condition) {
        return (W)this.onUpdateListener(w -> this.setEnabled(condition.test(w)), true);
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public Flex getFlex() {
        return this.flex;
    }

    @Override
    public Flex flex() {
        return this.flex;
    }

    @Override
    public IResizeable resizer() {
        return this.resizer;
    }

    @Override
    public void resizer(IResizeable resizer) {
        this.resizer = resizer != null ? resizer : IUnResizeable.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public ModularScreen getScreen() {
        return this.getPanel().getScreen();
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not in a valid state!");
        }
        return this.panel;
    }

    @Override
    @NotNull
    public IWidget getParent() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not in a valid state!");
        }
        return this.parent;
    }

    @Override
    public ModularGuiContext getContext() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not in a valid state!");
        }
        return this.context;
    }

    @ApiStatus.Internal
    protected final void setContext(ModularGuiContext context) {
        this.context = context;
    }

    @Override
    public boolean isSynced() {
        return this.syncHandler != null;
    }

    @Override
    @NotNull
    public SyncHandler getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised or not synced!");
        }
        return this.syncHandler;
    }

    @Nullable
    public IValue<?> getValue() {
        return this.value;
    }

    @Override
    public W syncHandler(String name, int id) {
        this.syncKey = ModularSyncManager.makeSyncKey(name, id);
        return (W)this.getThis();
    }

    protected void setValue(IValue<?> value) {
        this.value = value;
        if (value instanceof SyncHandler) {
            SyncHandler syncHandler1 = (SyncHandler)((Object)value);
            this.setSyncHandler(syncHandler1);
        }
    }

    protected void setSyncHandler(@Nullable SyncHandler syncHandler) {
        this.syncHandler = syncHandler;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public W disabled() {
        this.setEnabled(false);
        return (W)this.getThis();
    }

    public W debugName(String name) {
        this.debugName = name;
        return (W)this.getThis();
    }

    @Override
    public W getThis() {
        return (W)this;
    }

    public String toString() {
        if (this.debugName != null) {
            return this.getClass().getSimpleName() + "#" + this.debugName;
        }
        return this.getClass().getSimpleName();
    }
}

