/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import codechicken.nei.ItemPanels;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.integration.nei.NEIDragAndDropHandler;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Animator;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularPanel
extends ParentWidget<ModularPanel>
implements IViewport {
    private static final int tapTime = 200;
    @NotNull
    private final String name;
    private ModularScreen screen;
    private IPanelHandler panelHandler;
    private State state = State.IDLE;
    private boolean cantDisposeNow = false;
    private final ObjectList<LocatedWidget> hovering = ObjectList.create();
    private final Input keyboard = new Input();
    private final Input mouse = new Input();
    private final List<IPanelHandler> clientSubPanels = new ArrayList<IPanelHandler>();
    private boolean invisible = false;
    private Animator animator;
    private float scale = 1.0f;
    private float alpha = 1.0f;

    public static ModularPanel defaultPanel(@NotNull String name) {
        return ModularPanel.defaultPanel(name, 176, 166);
    }

    public static ModularPanel defaultPanel(@NotNull String name, int width, int height) {
        return (ModularPanel)new ModularPanel(name).size(width, height);
    }

    public ModularPanel(@NotNull String name) {
        this.name = Objects.requireNonNull(name, "A panels name must not be null and should be unique!");
        this.center();
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        return this;
    }

    @Override
    public Area getParentArea() {
        return this.getScreen().getScreenArea();
    }

    @Override
    public void onInit() {
        this.getScreen().registerFrameUpdateListener(this, this::findHoveredWidgets, false);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        return syncHandler instanceof IPanelHandler;
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public void closeIfOpen(boolean animate) {
        if (!this.isOpen()) {
            return;
        }
        this.closeSubPanels();
        if (!animate || !this.shouldAnimate()) {
            this.screen.getPanelManager().closePanel(this);
            return;
        }
        if (!this.isOpening() && !this.isClosing()) {
            if (this.isMainPanel()) {
                for (ModularPanel panel : this.getScreen().getPanelManager().getOpenPanels()) {
                    if (panel.isMainPanel()) continue;
                    panel.closeIfOpen(true);
                }
            }
            this.getAnimator().setEndCallback(val -> this.screen.getPanelManager().closePanel(this)).backward();
        }
    }

    protected void closeSubPanels() {
        if (this.panelHandler != null) {
            this.panelHandler.closeSubPanels();
        }
    }

    public void animateClose() {
        this.closeIfOpen(true);
    }

    void setPanelHandler(IPanelHandler panelHandler) {
        this.panelHandler = panelHandler;
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public WidgetTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getPanelTheme();
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        if (this.getScale() != 1.0f) {
            float x = (float)this.getArea().w() / 2.0f;
            float y = (float)this.getArea().h() / 2.0f;
            stack.translate(x, y);
            stack.scale(this.getScale(), this.getScale());
            stack.translate(-x, -y);
        }
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    @Override
    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.isInside(stack, x, y)) {
            widgets.add(this, stack.peek());
        }
    }

    private void findHoveredWidgets() {
        this.hovering.clear();
        this.hovering.trim();
        if (!this.isEnabled()) {
            return;
        }
        HoveredWidgetList widgetList = new HoveredWidgetList(this.hovering);
        this.getContext().reset();
        GuiViewportStack stack = new GuiViewportStack();
        stack.pushViewport(null, this.getScreen().getScreenArea());
        stack.pushViewport(this, this.getArea());
        this.transform(stack);
        this.getSelfAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        this.transformChildren(stack);
        this.getWidgetsAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        stack.popViewport(this);
        stack.popViewport(null);
    }

    @Override
    public boolean canHover() {
        return !this.invisible && super.canHover();
    }

    @MustBeInvokedByOverriders
    public void onOpen(ModularScreen screen) {
        this.screen = screen;
        this.getArea().z(1);
        this.scale = 1.0f;
        this.alpha = 1.0f;
        this.initialise(this);
        if (this.shouldAnimate()) {
            this.scale = 0.75f;
            this.alpha = 0.0f;
            this.getAnimator().setEndCallback(value -> {
                this.scale = 1.0f;
                this.alpha = 1.0f;
            }).forward();
        }
        this.state = State.OPEN;
    }

    void reopen() {
        if (this.state != State.CLOSED) {
            throw new IllegalStateException();
        }
        this.state = State.OPEN;
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        if (!this.getScreen().isOverlay()) {
            this.getContext().getNEISettings().removeNEIExclusionArea(this);
        }
        this.state = State.CLOSED;
        if (this.panelHandler != null) {
            this.panelHandler.closePanelInternal();
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.state == State.DISPOSED) {
            return;
        }
        if (this.state != State.CLOSED && this.state != State.WAIT_DISPOSING) {
            throw new IllegalStateException("Panel must be closed before disposing!");
        }
        if (this.cantDisposeNow) {
            this.state = State.WAIT_DISPOSING;
            return;
        }
        super.dispose();
        this.screen = null;
        this.state = State.DISPOSED;
    }

    public final <T> T doSafe(Supplier<T> runnable) {
        if (this.state == State.DISPOSED) {
            return null;
        }
        return (T)this.getScreen().getPanelManager().doSafe(() -> {
            this.cantDisposeNow = true;
            Object t = runnable.get();
            this.cantDisposeNow = false;
            if (this.state == State.WAIT_DISPOSING) {
                this.state = State.CLOSED;
                this.dispose();
            }
            return t;
        });
    }

    public final boolean doSafeBool(BooleanSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsBoolean));
    }

    public final int doSafeInt(IntSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsInt));
    }

    @ApiStatus.OverrideOnly
    public boolean onMousePressed(int mouseButton) {
        return this.doSafeBool(() -> {
            boolean result;
            LocatedWidget pressed;
            block21: {
                block20: {
                    pressed = LocatedWidget.EMPTY;
                    result = false;
                    if (!this.hovering.isEmpty()) break block20;
                    if (!this.closeOnOutOfBoundsClick()) break block21;
                    this.animateClose();
                    result = true;
                    break block21;
                }
                ObjectListIterator objectListIterator = this.hovering.iterator();
                block6: while (objectListIterator.hasNext()) {
                    Object patt10807$temp;
                    LocatedWidget widget = (LocatedWidget)objectListIterator.next();
                    widget.applyMatrix(this.getContext());
                    ItemStack dndTarget = this.getNEIDragAndDropTarget();
                    if (dndTarget != null && (patt10807$temp = widget.getElement()) instanceof NEIDragAndDropHandler) {
                        NEIDragAndDropHandler dndHandler = (NEIDragAndDropHandler)patt10807$temp;
                        if (dndHandler.handleDragAndDrop(dndTarget, mouseButton)) {
                            if (ItemPanels.itemPanel.draggedStack != null && ItemPanels.itemPanel.draggedStack.field_77994_a == 0) {
                                ItemPanels.itemPanel.draggedStack = null;
                            }
                            if (ItemPanels.bookmarkPanel.draggedStack != null && ItemPanels.bookmarkPanel.draggedStack.field_77994_a == 0) {
                                ItemPanels.bookmarkPanel.draggedStack = null;
                            }
                            pressed = widget;
                        } else {
                            pressed = LocatedWidget.EMPTY;
                        }
                        result = true;
                        widget.unapplyMatrix(this.getContext());
                        break;
                    }
                    Object patt12593$temp = widget.getElement();
                    if (patt12593$temp instanceof Interactable) {
                        Interactable interactable = (Interactable)patt12593$temp;
                        switch (interactable.onMousePressed(mouseButton)) {
                            case IGNORE: {
                                break;
                            }
                            case ACCEPT: {
                                if (!this.mouse.held) {
                                    this.mouse.addAcceptedInteractable(interactable);
                                }
                                pressed = widget;
                                break;
                            }
                            case STOP: {
                                pressed = LocatedWidget.EMPTY;
                                result = true;
                                widget.unapplyMatrix(this.getContext());
                                break block6;
                            }
                            case SUCCESS: {
                                if (!this.mouse.held) {
                                    this.mouse.addAcceptedInteractable(interactable);
                                }
                                pressed = widget;
                                result = true;
                                widget.unapplyMatrix(this.getContext());
                                break block6;
                            }
                        }
                    }
                    if (this.getContext().onHoveredClick(mouseButton, widget)) {
                        pressed = LocatedWidget.EMPTY;
                        result = true;
                        widget.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget.unapplyMatrix(this.getContext());
                    if (((IWidget)widget.getElement()).canClickThrough()) continue;
                    result = true;
                    break;
                }
            }
            if (result && pressed.getElement() instanceof IFocusedWidget) {
                this.getContext().focus(pressed);
            } else {
                this.getContext().removeFocus();
            }
            if (!this.mouse.held) {
                this.mouse.lastPressed = pressed;
                if (this.mouse.lastPressed.getElement() != null) {
                    this.mouse.timeHeld = Minecraft.func_71386_F();
                }
                this.mouse.lastButton = mouseButton;
                this.mouse.held = true;
            }
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseRelease(int mouseButton) {
        return this.isEnabled() && this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseRelease(mouseButton), false).booleanValue()) {
                return true;
            }
            boolean result = false;
            boolean tryTap = this.mouse.tryTap(mouseButton);
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt15680$temp = widget2.getElement();
                if (!(patt15680$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt15680$temp;
                widget2.applyMatrix(this.getContext());
                if (interactable.onMouseRelease(mouseButton)) {
                    result = true;
                    widget2.applyMatrix(this.getContext());
                    break;
                }
                if (tryTap && this.mouse.acceptedInteractions.remove(interactable)) {
                    boolean bl;
                    Interactable.Result tabResult = interactable.onMouseTapped(mouseButton);
                    switch (tabResult) {
                        case SUCCESS: 
                        case STOP: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    tryTap = bl;
                }
                widget2.unapplyMatrix(this.getContext());
            }
            this.mouse.reset();
            return result;
        });
    }

    private ItemStack getNEIDragAndDropTarget() {
        if (this.getContext().getScreen().isOverlay() || !this.getContext().getNEISettings().isNEIEnabled(this.screen)) {
            return null;
        }
        if (ItemPanels.itemPanel.draggedStack != null) {
            return ItemPanels.itemPanel.draggedStack;
        }
        if (ItemPanels.bookmarkPanel.draggedStack != null) {
            return ItemPanels.bookmarkPanel.draggedStack;
        }
        return null;
    }

    @ApiStatus.OverrideOnly
    public boolean onKeyPressed(char typedChar, int keyCode) {
        return this.doSafeBool(() -> {
            switch (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyPressed(typedChar, keyCode), Interactable.Result.IGNORE)) {
                case SUCCESS: 
                case STOP: {
                    if (!this.keyboard.held) {
                        this.keyboard.lastPressed = this.getContext().getFocusedWidget();
                        if (this.keyboard.lastPressed != null) {
                            this.keyboard.timeHeld = Minecraft.func_71386_F();
                        }
                        this.keyboard.lastButton = keyCode;
                        this.keyboard.held = true;
                    }
                    return true;
                }
            }
            LocatedWidget pressed = null;
            boolean result = false;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            block9: while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt18001$temp = widget2.getElement();
                if (patt18001$temp instanceof Interactable) {
                    Interactable interactable = (Interactable)patt18001$temp;
                    widget2.applyMatrix(this.getContext());
                    switch (interactable.onKeyPressed(typedChar, keyCode)) {
                        case IGNORE: {
                            break;
                        }
                        case ACCEPT: {
                            if (!this.keyboard.held) {
                                this.keyboard.acceptedInteractions.add(interactable);
                            }
                            pressed = widget2;
                            break;
                        }
                        case STOP: {
                            pressed = null;
                            result = true;
                            widget2.unapplyMatrix(this.getContext());
                            break block9;
                        }
                        case SUCCESS: {
                            if (!this.keyboard.held) {
                                this.keyboard.acceptedInteractions.add(interactable);
                            }
                            pressed = widget2;
                            result = true;
                            widget2.unapplyMatrix(this.getContext());
                            break block9;
                        }
                    }
                    widget2.unapplyMatrix(this.getContext());
                }
                if (((IWidget)widget2.getElement()).canClickThrough()) continue;
            }
            if (!this.keyboard.held) {
                this.keyboard.lastPressed = pressed;
                if (this.keyboard.lastPressed != null) {
                    this.keyboard.timeHeld = Minecraft.func_71386_F();
                }
                this.keyboard.lastButton = keyCode;
                this.keyboard.held = true;
            }
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onKeyRelease(char typedChar, int keyCode) {
        return this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyRelease(typedChar, keyCode), false).booleanValue()) {
                return true;
            }
            boolean result = false;
            boolean tryTap = this.keyboard.tryTap(keyCode);
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt20317$temp = widget2.getElement();
                if (!(patt20317$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt20317$temp;
                widget2.applyMatrix(this.getContext());
                if (interactable.onKeyRelease(typedChar, keyCode)) {
                    result = true;
                    widget2.unapplyMatrix(this.getContext());
                    break;
                }
                if (tryTap && this.keyboard.acceptedInteractions.remove(interactable)) {
                    boolean bl;
                    Interactable.Result tabResult = interactable.onKeyTapped(typedChar, keyCode);
                    switch (tabResult) {
                        case SUCCESS: 
                        case STOP: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    tryTap = bl;
                }
                widget2.unapplyMatrix(this.getContext());
            }
            this.keyboard.reset();
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        return this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseScroll(scrollDirection, amount), false).booleanValue()) {
                return true;
            }
            if (this.hovering.isEmpty()) {
                return false;
            }
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt21648$temp = widget2.getElement();
                if (!(patt21648$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt21648$temp;
                widget2.applyMatrix(this.getContext());
                boolean result = interactable.onMouseScroll(scrollDirection, amount);
                widget2.unapplyMatrix(this.getContext());
                if (!result) continue;
                return true;
            }
            return false;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        return this.doSafeBool(() -> {
            Object patt22348$temp;
            if (this.mouse.held && mouseButton == this.mouse.lastButton && this.mouse.lastPressed != null && (patt22348$temp = this.mouse.lastPressed.getElement()) instanceof Interactable) {
                Interactable interactable = (Interactable)patt22348$temp;
                this.mouse.lastPressed.applyMatrix(this.getContext());
                interactable.onMouseDrag(mouseButton, timeSinceClick);
                this.mouse.lastPressed.unapplyMatrix(this.getContext());
                return true;
            }
            return false;
        });
    }

    private <T, W extends IWidget & IFocusedWidget> T interactFocused(Function<W, T> function, T defaultValue) {
        LocatedWidget focused = this.getContext().getFocusedWidget();
        T result = defaultValue;
        Object t = focused.getElement();
        if (t instanceof Interactable) {
            Interactable interactable = (Interactable)t;
            focused.applyMatrix(this.getContext());
            result = function.apply((IWidget)((Object)interactable));
            focused.unapplyMatrix(this.getContext());
        }
        return result;
    }

    public boolean isDraggable() {
        return this.getScreen().getMainPanel() != this;
    }

    public boolean disablePanelsBelow() {
        return false;
    }

    public boolean closeOnOutOfBoundsClick() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public ModularScreen getScreen() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.screen;
    }

    @NotNull
    public ObjectList<LocatedWidget> getHovering() {
        return this.hovering;
    }

    @Nullable
    public IWidget getTopHovering() {
        LocatedWidget lw = this.getTopHoveringLocated(false);
        return lw == null ? null : (IWidget)lw.getElement();
    }

    @Nullable
    public LocatedWidget getTopHoveringLocated(boolean debug) {
        ObjectListIterator objectListIterator = this.hovering.iterator();
        while (objectListIterator.hasNext()) {
            LocatedWidget widget = (LocatedWidget)objectListIterator.next();
            if (!debug && !((IWidget)widget.getElement()).canHover()) continue;
            return widget;
        }
        return null;
    }

    @Override
    public int getDefaultHeight() {
        return 166;
    }

    @Override
    public int getDefaultWidth() {
        return 176;
    }

    final void setPanelGuiContext(@NotNull ModularGuiContext context) {
        this.setContext(context);
        if (!context.getScreen().isOverlay()) {
            context.getNEISettings().addNEIExclusionArea(this);
        }
    }

    public boolean isOpening() {
        return this.animator != null && this.animator.isRunningForwards();
    }

    public boolean isClosing() {
        return this.animator != null && this.animator.isRunningBackwards();
    }

    public float getScale() {
        return this.scale;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public final boolean isMainPanel() {
        return this.getScreen().getMainPanel() == this;
    }

    @Override
    @ApiStatus.Internal
    public void setSyncHandler(@Nullable SyncHandler syncHandler) {
        if (!this.isValidSyncHandler(syncHandler)) {
            throw new IllegalStateException("Panel SyncHandler's must implement IPanelHandler!");
        }
        super.setSyncHandler(syncHandler);
        this.setPanelHandler((IPanelHandler)((Object)syncHandler));
    }

    @NotNull
    protected Animator getAnimator() {
        if (this.animator == null) {
            this.animator = new Animator(this.getScreen().getCurrentTheme().getOpenCloseAnimationOverride(), Interpolation.QUINT_OUT).setValueBounds(0.0f, 1.0f).setCallback(val -> {
                this.alpha = (float)val;
                this.scale = (float)val * 0.25f + 0.75f;
            });
        }
        return this.animator;
    }

    public boolean shouldAnimate() {
        return !this.getScreen().isOverlay() && this.getScreen().getCurrentTheme().getOpenCloseAnimationOverride() > 0;
    }

    void registerSubPanel(IPanelHandler handler) {
        if (!this.clientSubPanels.contains(handler)) {
            this.clientSubPanels.add(handler);
        }
    }

    void closeClientSubPanels() {
        for (IPanelHandler handler : this.clientSubPanels) {
            if (!handler.isSubPanel()) continue;
            handler.closePanel();
        }
    }

    public ModularPanel bindPlayerInventory() {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory());
    }

    public ModularPanel bindPlayerInventory(int bottom) {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory(bottom));
    }

    public ModularPanel invisible() {
        this.invisible = true;
        return (ModularPanel)this.background(IDrawable.EMPTY);
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.getName();
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        IDLE,
        OPEN,
        CLOSED,
        DISPOSED,
        WAIT_DISPOSING;

    }

    private static class Input {
        private final ObjectList<Interactable> acceptedInteractions = ObjectList.create();
        @Nullable
        private LocatedWidget lastPressed;
        private boolean held;
        private long timeHeld;
        private int lastButton;

        private Input() {
            this.reset();
        }

        private void addAcceptedInteractable(Interactable interactable) {
            this.acceptedInteractions.add(interactable);
        }

        private void reset() {
            this.acceptedInteractions.clear();
            this.held = false;
            this.timeHeld = -1L;
            this.lastButton = -1;
        }

        private boolean tryTap(int button) {
            return this.lastButton == button && Minecraft.func_71386_F() - this.timeHeld <= 200L;
        }
    }
}

