/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.inventory.ClickType;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerCustomizer {
    private static final int DROP_TO_WORLD = -999;
    private static final int LEFT_MOUSE = 0;
    private static final int RIGHT_MOUSE = 1;
    private ModularContainer container;
    private Predicate<EntityPlayer> canInteractWith;

    void initialize(ModularContainer container) {
        this.container = container;
    }

    public ModularContainer getContainer() {
        if (this.container == null) {
            throw new NullPointerException("ContainerCustomizer is not registered!");
        }
        return this.container;
    }

    public Predicate<EntityPlayer> getCanInteractWith() {
        return this.canInteractWith;
    }

    public void setCanInteractWith(Predicate<EntityPlayer> canInteractWith) {
        this.canInteractWith = canInteractWith;
    }

    public void onContainerClosed() {
    }

    @Nullable
    public ItemStack slotClick(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnable = null;
        InventoryPlayer inventoryplayer = player.field_71071_by;
        if (clickTypeIn == ClickType.QUICK_CRAFT || this.container.acc().getDragEvent() != 0) {
            return this.container.superSlotClick(slotId, mouseButton, clickTypeIn, player);
        }
        if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                if (inventoryplayer.func_70445_o() != null) {
                    if (mouseButton == 0) {
                        player.func_71019_a(inventoryplayer.func_70445_o(), true);
                        inventoryplayer.func_70437_b(null);
                    }
                    if (mouseButton == 1) {
                        player.func_71019_a(inventoryplayer.func_70445_o().func_77979_a(1), true);
                        if (inventoryplayer.func_70445_o().field_77994_a == 0) {
                            inventoryplayer.func_70437_b(null);
                        }
                    }
                }
                return inventoryplayer.func_70445_o();
            }
            if (clickTypeIn == ClickType.QUICK_MOVE) {
                ItemStack transferredStack;
                if (slotId < 0) {
                    return null;
                }
                Slot fromSlot = this.container.func_75139_a(slotId);
                if (fromSlot != null && fromSlot.func_82869_a(player) && (transferredStack = this.transferStackInSlot(player, slotId)) != null) {
                    Item item = transferredStack.func_77973_b();
                    returnable = transferredStack.func_77946_l();
                    if (fromSlot.func_75211_c() != null && fromSlot.func_75211_c().func_77973_b() == item) {
                        this.slotClick(slotId, mouseButton, ClickType.QUICK_MOVE, player);
                    }
                }
            } else {
                if (slotId < 0) {
                    return null;
                }
                Slot clickedSlot = this.container.func_75139_a(slotId);
                if (clickedSlot != null) {
                    ItemStack slotStack = clickedSlot.func_75211_c();
                    ItemStack heldStack = inventoryplayer.func_70445_o();
                    if (slotStack == null) {
                        if (heldStack != null && clickedSlot.func_75214_a(heldStack)) {
                            int stackCount;
                            int n = stackCount = mouseButton == 0 ? heldStack.field_77994_a : 1;
                            if (stackCount > clickedSlot.func_75219_a()) {
                                stackCount = clickedSlot.func_75219_a();
                            }
                            clickedSlot.func_75215_d(heldStack.func_77979_a(stackCount));
                            if (heldStack.field_77994_a == 0) {
                                inventoryplayer.func_70437_b(null);
                            }
                        }
                    } else if (clickedSlot.func_82869_a(player)) {
                        int stackCount;
                        if (heldStack == null) {
                            int s = Math.min(slotStack.field_77994_a, slotStack.func_77976_d());
                            int toRemove = mouseButton == 0 ? s : (s + 1) / 2;
                            inventoryplayer.func_70437_b(slotStack.func_77979_a(toRemove));
                            if (slotStack.field_77994_a == 0) {
                                slotStack = null;
                            }
                            clickedSlot.func_75215_d(slotStack);
                            clickedSlot.func_82870_a(player, inventoryplayer.func_70445_o());
                        } else if (clickedSlot.func_75214_a(heldStack)) {
                            if (slotStack.func_77973_b() == heldStack.func_77973_b() && slotStack.func_77960_j() == heldStack.func_77960_j() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack)) {
                                int stackCount2;
                                int n = stackCount2 = mouseButton == 0 ? heldStack.field_77994_a : 1;
                                if (stackCount2 > clickedSlot.func_75219_a() - slotStack.field_77994_a) {
                                    stackCount2 = clickedSlot.func_75219_a() - slotStack.field_77994_a;
                                }
                                heldStack.func_77979_a(stackCount2);
                                if (heldStack.field_77994_a == 0) {
                                    inventoryplayer.func_70437_b(null);
                                }
                                slotStack.field_77994_a += stackCount2;
                                clickedSlot.func_75215_d(slotStack);
                            } else if (heldStack.field_77994_a <= clickedSlot.func_75219_a()) {
                                clickedSlot.func_75215_d(heldStack);
                                inventoryplayer.func_70437_b(slotStack);
                            }
                        } else if (slotStack.func_77973_b() == heldStack.func_77973_b() && heldStack.func_77976_d() > 1 && (!slotStack.func_77981_g() || slotStack.func_77960_j() == heldStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack) && (stackCount = slotStack.field_77994_a) > 0 && stackCount + heldStack.field_77994_a <= heldStack.func_77976_d()) {
                            heldStack.field_77994_a += stackCount;
                            slotStack = clickedSlot.func_75209_a(stackCount);
                            if (slotStack.field_77994_a == 0) {
                                clickedSlot.func_75215_d(null);
                            }
                            clickedSlot.func_82870_a(player, inventoryplayer.func_70445_o());
                        }
                    }
                    clickedSlot.func_75218_e();
                }
            }
            this.container.func_75142_b();
            return returnable;
        }
        if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0) {
            Slot slot = (Slot)this.container.field_75151_b.get(slotId);
            ItemStack itemstack1 = inventoryplayer.func_70445_o();
            if (!(itemstack1 == null || slot != null && slot.func_75216_d() && slot.func_82869_a(player))) {
                int i = mouseButton == 0 ? 0 : this.container.field_75151_b.size() - 1;
                int j = mouseButton == 0 ? 1 : -1;
                for (int k = 0; k < 2; ++k) {
                    for (int l = i; l >= 0 && l < this.container.field_75151_b.size() && itemstack1.field_77994_a < itemstack1.func_77976_d(); l += j) {
                        ModularSlot modularSlot;
                        Slot slot1 = (Slot)this.container.field_75151_b.get(l);
                        if (slot1 instanceof ModularSlot && (modularSlot = (ModularSlot)slot1).isPhantom() || !slot1.func_75216_d() || !Container.func_94527_a((Slot)slot1, (ItemStack)itemstack1, (boolean)true) || !slot1.func_82869_a(player) || !this.canMergeSlot(itemstack1, slot1)) continue;
                        ItemStack itemstack2 = slot1.func_75211_c();
                        if (k == 0 && itemstack2.field_77994_a == itemstack2.func_77976_d()) continue;
                        int i1 = Math.min(itemstack1.func_77976_d() - itemstack1.field_77994_a, itemstack2.field_77994_a);
                        ItemStack itemstack3 = slot1.func_75209_a(i1);
                        itemstack1.field_77994_a += i1;
                        if (itemstack3 == null || itemstack3.field_77994_a <= 0) {
                            slot1.func_75215_d(null);
                        }
                        slot1.func_82870_a(player, itemstack3);
                    }
                }
            }
            this.container.func_75142_b();
            return returnable;
        }
        if (clickTypeIn == ClickType.SWAP && mouseButton >= 0 && mouseButton < 9) {
            ModularSlot phantom = this.container.getModularSlot(slotId);
            ItemStack hotbarStack = inventoryplayer.func_70301_a(mouseButton);
            if (phantom.isPhantom()) {
                phantom.func_75215_d(hotbarStack == null ? null : hotbarStack.func_77946_l());
                this.container.func_75142_b();
                return returnable;
            }
        }
        return this.container.superSlotClick(slotId, mouseButton, clickTypeIn, player);
    }

    @Nullable
    public ItemStack transferStackInSlot(@NotNull EntityPlayer playerIn, int index) {
        ItemStack stack;
        ModularSlot slot = this.container.getModularSlot(index);
        if (!slot.isPhantom() && (stack = slot.func_75211_c()) != null) {
            stack = stack.func_77946_l();
            int base = 0;
            if (stack.field_77994_a > stack.func_77976_d()) {
                base = stack.field_77994_a - stack.func_77976_d();
                stack.field_77994_a = stack.func_77976_d();
            }
            ItemStack remainder = this.transferItem(slot, stack.func_77946_l());
            if (base == 0 && remainder == null || remainder.field_77994_a < 1) {
                stack = null;
            } else {
                stack.field_77994_a = base + remainder.field_77994_a;
            }
            slot.func_75215_d(stack);
            return null;
        }
        return null;
    }

    protected ItemStack transferItem(ModularSlot fromSlot, ItemStack fromStack) {
        @Nullable SlotGroup fromSlotGroup = fromSlot.getSlotGroup();
        for (ModularSlot toSlot : this.container.getShiftClickSlots()) {
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            ItemStack toStack = toSlot.func_75211_c();
            if (toSlot.isPhantom()) {
                if (toStack != null && (!ItemHandlerHelper.canItemStacksStack(fromStack, toStack) || toStack.field_77994_a >= toSlot.getItemStackLimit(toStack))) continue;
                toSlot.func_75215_d(fromStack.func_77946_l());
                return fromStack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(fromStack, toStack)) continue;
            int j = toStack.field_77994_a + fromStack.field_77994_a;
            int maxSize = toSlot.getItemStackLimit(fromStack);
            if (j <= maxSize) {
                fromStack.field_77994_a = 0;
                toStack.field_77994_a = j;
                toSlot.func_75218_e();
            } else if (toStack.field_77994_a < maxSize) {
                fromStack.field_77994_a -= maxSize - toStack.field_77994_a;
                toStack.field_77994_a = maxSize;
                toSlot.func_75218_e();
            }
            if (fromStack.field_77994_a >= 1) continue;
            return fromStack;
        }
        for (ModularSlot emptySlot : this.container.getShiftClickSlots()) {
            ItemStack itemstack = emptySlot.func_75211_c();
            SlotGroup slotGroup = Objects.requireNonNull(emptySlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !emptySlot.func_111238_b() || itemstack != null || !emptySlot.func_75214_a(fromStack)) continue;
            if (fromStack.field_77994_a > emptySlot.getItemStackLimit(fromStack)) {
                emptySlot.func_75215_d(fromStack.func_77979_a(emptySlot.getItemStackLimit(fromStack)));
            } else {
                emptySlot.func_75215_d(fromStack.func_77979_a(fromStack.field_77994_a));
            }
            if (fromStack.field_77994_a >= 1) continue;
            break;
        }
        return fromStack;
    }

    public boolean canMergeSlot(ItemStack stack, Slot slotIn) {
        return this.container.superCanMergeSlot(stack, slotIn);
    }

    protected boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.container.superMergeItemStack(stack, startIndex, endIndex, reverseDirection);
    }
}

