/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.NEISettings;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkHandler;
import com.cleanroommc.modularui.network.packets.OpenGuiPacket;
import com.cleanroommc.modularui.screen.ContainerCustomizer;
import com.cleanroommc.modularui.screen.GuiContainerWrapper;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEISettingsImpl;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.WidgetTree;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class GuiManager {
    private static final Object2ObjectMap<String, UIFactory<?>> FACTORIES = new Object2ObjectOpenHashMap(16);
    private static IMuiScreen lastMui;
    private static final List<EntityPlayer> openedContainers;

    public static void registerFactory(UIFactory<?> factory) {
        Objects.requireNonNull(factory);
        String name = Objects.requireNonNull(factory.getFactoryName());
        if (name.length() > 32) {
            throw new IllegalArgumentException("The factory name length must not exceed 32!");
        }
        if (FACTORIES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Factory with name '" + name + "' is already registered!");
        }
        FACTORIES.put((Object)name, factory);
    }

    @NotNull
    public static UIFactory<?> getFactory(String name) {
        UIFactory factory = (UIFactory)FACTORIES.get((Object)name);
        if (factory == null) {
            throw new NoSuchElementException();
        }
        return factory;
    }

    public static boolean hasFactory(String name) {
        return FACTORIES.containsKey((Object)name);
    }

    public static <T extends GuiData> void open(@NotNull UIFactory<T> factory, @NotNull T guiData, EntityPlayerMP player) {
        if (player instanceof FakePlayer || openedContainers.contains(player)) {
            return;
        }
        openedContainers.add((EntityPlayer)player);
        guiData.setNEISettings(NEISettings.DUMMY);
        PanelSyncManager syncManager = new PanelSyncManager();
        ModularPanel panel = factory.createPanel(guiData, syncManager);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularContainer container = new ModularContainer((EntityPlayer)player, syncManager, panel.getName(), guiData);
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        factory.writeGuiData(guiData, buffer);
        NetworkHandler.sendToPlayer(new OpenGuiPacket<T>(windowId, factory, buffer), player);
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends GuiData> void open(int windowId, @NotNull UIFactory<T> factory, @NotNull PacketBuffer data, @NotNull EntityPlayerSP player) {
        T guiData = factory.readGuiData((EntityPlayer)player, data);
        NEISettingsImpl neiSettings = new NEISettingsImpl();
        ((GuiData)guiData).setNEISettings(neiSettings);
        PanelSyncManager syncManager = new PanelSyncManager();
        ModularPanel panel = factory.createPanel(guiData, syncManager);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularScreen screen = factory.createScreen(guiData, panel);
        screen.getContext().setNEISettings(neiSettings);
        ModularContainer container = new ModularContainer((EntityPlayer)player, syncManager, panel.getName(), (GuiData)guiData);
        IMuiScreen wrapper = factory.createScreenWrapper(container, screen);
        GuiScreen guiScreen = wrapper.getGuiScreen();
        if (!(guiScreen instanceof GuiContainer)) {
            throw new IllegalStateException("The wrapping screen must be a GuiContainer for synced GUIs!");
        }
        GuiContainer guiContainer = (GuiContainer)guiScreen;
        if (guiContainer.field_147002_h != container) {
            throw new IllegalStateException("Custom Containers are not yet allowed!");
        }
        guiContainer.field_147002_h.field_75152_c = windowId;
        MCHelper.displayScreen(wrapper.getGuiScreen());
        player.field_71070_bA = guiContainer.field_147002_h;
        syncManager.onOpen();
    }

    @SideOnly(value=Side.CLIENT)
    static void openScreen(ModularScreen screen, NEISettingsImpl neiSettings, ContainerCustomizer containerCustomizer) {
        screen.getContext().setNEISettings(neiSettings);
        IMuiScreen guiScreen = containerCustomizer == null ? new GuiScreenWrapper(screen) : new GuiContainerWrapper(new ModularContainer(containerCustomizer), screen);
        MCHelper.displayScreen(guiScreen);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            openedContainers.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (lastMui != null && event.gui == null) {
            if (lastMui.getScreen().getPanelManager().isOpen()) {
                lastMui.getScreen().getPanelManager().closeAll();
            }
            lastMui.getScreen().getPanelManager().dispose();
            lastMui = null;
        } else {
            GuiScreen guiScreen = event.gui;
            if (guiScreen instanceof IMuiScreen) {
                IMuiScreen screenWrapper = (IMuiScreen)guiScreen;
                if (lastMui == null) {
                    lastMui = screenWrapper;
                } else if (lastMui == event.gui) {
                    lastMui.getScreen().getPanelManager().reopen();
                } else {
                    if (lastMui.getScreen().getPanelManager().isOpen()) {
                        lastMui.getScreen().getPanelManager().closeAll();
                    }
                    lastMui.getScreen().getPanelManager().dispose();
                    lastMui = screenWrapper;
                }
            }
        }
    }

    static {
        openedContainers = new ArrayList<EntityPlayer>(4);
    }
}

