/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.drawable.text.AnimatedText;
import com.cleanroommc.modularui.drawable.text.CompoundKey;
import com.cleanroommc.modularui.drawable.text.DynamicKey;
import com.cleanroommc.modularui.drawable.text.FormattingState;
import com.cleanroommc.modularui.drawable.text.KeyIcon;
import com.cleanroommc.modularui.drawable.text.LangKey;
import com.cleanroommc.modularui.drawable.text.StringKey;
import com.cleanroommc.modularui.drawable.text.StyledText;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Supplier;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IKey
extends IDrawable {
    public static final int TEXT_COLOR = -12566464;
    public static final TextRenderer renderer = new TextRenderer();
    public static final IKey EMPTY = IKey.str("");
    public static final IKey LINE_FEED = IKey.str("\n");
    public static final IKey SPACE = IKey.str(" ");
    public static final EnumChatFormatting BLACK = EnumChatFormatting.BLACK;
    public static final EnumChatFormatting DARK_BLUE = EnumChatFormatting.DARK_BLUE;
    public static final EnumChatFormatting DARK_GREEN = EnumChatFormatting.DARK_GREEN;
    public static final EnumChatFormatting DARK_AQUA = EnumChatFormatting.DARK_AQUA;
    public static final EnumChatFormatting DARK_RED = EnumChatFormatting.DARK_RED;
    public static final EnumChatFormatting DARK_PURPLE = EnumChatFormatting.DARK_PURPLE;
    public static final EnumChatFormatting GOLD = EnumChatFormatting.GOLD;
    public static final EnumChatFormatting GRAY = EnumChatFormatting.GRAY;
    public static final EnumChatFormatting DARK_GRAY = EnumChatFormatting.DARK_GRAY;
    public static final EnumChatFormatting BLUE = EnumChatFormatting.BLUE;
    public static final EnumChatFormatting GREEN = EnumChatFormatting.GREEN;
    public static final EnumChatFormatting AQUA = EnumChatFormatting.AQUA;
    public static final EnumChatFormatting RED = EnumChatFormatting.RED;
    public static final EnumChatFormatting LIGHT_PURPLE = EnumChatFormatting.LIGHT_PURPLE;
    public static final EnumChatFormatting YELLOW = EnumChatFormatting.YELLOW;
    public static final EnumChatFormatting WHITE = EnumChatFormatting.WHITE;
    public static final EnumChatFormatting OBFUSCATED = EnumChatFormatting.OBFUSCATED;
    public static final EnumChatFormatting BOLD = EnumChatFormatting.BOLD;
    public static final EnumChatFormatting STRIKETHROUGH = EnumChatFormatting.STRIKETHROUGH;
    public static final EnumChatFormatting UNDERLINE = EnumChatFormatting.UNDERLINE;
    public static final EnumChatFormatting ITALIC = EnumChatFormatting.ITALIC;
    public static final EnumChatFormatting RESET = EnumChatFormatting.RESET;

    public static IKey lang(@NotNull String key) {
        return new LangKey(key);
    }

    public static IKey lang(@NotNull String key, Object ... args) {
        return new LangKey(key, args);
    }

    public static IKey lang(@NotNull String key, @NotNull Supplier<Object[]> argsSupplier) {
        return new LangKey(key, argsSupplier);
    }

    public static IKey lang(@NotNull Supplier<String> keySupplier) {
        return new LangKey(keySupplier);
    }

    public static IKey lang(@NotNull Supplier<String> keySupplier, @NotNull Supplier<Object[]> argsSupplier) {
        return new LangKey(keySupplier, argsSupplier);
    }

    public static IKey str(@NotNull String key) {
        return new StringKey(key);
    }

    public static IKey str(@NotNull String key, Object ... args) {
        return new StringKey(key, args);
    }

    @Deprecated
    public static IKey format(@NotNull String key, Object ... args) {
        return IKey.str(key, args);
    }

    public static IKey comp(IKey ... keys) {
        return new CompoundKey(keys);
    }

    public static IKey dynamic(@NotNull @NotNull Supplier<@NotNull String> getter) {
        return new DynamicKey(getter);
    }

    public String get();

    default public String getFormatted(@Nullable FormattingState parentFormatting) {
        return this.get();
    }

    default public String getFormatted() {
        return this.getFormatted(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        renderer.setColor(widgetTheme.getTextColor());
        renderer.setShadow(widgetTheme.getTextShadow());
        renderer.setAlignment(Alignment.Center, width, height);
        renderer.setScale(1.0f);
        renderer.setPos(x, y);
        renderer.draw(this.getFormatted());
    }

    default public TextWidget asWidget() {
        return new TextWidget(this);
    }

    default public StyledText withStyle() {
        return new StyledText(this);
    }

    default public AnimatedText withAnimation() {
        return new AnimatedText(this);
    }

    @Nullable
    default public FormattingState getFormatting() {
        return null;
    }

    public IKey style(@Nullable EnumChatFormatting var1);

    default public IKey style(EnumChatFormatting ... formatting) {
        for (EnumChatFormatting tf : formatting) {
            this.style(tf);
        }
        return this;
    }

    default public IKey removeFormatColor() {
        return this.style((EnumChatFormatting)null);
    }

    public IKey removeStyle();

    default public StyledText alignment(Alignment alignment) {
        return this.withStyle().alignment(alignment);
    }

    default public StyledText color(@Nullable Integer color) {
        return this.withStyle().color(color);
    }

    default public StyledText scale(float scale) {
        return this.withStyle().scale(scale);
    }

    default public StyledText shadow(@Nullable Boolean shadow) {
        return this.withStyle().shadow(shadow);
    }

    @Override
    default public Icon asIcon() {
        return new Icon(this);
    }

    default public KeyIcon asTextIcon() {
        return new KeyIcon(this);
    }

    @Override
    default public void loadFromJson(JsonObject json) {
        if (json.has("color") || json.has("shadow") || json.has("align") || json.has("alignment") || json.has("scale")) {
            StyledText styledText1;
            StyledText styledText;
            IKey iKey = this;
            StyledText styledText2 = styledText = iKey instanceof StyledText ? (styledText1 = (StyledText)iKey) : this.withStyle();
            if (json.has("color")) {
                styledText.color(JsonHelper.getInt(json, 0, "color"));
            }
            styledText.shadow(JsonHelper.getBoolean(json, false, "shadow"));
            styledText.alignment(JsonHelper.deserialize(json, Alignment.class, styledText.getAlignment(), "align", "alignment"));
            styledText.scale(JsonHelper.getFloat(json, 1.0f, "scale"));
        }
    }
}

