/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.playerProperties;

import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.network.SyncPropertiesPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class BackpackProperty
implements IExtendedEntityProperties {
    private static final String PROPERTY_NAME = "abp.property";
    private EntityPlayer player;
    private ItemStack wearable = null;
    private ChunkCoordinates campFire = null;
    private boolean forceCampFire = false;
    private int dimension = 0;
    private boolean isWakingUpInPortableBag = false;

    public void setWakingUpInPortableBag(boolean b) {
        this.isWakingUpInPortableBag = b;
    }

    public boolean isWakingUpInPortableBag() {
        return this.isWakingUpInPortableBag;
    }

    public static void sync(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            BackpackProperty.syncToNear((EntityPlayerMP)player);
        }
    }

    private static void syncToNear(EntityPlayerMP player) {
        try {
            player.func_71121_q().func_73039_n().func_151248_b((Entity)player, ModNetwork.net.getPacketFrom((IMessage)new SyncPropertiesPacket.Message(player.func_145782_y(), BackpackProperty.get((EntityPlayer)player).getData())));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BackpackProperty(EntityPlayer player) {
        this.player = player;
    }

    public NBTTagCompound getData() {
        NBTTagCompound data = new NBTTagCompound();
        this.saveNBTData(data);
        return data;
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(PROPERTY_NAME, (IExtendedEntityProperties)new BackpackProperty(player));
    }

    public static BackpackProperty get(EntityPlayer player) {
        return (BackpackProperty)player.getExtendedProperties(PROPERTY_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (this.wearable != null) {
            compound.func_74782_a("wearable", (NBTBase)this.wearable.func_77955_b(new NBTTagCompound()));
        }
        if (this.campFire != null) {
            compound.func_74768_a("campFireX", this.campFire.field_71574_a);
            compound.func_74768_a("campFireY", this.campFire.field_71572_b);
            compound.func_74768_a("campFireZ", this.campFire.field_71573_c);
            compound.func_74768_a("campFireDim", this.dimension);
        }
        compound.func_74757_a("forceCampFire", this.forceCampFire);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound != null) {
            this.setWearable(compound.func_74764_b("wearable") ? ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("wearable")) : null);
            this.setCampFire(new ChunkCoordinates(compound.func_74762_e("campFireX"), compound.func_74762_e("campFireY"), compound.func_74762_e("campFireZ")));
            this.dimension = compound.func_74762_e("campFireDim");
            this.forceCampFire = compound.func_74767_n("forceCampFire");
        }
    }

    public void init(Entity entity, World world) {
        this.player = (EntityPlayer)entity;
    }

    public void setWearable(ItemStack bp) {
        this.wearable = bp;
    }

    public ItemStack getWearable() {
        return this.wearable;
    }

    public void setCampFire(ChunkCoordinates cf) {
        this.campFire = cf;
    }

    public ChunkCoordinates getCampFire() {
        return this.campFire;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean isForcedCampFire() {
        return this.forceCampFire;
    }

    public void setForceCampFire(boolean forceCampFire) {
        this.forceCampFire = forceCampFire;
    }

    public void executeWearableUpdateProtocol() {
        if (this.wearable.func_77973_b() instanceof IBackWearableItem) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onEquippedUpdate(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }

    public void executeWearableEquipProtocol() {
        if (this.wearable.func_77973_b() instanceof IBackWearableItem) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onEquipped(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }

    public void executeWearableUnequipProtocol() {
        if (this.wearable.func_77973_b() instanceof IBackWearableItem) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onUnequipped(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }
}

