/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.network.handler.AbstractClientMessageHandler;
import gtPlusPlus.core.network.packet.PacketTurbineHatchUpdate;
import gtPlusPlus.core.network.packet.PacketVolumetricFlaskGui;
import gtPlusPlus.core.network.packet.PacketVolumetricFlaskGui2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketHandler {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel(Mods.GTPlusPlus.ID);

    public static void init() {
        PacketHandler.registerMessage(PacketVolumetricFlaskGui.class, PacketVolumetricFlaskGui.class);
        PacketHandler.registerMessage(PacketVolumetricFlaskGui2.class, PacketVolumetricFlaskGui2.class);
        PacketHandler.registerMessage(PacketTurbineHatchUpdate.class, PacketTurbineHatchUpdate.class);
    }

    private static void registerMessage(Class handlerClass, Class messageClass) {
        Side side = AbstractClientMessageHandler.class.isAssignableFrom(handlerClass) ? Side.CLIENT : Side.SERVER;
        PacketHandler.registerMessage(handlerClass, messageClass, side);
    }

    private static void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        INSTANCE.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        INSTANCE.sendTo(message, player);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        INSTANCE.sendToAllAround(message, point);
    }

    public static void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketHandler.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketHandler.sendToAllAround(message, player.field_70170_p.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        INSTANCE.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        INSTANCE.sendToServer(message);
    }
}

