/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import gregtech.api.enums.Materials;
import gregtech.api.util.GTRecipe;
import net.minecraftforge.fluids.FluidStack;

public class PurifiedWaterHelpers {
    public static Materials getPurifiedWaterTier(int tier) {
        Materials materials;
        switch (tier) {
            case 1: {
                materials = Materials.Grade1PurifiedWater;
                break;
            }
            case 2: {
                materials = Materials.Grade2PurifiedWater;
                break;
            }
            case 3: {
                materials = Materials.Grade3PurifiedWater;
                break;
            }
            case 4: {
                materials = Materials.Grade4PurifiedWater;
                break;
            }
            case 5: {
                materials = Materials.Grade5PurifiedWater;
                break;
            }
            case 6: {
                materials = Materials.Grade6PurifiedWater;
                break;
            }
            case 7: {
                materials = Materials.Grade7PurifiedWater;
                break;
            }
            case 8: {
                materials = Materials.Grade8PurifiedWater;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + tier);
            }
        }
        return materials;
    }

    public static int getWaterTier(FluidStack fluid) {
        if (fluid == null) {
            return 0;
        }
        if (fluid.isFluidEqual(Materials.Grade1PurifiedWater.getFluid(1000L))) {
            return 1;
        }
        if (fluid.isFluidEqual(Materials.Grade2PurifiedWater.getFluid(1000L))) {
            return 2;
        }
        if (fluid.isFluidEqual(Materials.Grade3PurifiedWater.getFluid(1000L))) {
            return 3;
        }
        if (fluid.isFluidEqual(Materials.Grade4PurifiedWater.getFluid(1000L))) {
            return 4;
        }
        if (fluid.isFluidEqual(Materials.Grade5PurifiedWater.getFluid(1000L))) {
            return 5;
        }
        if (fluid.isFluidEqual(Materials.Grade6PurifiedWater.getFluid(1000L))) {
            return 6;
        }
        if (fluid.isFluidEqual(Materials.Grade7PurifiedWater.getFluid(1000L))) {
            return 7;
        }
        if (fluid.isFluidEqual(Materials.Grade8PurifiedWater.getFluid(1000L))) {
            return 8;
        }
        return 0;
    }

    public static int getWaterTierFromRecipe(GTRecipe recipe) {
        if (recipe.mFluidInputs.length == 0) {
            return 0;
        }
        return PurifiedWaterHelpers.getWaterTier(recipe.mFluidInputs[0]);
    }
}

