/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneTransmitterBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class CoverWirelessDoesWorkDetector
extends CoverAdvancedRedstoneTransmitterBase<ActivityTransmitterData> {
    public CoverWirelessDoesWorkDetector(ITexture coverTexture) {
        super(ActivityTransmitterData.class, coverTexture);
    }

    @Override
    public ActivityTransmitterData createDataObject() {
        return new ActivityTransmitterData();
    }

    @Override
    public ActivityTransmitterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    private static byte computeSignalBasedOnActivity(ActivityTransmitterData coverVariable, ICoverable tileEntity) {
        if (tileEntity instanceof IMachineProgress) {
            IMachineProgress mProgress = (IMachineProgress)((Object)tileEntity);
            boolean inverted = coverVariable.invert;
            int signal = 0;
            switch (coverVariable.mode) {
                case MACHINE_ENABLED: {
                    signal = inverted == mProgress.isAllowedToWork() ? 0 : 15;
                    break;
                }
                case MACHINE_IDLE: {
                    signal = inverted == (mProgress.getMaxProgress() == 0) ? 0 : 15;
                    break;
                }
                case RECIPE_PROGRESS: {
                    int tScale = mProgress.getMaxProgress() / 15;
                    signal = tScale > 0 && mProgress.hasThingsToDo() ? (inverted ? 15 - mProgress.getProgress() / tScale : mProgress.getProgress() / tScale) : (inverted ? 15 : 0);
                }
            }
            return (byte)signal;
        }
        return 0;
    }

    @Override
    public ActivityTransmitterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ActivityTransmitterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = CoverWirelessDoesWorkDetector.computeSignalBasedOnActivity(aCoverVariable, aTileEntity);
        long hash = CoverWirelessDoesWorkDetector.hashCoverCoords(aTileEntity, side);
        CoverWirelessDoesWorkDetector.setSignalAt(aCoverVariable.getUuid(), aCoverVariable.getFrequency(), hash, signal);
        aTileEntity.setOutputRedstoneSignal(side, signal);
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, ActivityTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, ActivityTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRateImpl(ForgeDirection side, int aCoverID, ActivityTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new WirelessActivityDetectorUIFactory(buildContext).createWindow();
    }

    public static class ActivityTransmitterData
    extends CoverAdvancedRedstoneTransmitterBase.TransmitterData {
        private ActivityMode mode;

        public ActivityTransmitterData(int frequency, UUID uuid, boolean invert, ActivityMode mode) {
            super(frequency, uuid, invert);
            this.mode = mode;
        }

        public ActivityTransmitterData() {
            this.mode = ActivityMode.MACHINE_IDLE;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ActivityTransmitterData(this.frequency, this.uuid, this.invert, this.mode);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74768_a("mode", this.mode.ordinal());
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeInt(this.mode.ordinal());
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mode = ActivityMode.values()[tag.func_74762_e("mode")];
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.mode = ActivityMode.values()[aBuf.readInt()];
            return this;
        }
    }

    public static enum ActivityMode {
        RECIPE_PROGRESS,
        MACHINE_IDLE,
        MACHINE_ENABLED;

    }

    private class WirelessActivityDetectorUIFactory
    extends CoverAdvancedRedstoneTransmitterBase.AdvancedRedstoneTransmitterBaseUIFactory {
        public WirelessActivityDetectorUIFactory(CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected int getGUIHeight() {
            return 107;
        }

        @Override
        protected int getFrequencyRow() {
            return 0;
        }

        @Override
        protected int getButtonRow() {
            return 1;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            super.addUIWidgets(builder);
            builder.widget(TextWidget.dynamicString(() -> {
                ActivityMode mode = ((ActivityTransmitterData)this.getCoverData()).mode;
                if (mode == ActivityMode.MACHINE_ENABLED) {
                    return GTUtility.trans("271", "Machine enabled");
                }
                if (mode == ActivityMode.MACHINE_IDLE) {
                    return GTUtility.trans("242", "Machine idle");
                }
                return GTUtility.trans("241", "Recipe progress");
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 65));
        }

        protected void addUIForDataController(CoverDataControllerWidget<ActivityTransmitterData> controller) {
            super.addUIForDataController(controller);
            ((CoverDataControllerWidget)((CoverDataControllerWidget)controller.addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ActivityTransmitterData)coverData).mode == ActivityMode.RECIPE_PROGRESS, (coverData, state) -> {
                ((ActivityTransmitterData)coverData).mode = ActivityMode.RECIPE_PROGRESS;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_PROGRESS).addTooltip(GTUtility.trans("241", "Recipe progress")).setPos(0, 36))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ActivityTransmitterData)coverData).mode == ActivityMode.MACHINE_IDLE, (coverData, state) -> {
                ((ActivityTransmitterData)coverData).mode = ActivityMode.MACHINE_IDLE;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK).addTooltip(GTUtility.trans("242", "Machine idle")).setPos(18, 36))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ActivityTransmitterData)coverData).mode == ActivityMode.MACHINE_ENABLED, (coverData, state) -> {
                ((ActivityTransmitterData)coverData).mode = ActivityMode.MACHINE_ENABLED;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON).addTooltip(GTUtility.trans("271", "Machine enabled")).setPos(36, 36));
        }
    }
}

