/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.MetaGeneratedTool;
import net.minecraft.item.ItemStack;

public class TurbineStatCalculator {
    public MetaGeneratedTool turbine;
    public ItemStack item;
    public long tMaxDamage;
    public Materials tMaterial;
    public IToolStats tStats;

    public TurbineStatCalculator(MetaGeneratedTool turbineItem, ItemStack aStack) {
        this.turbine = turbineItem;
        this.item = aStack;
        this.tMaxDamage = MetaGeneratedTool.getToolMaxDamage(aStack);
        this.tMaterial = MetaGeneratedTool.getPrimaryMaterial(aStack);
        this.tStats = this.turbine.getToolStats(aStack);
    }

    public long getMaxDurability() {
        return this.tMaxDamage;
    }

    public long getCurrentDurability() {
        return this.getMaxDurability() - MetaGeneratedTool.getToolDamage(this.item);
    }

    public float getEfficiency() {
        return 0.5f + (0.5f + this.turbine.getToolCombatDamage(this.item)) * 0.1f;
    }

    public float getSteamEfficiency() {
        return this.getEfficiency();
    }

    public float getGasEfficiency() {
        return this.getEfficiency();
    }

    public float getPlasmaEfficiency() {
        return this.getEfficiency();
    }

    public float getLooseEfficiency() {
        return (float)((double)-0.2f + (double)Math.round(this.getEfficiency() * 85.0f) * 0.01);
    }

    public float getLooseSteamEfficiency() {
        return this.getLooseEfficiency() * 0.9f;
    }

    public float getLooseGasEfficiency() {
        return this.getLooseEfficiency() * 0.95f;
    }

    public float getLoosePlasmaEfficiency() {
        return this.getLooseEfficiency();
    }

    public float getOptimalFlow() {
        return this.tStats.getSpeedMultiplier() * this.tMaterial.mToolSpeed * 50.0f;
    }

    public float getOptimalSteamFlow() {
        return this.getOptimalFlow() * this.tMaterial.mSteamMultiplier;
    }

    public float getOptimalGasFlow() {
        return this.getOptimalFlow() * this.tMaterial.mGasMultiplier;
    }

    public float getOptimalPlasmaFlow() {
        return this.getOptimalFlow() * this.tMaterial.mPlasmaMultiplier * 42.0f;
    }

    public float getOptimalLooseSteamFlow() {
        return 3.0f * this.getOptimalSteamFlow() * (float)Math.pow(1.1f, (this.getEfficiency() - 0.8f) * 20.0f);
    }

    public float getOptimalLooseGasFlow() {
        return 2.0f * this.getOptimalGasFlow() * (float)Math.pow(1.05f, (this.getEfficiency() - 0.8f) * 20.0f);
    }

    public float getOptimalLoosePlasmaFlow() {
        return 2.0f * this.getOptimalPlasmaFlow() * (float)Math.pow(1.03f, (this.getEfficiency() - 0.8f) * 20.0f);
    }

    public float getOptimalSteamEUt() {
        return this.getOptimalSteamFlow() * this.getSteamEfficiency() * 0.5f;
    }

    public float getOptimalGasEUt() {
        return this.getOptimalGasFlow() * this.getGasEfficiency();
    }

    public float getOptimalPlasmaEUt() {
        return this.getOptimalPlasmaFlow() * this.getPlasmaEfficiency();
    }

    public float getOptimalLooseSteamEUt() {
        return this.getOptimalLooseSteamFlow() * this.getLooseSteamEfficiency() * 0.5f;
    }

    public float getOptimalLooseGasEUt() {
        return this.getOptimalLooseGasFlow() * this.getLooseGasEfficiency();
    }

    public float getOptimalLoosePlasmaEUt() {
        return this.getOptimalLoosePlasmaFlow() * this.getLoosePlasmaEfficiency();
    }

    public int getOverflowEfficiency() {
        return (int)(1.0 + Math.min(2.0, (double)(this.tMaterial.mToolQuality / 3)));
    }
}

