/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.util.GTUtility;
import gregtech.api.util.item.ItemHolder;
import it.unimi.dsi.fastutil.Hash;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GTItemStack
extends ItemHolder {
    public static final Hash.Strategy<ItemStack> ITEMSTACK_HASH_STRATEGY2 = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return o.func_77973_b().hashCode() * 38197 + Items.field_151008_G.getDamage(o);
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.func_77973_b() == b.func_77973_b() && Items.field_151008_G.getDamage(a) == Items.field_151008_G.getDamage(b);
        }
    };
    public final Item mItem;
    public final byte mStackSize;
    public final short mMetaData;

    public GTItemStack(Item aItem, long aStackSize, long aMetaData) {
        super(new ItemStack(aItem, 1, (int)aMetaData));
        this.mItem = aItem;
        this.mStackSize = (byte)aStackSize;
        this.mMetaData = (short)aMetaData;
    }

    public GTItemStack(ItemStack aStack) {
        this(aStack, false);
    }

    public GTItemStack(ItemStack aStack, boolean wildcard) {
        this(aStack == null ? null : aStack.func_77973_b(), aStack == null ? 0L : (long)aStack.field_77994_a, aStack == null ? 0L : (wildcard ? 32767L : (long)Items.field_151008_G.getDamage(aStack)));
    }

    public GTItemStack(int aHashCode) {
        this(GTUtility.intToStack(aHashCode));
    }

    public final ItemStack toStack() {
        if (this.mItem == null) {
            return null;
        }
        return new ItemStack(this.mItem, 1, (int)this.mMetaData);
    }

    public final boolean isStackEqual(ItemStack aStack) {
        return GTUtility.areStacksEqual(this.toStack(), aStack);
    }

    public final boolean isStackEqual(GTItemStack aStack) {
        return GTUtility.areStacksEqual(this.toStack(), aStack.toStack());
    }

    @Override
    public boolean equals(Object aStack) {
        if (aStack == this) {
            return true;
        }
        if (aStack instanceof GTItemStack) {
            return ((GTItemStack)aStack).mItem == this.mItem && ((GTItemStack)aStack).mMetaData == this.mMetaData;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return GTUtility.stackToInt(this.toStack());
    }

    public static ItemStack internalCopyStack(ItemStack aStack) {
        return GTItemStack.internalCopyStack(aStack, false);
    }

    public static ItemStack internalCopyStack(ItemStack aStack, boolean wildcard) {
        return new ItemStack(aStack.func_77973_b(), 1, wildcard ? Short.MAX_VALUE : Items.field_151008_G.getDamage(aStack));
    }
}

