/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material;

import bartworks.API.IRadMaterial;
import bartworks.API.SideReference;
import bartworks.client.textures.PrefixTextureLinker;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import ic2.core.IC2Potion;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BWMetaGeneratedItems
extends MetaGeneratedItem
implements IRadMaterial {
    public static final CreativeTabs metaTab = new CreativeTabs("bartworksMetaMaterials"){

        public Item func_78016_d() {
            return new ItemStack(Blocks.field_150366_p).func_77973_b();
        }
    };
    protected final OrePrefixes orePrefixes;
    protected final String itemTypeLocalizedName;

    public BWMetaGeneratedItems(OrePrefixes orePrefixes, Object unused) {
        super("bwMetaGeneratedGTEnhancement" + orePrefixes.name(), (short)32766, (short)0);
        this.orePrefixes = orePrefixes;
        this.itemTypeLocalizedName = GTLanguageManager.addStringLocalization("bw.itemtype." + (Object)((Object)orePrefixes), orePrefixes.mLocalizedMaterialPre + "%material" + orePrefixes.mLocalizedMaterialPost);
    }

    public BWMetaGeneratedItems(OrePrefixes orePrefixes) {
        super("bwMetaGenerated" + orePrefixes.name(), (short)32766, (short)0);
        this.orePrefixes = orePrefixes;
        this.itemTypeLocalizedName = GTLanguageManager.addStringLocalization("bw.itemtype." + (Object)((Object)orePrefixes), orePrefixes.mLocalizedMaterialPre + "%material" + orePrefixes.mLocalizedMaterialPost);
        this.func_77637_a(metaTab);
        for (Werkstoff w : Werkstoff.werkstoffHashSet) {
            ItemStack tStack = new ItemStack((Item)this, 1, (int)w.getmID());
            if (!w.hasItemType(this.orePrefixes)) continue;
            GTOreDictUnificator.registerOre(this.orePrefixes.name() + w.getVarName(), tStack);
        }
    }

    public boolean onEntityItemUpdate(EntityItem aItemEntity) {
        Werkstoff aMaterial;
        int aDamage;
        if (!(this.orePrefixes != OrePrefixes.dustImpure && this.orePrefixes != OrePrefixes.dustPure && this.orePrefixes != OrePrefixes.crushed || (aDamage = aItemEntity.func_92059_d().func_77960_j()) < 0 || aItemEntity.field_70170_p.field_72995_K || (aMaterial = Werkstoff.werkstoffHashMap.get((short)aDamage)) == null || aMaterial == Werkstoff.default_null_Werkstoff)) {
            int tX = MathHelper.func_76128_c((double)aItemEntity.field_70165_t);
            int tY = MathHelper.func_76128_c((double)aItemEntity.field_70163_u);
            int tZ = MathHelper.func_76128_c((double)aItemEntity.field_70161_v);
            Block tBlock = aItemEntity.field_70170_p.func_147439_a(tX, tY, tZ);
            byte tMetaData = (byte)aItemEntity.field_70170_p.func_72805_g(tX, tY, tZ);
            if (tBlock == Blocks.field_150383_bp && tMetaData > 0) {
                if (this.orePrefixes == OrePrefixes.dustImpure || this.orePrefixes == OrePrefixes.dustPure) {
                    aItemEntity.func_92058_a(WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dust, aMaterial, aItemEntity.func_92059_d().field_77994_a));
                } else {
                    aItemEntity.func_92058_a(WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.crushedPurified, aMaterial, aItemEntity.func_92059_d().field_77994_a));
                }
                aItemEntity.field_70170_p.func_72921_c(tX, tY, tZ, tMetaData - 1, 3);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        String tooltip;
        Werkstoff werkstoff;
        if (this.orePrefixes == OrePrefixes.dustImpure || this.orePrefixes == OrePrefixes.dustPure) {
            aList.add(GTLanguageManager.getTranslation("metaitem.01.tooltip.purify"));
        }
        if (this.orePrefixes == OrePrefixes.crushed) {
            aList.add(GTLanguageManager.getTranslation("metaitem.01.tooltip.purify.2"));
        }
        if (aStack != null && aStack.func_77973_b() instanceof BWMetaGeneratedItems && aStack.func_77960_j() == WerkstoffLoader.Tiberium.getmID()) {
            aList.add(GTLanguageManager.getTranslation("metaitem.01.tooltip.nqgen"));
        }
        if ((werkstoff = Werkstoff.werkstoffHashMap.get((short)this.getDamage(aStack))) != null && !(tooltip = werkstoff.getLocalizedToolTip()).isEmpty()) {
            aList.add(tooltip);
        }
    }

    public String func_77653_i(ItemStack aStack) {
        int aMetaData = aStack.func_77960_j();
        Werkstoff werkstoff = Werkstoff.werkstoffHashMap.get((short)aMetaData);
        if (werkstoff == null) {
            werkstoff = Werkstoff.default_null_Werkstoff;
        }
        return this.itemTypeLocalizedName.replace("%material", werkstoff.getLocalizedName());
    }

    @Override
    public IIconContainer getIconContainer(int aMetaData) {
        if (Werkstoff.werkstoffHashMap.get((short)aMetaData) == null) {
            return null;
        }
        if (this.orePrefixes.mTextureIndex == -1) {
            return this.getIconContainerBartWorks(aMetaData);
        }
        return Werkstoff.werkstoffHashMap.get((Object)Short.valueOf((short)((short)aMetaData))).getTexSet().mTextures[this.orePrefixes.mTextureIndex];
    }

    protected IIconContainer getIconContainerBartWorks(int aMetaData) {
        if (SideReference.Side.Client) {
            return PrefixTextureLinker.texMap.get((Object)this.orePrefixes).get(Werkstoff.werkstoffHashMap.get((short)aMetaData).getTexSet());
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (werkstoff == null || !werkstoff.hasItemType(this.orePrefixes)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, (int)werkstoff.getmID());
            aList.add(tStack);
        }
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        Werkstoff werkstoff = Werkstoff.werkstoffHashMap.get((short)this.getDamage(aStack));
        return werkstoff == null ? Materials._NULL.mRGBa : werkstoff.getRGBA();
    }

    @Override
    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        super.func_77663_a(aStack, aWorld, aPlayer, aTimer, aIsInHand);
        if (aStack == null || aStack.func_77973_b() == null || !(aPlayer instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer bPlayer = (EntityPlayer)aPlayer;
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        if (w == null || w.getStats() == null) {
            return;
        }
        if (w.getStats().isToxic() && !GTUtility.isWearingFullBioHazmat((EntityLivingBase)bPlayer)) {
            bPlayer.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 80, 4));
        }
        if (w.getStats().isRadioactive() && !GTUtility.isWearingFullRadioHazmat((EntityLivingBase)bPlayer)) {
            bPlayer.func_70690_d(new PotionEffect(IC2Potion.radiation.field_76415_H, 80, 4));
        }
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        Werkstoff tMaterial = Werkstoff.werkstoffHashMap.get((short)aMetaData);
        if (tMaterial == null) {
            return null;
        }
        IIconContainer tIcon = this.getIconContainer(aMetaData);
        if (tIcon != null) {
            return tIcon.getIcon();
        }
        return null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return this.orePrefixes.mDefaultStackSize;
    }

    @Override
    public int getRadiationLevel(ItemStack aStack) {
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        return w.getStats().isRadioactive() ? (int)w.getStats().getProtons() : 0;
    }

    @Override
    public byte getAmountOfMaterial(ItemStack aStack) {
        return (byte)(this.orePrefixes == OrePrefixes.stick ? 1 : (this.orePrefixes == OrePrefixes.stickLong ? 2 : 0));
    }

    @Override
    public short[] getColorForGUI(ItemStack aStack) {
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        return w.getRGBA();
    }

    @Override
    public String getNameForGUI(ItemStack aStack) {
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        return w.getDefaultName();
    }

    @Override
    public int getCapacity(ItemStack aStack) {
        return this.orePrefixes == OrePrefixes.capsule || this.orePrefixes == OrePrefixes.cell || this.orePrefixes == OrePrefixes.cellPlasma ? 1000 : (this.orePrefixes == OrePrefixes.cellMolten || this.orePrefixes == OrePrefixes.capsuleMolten ? 144 : 0);
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        if (this.orePrefixes == OrePrefixes.cell || this.orePrefixes == OrePrefixes.cellPlasma || this.orePrefixes == OrePrefixes.cellMolten) {
            return Materials.Empty.getCells(1);
        }
        if (this.orePrefixes == OrePrefixes.capsule) {
            return ItemList.FR_WaxCapsule.get(1L, new Object[0]);
        }
        if (this.orePrefixes == OrePrefixes.capsuleMolten) {
            return ItemList.FR_RefractoryCapsule.get(1L, new Object[0]);
        }
        return null;
    }
}

