/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.block.Block;
import org.jetbrains.annotations.NotNull;

public class GlassTier {
    private static final HashMap<BlockMetaPair, Integer> glasses = new HashMap();

    public static void addCustomGlass(String modname, String unlocalisedBlockName, int meta, int tier) {
        Block block = GameRegistry.findBlock((String)modname, (String)unlocalisedBlockName);
        if (block != null) {
            GlassTier.addCustomGlass(block, meta, tier);
        } else {
            new IllegalArgumentException("Block: " + unlocalisedBlockName + " of the Mod: " + modname + " was NOT found when attempting to register a glass!").printStackTrace();
        }
    }

    public static void addCustomGlass(@NotNull Block block, int meta, int tier) {
        Objects.requireNonNull(block, "Glass block cannot be null");
        glasses.put(new BlockMetaPair(block, (byte)meta), tier);
    }

    public static HashMap<BlockMetaPair, Integer> getGlassMap() {
        return glasses;
    }

    public static int getGlassTier(Block block, int meta) {
        return glasses.getOrDefault(new BlockMetaPair(block, (byte)meta), 0);
    }

    public static class BlockMetaPair {
        private final Block block;
        private final int meta;

        public BlockMetaPair(Block block, int aByte) {
            this.block = block;
            this.meta = aByte;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockMetaPair that = (BlockMetaPair)o;
            return Objects.equals(this.getBlock(), that.getBlock()) && Objects.equals(this.getMeta(), that.getMeta());
        }

        public int hashCode() {
            return Objects.hash(this.getBlock(), this.getMeta());
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

