/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalLayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.integration.model.buttons.UndergroundFluidButtonManager;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidChunkLocation;
import com.sinthoras.visualprospecting.integration.model.render.UndergroundFluidChunkRenderStep;
import org.jetbrains.annotations.Nullable;

public class UndergroundFluidChunkLayerManager
extends LayerManager {
    public static final UndergroundFluidChunkLayerManager instance = new UndergroundFluidChunkLayerManager();

    public UndergroundFluidChunkLayerManager() {
        super((ButtonManager)UndergroundFluidButtonManager.instance);
    }

    @Nullable
    protected LayerRenderer addLayerRenderer(LayerManager manager, SupportedMods mods) {
        return new UniversalLayerRenderer(manager).withRenderStep(location -> new UndergroundFluidChunkRenderStep((UndergroundFluidChunkLocation)location));
    }

    protected ILocationProvider generateLocation(int chunkX, int chunkZ, int dim) {
        if (chunkX % 8 != 0 || chunkZ % 8 != 0) {
            return null;
        }
        UndergroundFluidPosition undergroundFluid = ClientCache.instance.getUndergroundFluid(dim, chunkX, chunkZ);
        if (!undergroundFluid.isProspected()) {
            return null;
        }
        this.generateExtraFluidChunks(chunkX, chunkZ, dim, undergroundFluid);
        return new UndergroundFluidChunkLocation(chunkX, chunkZ, dim, undergroundFluid, 0, 0);
    }

    private void generateExtraFluidChunks(int chunkX, int chunkZ, int dim, UndergroundFluidPosition undergroundFluid) {
        for (int offsetX = 0; offsetX < 8; ++offsetX) {
            for (int offsetZ = 0; offsetZ < 8; ++offsetZ) {
                if (offsetX == 0 && offsetZ == 0) continue;
                this.addExtraLocation(new UndergroundFluidChunkLocation(chunkX, chunkZ, dim, undergroundFluid, offsetX, offsetZ));
            }
        }
    }
}

