/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.helpers;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class OreDictIterator {
    private static final IdentityHashMap<List<ItemStack>, IdentityHashMap<Item, Pair<Integer, Integer>>> ITERATOR_CACHE = new IdentityHashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findStartingIndex(List<ItemStack> oreList, Item target) {
        int low = 0;
        int high = oreList.size() - 1;
        int targetId = Item.func_150891_b((Item)target);
        while (low <= high) {
            int comparisonResult;
            int mid = (low + high) / 2;
            ItemStack option = oreList.get(mid);
            if (option.func_77973_b() == target) {
                ItemStack previous;
                ItemStack itemStack = previous = mid > 0 ? oreList.get(mid - 1) : null;
                if (previous == null || previous.func_77973_b() != target) return mid;
                comparisonResult = 1;
            } else {
                int optionId = Item.func_150891_b((Item)option.func_77973_b());
                if (optionId < targetId) {
                    comparisonResult = -1;
                } else {
                    if (optionId <= targetId) throw new IllegalStateException();
                    comparisonResult = 1;
                }
            }
            if (comparisonResult < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    public static Item getItemFromStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77973_b();
    }

    public static Iterator<ItemStack> get(String oreName, Item target) {
        if (target == null) {
            return Collections.emptyIterator();
        }
        List oreList = OreDictionary.getOres((String)oreName, (boolean)false);
        if (oreList == null) {
            return Collections.emptyIterator();
        }
        if (oreList.size() < 10) {
            return oreList.iterator();
        }
        return OreDictIterator.get(oreList, target);
    }

    public static Iterator<ItemStack> get(List<ItemStack> oreList, Item target) {
        int endIndex;
        int startIndex;
        Pair<Integer, Integer> indices;
        if (target == null) {
            return Collections.emptyIterator();
        }
        IdentityHashMap<Object, Object> targetMap = ITERATOR_CACHE.get(oreList);
        if (targetMap == null) {
            targetMap = new IdentityHashMap();
            ITERATOR_CACHE.put(oreList, targetMap);
        }
        if ((indices = targetMap.get(target)) != null) {
            startIndex = (Integer)indices.getLeft();
            endIndex = (Integer)indices.getRight();
        } else {
            int potentialStartIndex = OreDictIterator.findStartingIndex(oreList, target);
            if (potentialStartIndex < 0 || potentialStartIndex >= oreList.size() || oreList.get(potentialStartIndex).func_77973_b() != target) {
                startIndex = -1;
                endIndex = -1;
            } else {
                startIndex = potentialStartIndex;
                int end = -1;
                for (int i = startIndex; i < oreList.size(); ++i) {
                    if (oreList.get(i).func_77973_b() == target) continue;
                    end = i;
                    break;
                }
                if (end == -1) {
                    end = oreList.size();
                }
                endIndex = end;
            }
            targetMap.put(target, (Pair<Integer, Integer>)Pair.of((Object)startIndex, (Object)endIndex));
        }
        if (startIndex == -1 || endIndex == -1) {
            return Collections.emptyIterator();
        }
        return oreList.subList(startIndex, endIndex).iterator();
    }

    public static void clearCache(String oreName) {
        List theList = OreDictionary.getOres((String)oreName, (boolean)false);
        if (theList != null) {
            ITERATOR_CACHE.remove(theList);
        }
    }
}

