/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.config;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiEditArray;
import cpw.mods.fml.client.config.GuiEditArrayEntries;
import cpw.mods.fml.client.config.GuiUtils;
import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.List;
import net.glease.tc4tweak.CommonUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

public class StringOrderingEntry
extends GuiEditArrayEntries.StringEntry {
    private static final String[] upLabels = new String[]{"\u2191", "\u21915", "\u219f"};
    private static final String[] downLabels = new String[]{"\u2193", "\u21935", "\u21a1"};
    private static final Field field_GuiEditArray_enabled = ReflectionHelper.findField(GuiEditArray.class, (String[])new String[]{"enabled"});
    private final GuiButtonExt btnMoveUp;
    private final GuiButtonExt btnMoveDown;
    private final HoverChecker moveUpHoverChecker;
    private final HoverChecker moveDownHoverChecker;
    private final List<List<String>> moveUpToolTip;
    private final List<List<String>> moveDownToolTip;

    public StringOrderingEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
        super(owningScreen, owningEntryList, configElement, value);
        boolean enabled = (Boolean)CommonUtils.reflectGet(field_GuiEditArray_enabled, owningScreen);
        this.btnMoveUp = new GuiButtonExt(0, 0, 0, 18, 18, "\u2191");
        this.btnMoveUp.packedFGColour = GuiUtils.getColorCode((char)'7', (boolean)true);
        this.btnMoveUp.field_146124_l = enabled;
        this.btnMoveDown = new GuiButtonExt(0, 0, 0, 18, 18, "\u2193");
        this.btnMoveDown.packedFGColour = GuiUtils.getColorCode((char)'7', (boolean)true);
        this.btnMoveDown.field_146124_l = enabled;
        this.moveUpHoverChecker = new HoverChecker((GuiButton)this.btnMoveUp, 800);
        this.moveDownHoverChecker = new HoverChecker((GuiButton)this.btnMoveDown, 800);
        this.moveUpToolTip = ImmutableList.of((Object)ImmutableList.of((Object)I18n.func_135052_a((String)"tc4tweaks.configgui.tooltip.moveUp", (Object[])new Object[0])), (Object)ImmutableList.of((Object)I18n.func_135052_a((String)"tc4tweaks.configgui.tooltip.moveUp.shift", (Object[])new Object[0])), (Object)ImmutableList.of((Object)I18n.func_135052_a((String)"tc4tweaks.configgui.tooltip.moveUp.ctrl", (Object[])new Object[0])));
        this.moveDownToolTip = ImmutableList.of((Object)ImmutableList.of((Object)I18n.func_135052_a((String)"tc4tweaks.configgui.tooltip.moveDown", (Object[])new Object[0])), (Object)ImmutableList.of((Object)I18n.func_135052_a((String)"tc4tweaks.configgui.tooltip.moveDown.shift", (Object[])new Object[0])), (Object)ImmutableList.of((Object)I18n.func_135052_a((String)"tc4tweaks.configgui.tooltip.moveDown.ctrl", (Object[])new Object[0])));
        this.textFieldValue.field_146218_h -= 44;
    }

    private static int getKeyboardState(int normal, int shift, int ctrl) {
        return GuiScreen.func_146271_m() ? ctrl : (GuiScreen.func_146272_n() ? shift : normal);
    }

    public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
        if (this.getValue() != null && this.isValidated) {
            this.owningEntryList.field_148161_k.field_71466_p.func_78276_b(this.isValidValue ? EnumChatFormatting.GREEN + "\u2714" : EnumChatFormatting.RED + "\u2715", listWidth / 4 - this.owningEntryList.field_148161_k.field_71466_p.func_78256_a("\u2714") - 2, y + slotHeight / 2 - this.owningEntryList.field_148161_k.field_71466_p.field_78288_b / 2, 0xFFFFFF);
        }
        int labelIndex = StringOrderingEntry.getKeyboardState(0, 1, 2);
        int half = listWidth / 2;
        if (this.owningEntryList.canAddMoreEntries) {
            this.btnAddNewEntryAbove.field_146125_m = true;
            this.btnAddNewEntryAbove.field_146128_h = half + (half / 2 - 44);
            this.btnAddNewEntryAbove.field_146129_i = y;
            this.btnAddNewEntryAbove.func_146112_a(this.owningEntryList.field_148161_k, mouseX, mouseY);
        } else {
            this.btnAddNewEntryAbove.field_146125_m = false;
        }
        if (!this.configElement.isListLengthFixed() && slotIndex != this.owningEntryList.listEntries.size() - 1) {
            this.btnRemoveEntry.field_146125_m = true;
            this.btnRemoveEntry.field_146128_h = half + (half / 2 - 22);
            this.btnRemoveEntry.field_146129_i = y;
            this.btnRemoveEntry.func_146112_a(this.owningEntryList.field_148161_k, mouseX, mouseY);
        } else {
            this.btnRemoveEntry.field_146125_m = false;
        }
        if (this.configElement.isListLengthFixed() || slotIndex != this.owningEntryList.listEntries.size() - 1) {
            this.textFieldValue.func_146189_e(true);
            this.textFieldValue.field_146210_g = y + 1;
            this.textFieldValue.func_146194_f();
        } else {
            this.textFieldValue.func_146189_e(false);
        }
        if (slotIndex > 0) {
            this.btnMoveUp.field_146125_m = true;
            this.btnMoveUp.field_146128_h = half + half / 2 - 88;
            this.btnMoveUp.field_146129_i = y;
            this.btnMoveUp.field_146126_j = upLabels[labelIndex];
            this.btnMoveUp.func_146112_a(this.owningEntryList.field_148161_k, mouseX, mouseY);
        } else {
            this.btnMoveUp.field_146125_m = false;
        }
        if (slotIndex < this.owningEntryList.listEntries.size() - 2) {
            this.btnMoveDown.field_146125_m = true;
            this.btnMoveDown.field_146128_h = half + half / 2 - 66;
            this.btnMoveDown.field_146129_i = y;
            this.btnMoveDown.field_146126_j = downLabels[labelIndex];
            this.btnMoveDown.func_146112_a(this.owningEntryList.field_148161_k, mouseX, mouseY);
        } else {
            this.btnMoveDown.field_146125_m = false;
        }
    }

    public void drawToolTip(int mouseX, int mouseY) {
        boolean canHover;
        super.drawToolTip(mouseX, mouseY);
        int labelIndex = StringOrderingEntry.getKeyboardState(0, 1, 2);
        boolean bl = canHover = mouseY < this.owningEntryList.field_148154_c && mouseY > this.owningEntryList.field_148153_b;
        if (this.btnMoveUp.field_146125_m && this.moveUpHoverChecker.checkHover(mouseX, mouseY, canHover)) {
            this.owningScreen.drawToolTip(this.moveUpToolTip.get(labelIndex), mouseX, mouseY);
        }
        if (this.btnMoveDown.field_146125_m && this.moveDownHoverChecker.checkHover(mouseX, mouseY, canHover)) {
            this.owningScreen.drawToolTip(this.moveDownToolTip.get(labelIndex), mouseX, mouseY);
        }
    }

    public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        int delta = StringOrderingEntry.getKeyboardState(1, 5, this.owningEntryList.listEntries.size());
        if (this.btnAddNewEntryAbove.func_146116_c(this.owningEntryList.field_148161_k, x, y)) {
            this.btnAddNewEntryAbove.func_146113_a(this.owningEntryList.field_148161_k.func_147118_V());
            this.owningEntryList.listEntries.add(index, new StringOrderingEntry(this.owningScreen, this.owningEntryList, this.owningEntryList.configElement, ""));
            this.owningEntryList.canAddMoreEntries = !this.owningEntryList.configElement.isListLengthFixed() && (this.owningEntryList.configElement.getMaxListLength() == -1 || this.owningEntryList.listEntries.size() - 1 < this.owningEntryList.configElement.getMaxListLength());
            this.owningEntryList.recalculateState();
            return true;
        }
        if (this.btnRemoveEntry.func_146116_c(this.owningEntryList.field_148161_k, x, y)) {
            this.btnRemoveEntry.func_146113_a(this.owningEntryList.field_148161_k.func_147118_V());
            this.owningEntryList.removeEntry(index);
            this.owningEntryList.recalculateState();
            return true;
        }
        if (this.btnMoveUp.func_146116_c(this.owningScreen.field_146297_k, x, y)) {
            this.btnMoveUp.func_146113_a(this.owningScreen.field_146297_k.func_147118_V());
            GuiEditArrayEntries.IArrayEntry e = (GuiEditArrayEntries.IArrayEntry)this.owningEntryList.listEntries.remove(index);
            this.owningEntryList.listEntries.add(Math.max(index - delta, 0), e);
            this.owningEntryList.recalculateState();
            return true;
        }
        if (this.btnMoveDown.func_146116_c(this.owningScreen.field_146297_k, x, y)) {
            this.btnMoveDown.func_146113_a(this.owningScreen.field_146297_k.func_147118_V());
            GuiEditArrayEntries.IArrayEntry e = (GuiEditArrayEntries.IArrayEntry)this.owningEntryList.listEntries.remove(index);
            this.owningEntryList.listEntries.add(Math.min(index + delta, this.owningEntryList.listEntries.size()), e);
            this.owningEntryList.recalculateState();
            return true;
        }
        return false;
    }
}

