/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.item;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.core.CreativeTab;
import appeng.parts.p2p.PartP2PTunnel;
import com.projecturanus.betterp2p.client.ClientCache;
import com.projecturanus.betterp2p.client.gui.widget.GuiScale;
import com.projecturanus.betterp2p.item.BetterMemoryCardModes;
import com.projecturanus.betterp2p.network.ModNetwork;
import com.projecturanus.betterp2p.network.data.MemoryInfo;
import com.projecturanus.betterp2p.network.data.P2PLocationKt;
import com.projecturanus.betterp2p.util.CableBusUtilKt;
import com.projecturanus.betterp2p.util.p2p.P2PUtilKt;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u0004H\u0003J4\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\bH\u0016JX\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0016J0\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\rH\u0016J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0017J\u0016\u0010+\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0017\u00a8\u0006-"}, d2={"Lcom/projecturanus/betterp2p/item/ItemAdvancedMemoryCard;", "Lnet/minecraft/item/Item;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "tooltip", "", "", "boolean", "", "clearClientCache", "doesSneakBypassUse", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "getInfo", "Lcom/projecturanus/betterp2p/network/data/MemoryInfo;", "onItemRightClick", "itemstack", "worldIn", "playerIn", "onItemUse", "w", "side", "hx", "", "hy", "hz", "onUpdate", "entityIn", "Lnet/minecraft/entity/Entity;", "itemSlot", "isSelected", "registerIcons", "ri", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "writeInfo", "info", "betterp2p"})
public final class ItemAdvancedMemoryCard
extends Item {
    @NotNull
    public static final ItemAdvancedMemoryCard INSTANCE = new ItemAdvancedMemoryCard();

    private ItemAdvancedMemoryCard() {
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull List<Object> tooltip, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MemoryInfo info2 = this.getInfo(stack);
        Collection collection = tooltip;
        StringBuilder stringBuilder = new StringBuilder().append("gui.advanced_memory_card.mode.");
        String string = info2.getMode().name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        collection.add(StatCollector.func_74838_a((String)stringBuilder.append(string2).toString()));
    }

    @SideOnly(value=Side.CLIENT)
    private final void clearClientCache() {
        ClientCache.INSTANCE.clear();
    }

    @NotNull
    public ItemStack func_77659_a(@NotNull ItemStack itemstack, @NotNull World worldIn, @NotNull EntityPlayer playerIn) {
        Intrinsics.checkNotNullParameter((Object)itemstack, (String)"itemstack");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        if (playerIn.func_70093_af() && worldIn.field_72995_K) {
            this.clearClientCache();
        }
        ItemStack itemStack = super.func_77659_a(itemstack, worldIn, playerIn);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"super.onItemRightClick(i\u2026stack, worldIn, playerIn)");
        return itemStack;
    }

    public boolean func_77648_a(@NotNull ItemStack itemstack, @NotNull EntityPlayer player, @NotNull World w, int x, int y, int z, int side, float hx, float hy, float hz) {
        TileEntity te;
        Intrinsics.checkNotNullParameter((Object)itemstack, (String)"itemstack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        if (!w.field_72995_K && (te = w.func_147438_o(x, y, z)) instanceof IGridHost && ((IGridHost)te).getGridNode(ForgeDirection.getOrientation((int)side)) != null) {
            IPart part = CableBusUtilKt.getPart((IBlockAccess)w, x, y, z, hx, hy, hz);
            IPart iPart = part;
            IGrid iGrid = iPart != null && (iPart = iPart.getGridNode()) != null ? iPart.getGrid() : null;
            if (iGrid == null) {
                return false;
            }
            IGrid grid = iGrid;
            if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
                return false;
            }
            ItemStack stack = player.func_70694_bm();
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            MemoryInfo info2 = this.getInfo(stack);
            int type = 0;
            if (part instanceof PartP2PTunnel) {
                type = P2PUtilKt.getTypeIndex((PartP2PTunnel)part);
                info2.setSelectedEntry(P2PLocationKt.toLoc((PartP2PTunnel)part));
            } else {
                type = -1;
                info2.setSelectedEntry(null);
            }
            info2.setType(type);
            this.writeInfo(stack, info2);
            ModNetwork.INSTANCE.initConnection(player, grid, info2);
            return true;
        }
        return false;
    }

    public boolean doesSneakBypassUse(@Nullable World world, int x, int y, int z, @Nullable EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(@NotNull IIconRegister ri) {
        Intrinsics.checkNotNullParameter((Object)ri, (String)"ri");
        this.field_77791_bV = ri.func_94245_a("betterp2p:advanced_memory_card");
    }

    @NotNull
    public final MemoryInfo getInfo(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)((Object)this))) {
            throw new ClassCastException("Cannot cast " + stack.func_77973_b().getClass().getName() + " to " + ((Object)((Object)this)).getClass().getName());
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        Intrinsics.checkNotNull((Object)nBTTagCompound);
        NBTTagCompound compound = nBTTagCompound;
        if (!compound.func_74764_b("gui")) {
            compound.func_74774_a("gui", (byte)GuiScale.DYNAMIC.ordinal());
        }
        if (!compound.func_150297_b("selectedIndex", 10)) {
            compound.func_74782_a("selectedIndex", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound2 = compound.func_74775_l("selectedIndex");
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound2, (String)"compound.getCompoundTag(\"selectedIndex\")");
        return new MemoryInfo(P2PLocationKt.readP2PLocation(nBTTagCompound2), compound.func_74763_f("frequency"), BetterMemoryCardModes.values()[compound.func_74762_e("mode")], GuiScale.values()[compound.func_74771_c("gui")], 0, 16, null);
    }

    public final void writeInfo(@NotNull ItemStack stack, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        if (!Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)((Object)this))) {
            throw new ClassCastException("Cannot cast " + stack.func_77973_b().getClass().getName() + " to " + ((Object)((Object)this)).getClass().getName());
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        Intrinsics.checkNotNull((Object)nBTTagCompound);
        NBTTagCompound compound = nBTTagCompound;
        compound.func_74782_a("selectedIndex", (NBTBase)P2PLocationKt.writeP2PLocation(info2.getSelectedEntry()));
        compound.func_74772_a("frequency", info2.getFrequency());
        compound.func_74768_a("mode", info2.getMode().ordinal());
        compound.func_74774_a("gui", (byte)info2.getGuiScale().ordinal());
    }

    static {
        ItemAdvancedMemoryCard.INSTANCE.field_77777_bU = 1;
        INSTANCE.func_77655_b("advanced_memory_card");
        INSTANCE.func_77637_a((CreativeTabs)CreativeTab.instance);
    }
}

