/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui.hud;

import cpw.mods.fml.client.FMLClientHandler;
import logisticspipes.interfaces.IHUDButton;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SimpleGraphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import org.lwjgl.opengl.GL11;

public abstract class BasicHUDButton
implements IHUDButton {
    protected final int posX;
    protected final int posY;
    protected final int sizeX;
    protected final int sizeY;
    protected long focusedTimeStart = 0L;
    protected final String label;

    public BasicHUDButton(String name, int x, int y, int width, int heigth) {
        this.label = name;
        this.posX = x;
        this.posY = y;
        this.sizeX = width;
        this.sizeY = heigth;
    }

    @Override
    public int getX() {
        return this.posX;
    }

    @Override
    public int getY() {
        return this.posY;
    }

    @Override
    public int sizeX() {
        return this.sizeX;
    }

    @Override
    public int sizeY() {
        return this.sizeY;
    }

    @Override
    public void blockFocused() {
        this.focusedTimeStart = -1L;
    }

    @Override
    public boolean isblockFocused() {
        return this.focusedTimeStart == -1L;
    }

    @Override
    public void setFocused() {
        this.focusedTimeStart = System.currentTimeMillis();
    }

    @Override
    public boolean isFocused() {
        return this.focusedTimeStart != 0L;
    }

    @Override
    public void clearFocused() {
        this.focusedTimeStart = 0L;
    }

    @Override
    public int focusedTime() {
        return (int)(System.currentTimeMillis() - this.focusedTimeStart);
    }

    @Override
    public void renderButton(boolean hover, boolean clicked, boolean shifted) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        minecraft.field_71446_o.func_110577_a(GuiGraphics.WIDGETS_TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = !this.buttonEnabled() ? 0 : (hover ? 2 : 1);
        SimpleGraphics.drawTexturedModalRect(this.posX, this.posY, 0, 46 + k * 20, this.sizeX / 2, this.sizeY / 2, 0.0);
        SimpleGraphics.drawTexturedModalRect(this.posX + this.sizeX / 2, this.posY, 200 - this.sizeX / 2, 46 + k * 20, this.sizeX / 2, this.sizeY / 2, 0.0);
        SimpleGraphics.drawTexturedModalRect(this.posX, this.posY + this.sizeY / 2, 0, 70 - this.sizeY + k * 20, this.sizeX / 2, this.sizeY / 2, 0.0);
        SimpleGraphics.drawTexturedModalRect(this.posX + this.sizeX / 2, this.posY + this.sizeY / 2, 200 - this.sizeX / 2, 70 - this.sizeY + k * 20, this.sizeX / 2, this.sizeY / 2, 0.0);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.001f);
        int color = Color.getValue(Color.LIGHTER_GREY);
        if (!clicked) {
            color = Color.getValue(Color.LIGHT_YELLOW);
            if (hover) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.02f);
            }
        }
        minecraft.field_71466_p.func_78276_b(this.label, -(minecraft.field_71466_p.func_78256_a(this.label) / 2) + this.posX + this.sizeX / 2, this.posY + (this.sizeY - 8) / 2, color);
        if (!clicked && hover) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.02f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.001f);
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110576_c);
    }

    @Override
    public void renderAlways(boolean shifted) {
    }
}

