/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="hodgepodge", category="fixes")
@Config.RequiresMcRestart
public class FixesConfig {
    @Config.Comment(value={"Modify the maximum NBT size limit when received as a network packet, to avoid large NBT-related crashes"})
    @Config.DefaultBoolean(value=true)
    public static boolean changeMaxNetworkNbtSizeLimit;
    @Config.Comment(value={"Safely enlarge the potion array before other mods"})
    @Config.DefaultBoolean(value=true)
    public static boolean enlargePotionArray;
    @Config.Comment(value={"Fix bogus FMLProxyPacket NPEs on integrated server crashes."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixBogusIntegratedServerNPEs;
    @Config.Comment(value={"Fix wrapped chat lines missing colors"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixChatWrappedColors;
    @Config.Comment(value={"Prevents crash if server sends container with wrong itemStack size"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixContainerPutStacksInSlots;
    @Config.Comment(value={"Fixes the debug hitbox of the player beeing offset"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixDebugBoundingBox;
    @Config.Comment(value={"Fix losing bonus hearts on dimension change"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixDimensionChangeHearts;
    @Config.Comment(value={"Fix duplicate sounds from playing when closing a gui."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixDuplicateSounds;
    @Config.Comment(value={"Fix deleting stack when eating mushroom stew"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixEatingStackedStew;
    @Config.Comment(value={"Fix a class name typo in MinecraftForge's initialize method"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixEffectRendererClassTypo;
    @Config.Comment(value={"Fix enchantment levels not displaying properly above a certain value"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixEnchantmentNumerals;
    @Config.Comment(value={"Fix fence connections with other types of fence"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixFenceConnections;
    @Config.Comment(value={"Fix vanilla fire spread sometimes cause NPE on thermos"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixFireSpread;
    @Config.Comment(value={"Fix Forge fluid container registry key"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixFluidContainerRegistryKey;
    @Config.Comment(value={"Replace recursion with iteration in FontRenderer line wrapping code"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixFontRendererLinewrapRecursion;
    @Config.Comment(value={"Fix windowId being set on openContainer even if openGui failed"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixForgeOpenGuiHandlerWindowId;
    @Config.Comment(value={"Fix the Forge update checker"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixForgeUpdateChecker;
    @Config.Comment(value={"Fix vanilla issue where player sounds register as animal sounds"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixFriendlyCreatureSounds;
    @Config.Comment(value={"Fix Volume Slider is ineffective until reaching the lower end"})
    @Config.DefaultBoolean(value=true)
    public static boolean logarithmicVolumeControl;
    @Config.Comment(value={"Fix vanilla light calculation sometimes cause NPE on thermos"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixGetBlockLightValue;
    @Config.Comment(value={"Fix vanilla GL state bugs causing lighting glitches in various perspectives (MC-10135)."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixGlStateBugs;
    @Config.Comment(value={"Fix Game Over GUI buttons disabled if switching fullscreen"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixGuiGameOver;
    @Config.Comment(value={"Fix arm not swinging when having too much haste"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixHasteArmSwing;
    @Config.Comment(value={"Fix vanilla Hopper hit box"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixHopperHitBox;
    @Config.Comment(value={"Fix Drawer + Hopper voiding items"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixHopperVoidingItems;
    @Config.Comment(value={"Fix oversized chat message kicking player."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixHugeChatKick;
    @Config.Comment(value={"Fix the bug that makes fireballs stop moving when chunk unloads"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixImmobileFireballs;
    @Config.Comment(value={"Fix an overflow of the dimension id when a player logins on a server"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixLoginDimensionIDOverflow;
    @Config.Comment(value={"Fixes the damage of the Thick Neutron Reflectors in the MT Core recipe (Advanced Solar Panels)"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixMTCoreRecipe;
    @Config.Comment(value={"Allows the server to assign the logged in UUID to the same username when online_mode is false"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNetHandlerLoginServerOfflineMode;
    @Config.Comment(value={"Prevents crash if server sends itemStack with index larger than client's container"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNetHandlerPlayClientHandleSetSlot;
    @Config.Comment(value={"Fix NPE in Netty's Bootstrap class"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNettyNPE;
    @Config.Comment(value={"Fix northwest bias on RandomPositionGenerator"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNorthWestBias;
    @Config.Comment(value={"Prevent tall grass and such to affect the perspective camera"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPerspectiveCamera;
    @Config.Comment(value={"Allow some mods to properly fetch the player skin"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPlayerSkinFetching;
    @Config.Comment(value={"Preserve the order of quads in terrain pass 1"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPreserveQuadOrder;
    @Config.Comment(value={"Properly display level of potion effects in the inventory and on tooltips"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPotionEffectNumerals;
    @Config.Comment(value={"Fix crashes with ConcurrentModificationException because of incorrectly iterating over active potions"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPotionIterating;
    @Config.Comment(value={"Fix potions >= 128"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPotionLimit;
    @Config.Comment(value={"Fix redstone torch leaking world"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixRedstoneTorchWorldLeak;
    @Config.Comment(value={"Fix EffectRenderer and RenderGlobal leaking world instance when leaving world"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixRenderersWorldLeak;
    @Config.Comment(value={"Fix game window becoming not resizable after toggling fullscrean in any way"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixResizableFullscreen;
    @Config.Comment(value={"Fix resource pack folder not opening on Windows if file path has a space"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixResourcePackOpening;
    @Config.Comment(value={"Fix too many allocations from Chunk Coordinate Int Pair"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixTooManyAllocationsChunkPositionIntPair;
    @Config.Comment(value={"Fix exiting fullscreen when you tab out of the game"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixUnfocusedFullscreen;
    @Config.Comment(value={"Fix URISyntaxException in forge."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixUrlDetection;
    @Config.Comment(value={"Fixes various unchecked vanilla getBlock() methods"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixVanillaUnprotectedGetBlock;
    @Config.Comment(value={"Fixes village unchecked getBlock() calls"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixVillageUncheckedGetBlock;
    @Config.Comment(value={"Fix unprotected getBlock() in World"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixWorldGetBlock;
    @Config.Comment(value={"Fix WorldServer leaking entities when no players are present in a dimension"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixWorldServerLeakingUnloadedEntities;
    @Config.Comment(value={"Increase the maximum network packet size from the default of 2MiB"})
    @Config.DefaultBoolean(value=true)
    public static boolean increasePacketSizeLimit;
    @Config.Comment(value={"Stacks picked up per tick"})
    @Config.RangeInt(min=1, max=64)
    @Config.DefaultInt(value=36)
    public static int itemStacksPickedUpPerTick;
    @Config.Comment(value={"Log oversized chat message to console. WARNING: might create huge log files if this happens very often."})
    @Config.DefaultBoolean(value=true)
    public static boolean logHugeChat;
    @Config.Comment(value={"The maximum NBT size limit in bytes when received as a network packet, the vanilla value is 2097152 (2 MiB)."})
    @Config.RangeInt(min=1024, max=0x40000000)
    @Config.DefaultInt(value=0x10000000)
    public static int maxNetworkNbtSizeLimit;
    @Config.Comment(value={"Fix too early light initialization"})
    @Config.DefaultBoolean(value=true)
    public static boolean optimizeWorldUpdateLight;
    @Config.Comment(value={"The maximum size limit in bytes of a network packet to accept, the vanilla value is 2097152 (2 MiB)."})
    @Config.RangeInt(min=1024, max=0x40000000)
    @Config.DefaultInt(value=0x10000000)
    public static int packetSizeLimit;
    @Config.Comment(value={"Spigot-style extended chunk format to remove the 2MB chunk size limit"})
    @Config.DefaultBoolean(value=true)
    public static boolean remove2MBChunkLimit;
    @Config.Comment(value={"Disable the creative search tab since it can be very laggy in large modpacks"})
    @Config.DefaultBoolean(value=true)
    public static boolean removeCreativeSearchTab;
    @Config.Comment(value={"Drastically speedup animated textures (Basically the same as with optifine animations off but animations are working)"})
    @Config.DefaultBoolean(value=true)
    public static boolean speedupAnimations;
    @Config.Comment(value={"Stop \"You can only sleep at night\" message filling the chat"})
    @Config.DefaultBoolean(value=true)
    public static boolean squashBedErrorMessage;
    @Config.Comment(value={"Limits the amount of times the ItemPickupEvent triggers per tick since it can lead to a lot of lag"})
    @Config.DefaultBoolean(value=true)
    public static boolean throttleItemPickupEvent;
    @Config.Comment(value={"Triggers all conflicting key bindings on key press instead of a random one"})
    @Config.DefaultBoolean(value=true)
    public static boolean triggerAllConflictingKeybindings;
    @Config.Comment(value={"Validate vanilla packet encodings before sending in addition to on reception"})
    @Config.DefaultBoolean(value=true)
    public static boolean validatePacketEncodingBeforeSending;
    @Config.Comment(value={"Should the extended packet validation error cause a crash (true) or just print out an error to the log (false)"})
    @Config.DefaultBoolean(value=false)
    public static boolean validatePacketEncodingBeforeSendingShouldCrash;
    @Config.Comment(value={"Checks saved TileEntity coordinates earlier to provide a more descriptive error message"})
    @Config.DefaultBoolean(value=true)
    public static boolean earlyChunkTileCoordinateCheck;
    @Config.Comment(value={"Fix the temperature can go below absolute zero at very high place"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNegativeKelvin;
    @Config.Comment(value={"Destroy and log TileEntities failing the safe coordinate instead of crashing the game (can cause loss of data)"})
    @Config.DefaultBoolean(value=false)
    public static boolean earlyChunkTileCoordinateCheckDestructive;
    @Config.Comment(value={"Fix forge command handler not checking for a / and also not running commands with any case"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixSlashCommands;
    @Config.Comment(value={"Fix the command handler not allowing you to run commands typed in any case"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixCaseCommands;
    @Config.Comment(value={"Limit the number of recursive cascading block updates during world generation to prevent stack overflow crashes, set to -1 to disable the limit."})
    @Config.RangeInt(min=-1)
    @Config.DefaultInt(value=256)
    public static int limitRecursiveBlockUpdateDepth;
    @Config.Comment(value={"Fix the buttons not being centered in the GuiConfirmOpenLink"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixButtonsGuiConfirmOpenLink;
    @Config.Comment(value={"Fix an array out of bounds caused by the GameSettings getKeyDisplayString method"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixGameSettingsArrayOutOfBounds;
    @Config.Comment(value={"Fix the vanilla method to open chat links not working for every OS"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixChatOpenLink;
    @Config.Comment(value={"Fix nametags of spiders, endermen and ender dragons being rendered too dark"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixNametagBrightness;
    @Config.Comment(value={"Fix spiders, endermen and ender dragons being rendered too red when hit"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixHitEffectBrightness;
    @Config.Comment(value={"Fix server-side check of block placement distance by players being not identical client-side checks"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixWrongBlockPlacementDistanceCheck;
    @Config.Comment(value={"Fix inventory sync lag: prevents client to check recipes on empty slots. Particularly fixes lag when trying to eat food when full."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixInventorySyncLag;
    @Config.Comment(value={"Prevent the client from crashing due to invalid entity attributes range (MC-150405)"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixEntityAttributesRange;
    @Config.Comment(value={"Fix crash on Bukkit with BetterQuesting"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean fixBukkitBetterQuestingCrash;
    @Config.Comment(value={"Remove old/stale/outdated update checks."})
    @Config.DefaultBoolean(value=true)
    public static boolean removeUpdateChecks;
    @Config.Comment(value={"Enable multiple fixes to reduce RAM usage"})
    @Config.DefaultBoolean(value=true)
    public static boolean enableMemoryFixes;
    @Config.Comment(value={"Maximum hp for BetterHUD to render as hearts"})
    @Config.RangeInt(min=1, max=100000)
    @Config.DefaultInt(value=5000)
    public static int betterHUDHPRenderLimit;
    @Config.Comment(value={"Fix BetterHUD armor bar rendering breaking with skulls"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixBetterHUDArmorDisplay;
    @Config.Comment(value={"Fix BetterHUD freezing the game when trying to render high amounts of hp"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixBetterHUDHPDisplay;
    @Config.Comment(value={"Fix Bibliocraft packet exploits"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixBibliocraftPackets;
    @Config.Comment(value={"Fix Bibliocraft path sanitization"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixBibliocraftPathSanitization;
    @Config.Comment(value={"Removes duplicate Fermenter and Squeezer recipes and flower registration"})
    @Config.DefaultBoolean(value=true)
    public static boolean deduplicateForestryCompatInBOP;
    @Config.Comment(value={"BiomesOPlenty Java 12 compatibility patches."})
    @Config.DefaultBoolean(value=true)
    public static boolean java12BopCompat;
    @Config.Comment(value={"Remove the BOP warning on first world generation (ignored when dreamcraft is present)"})
    @Config.DefaultBoolean(value=false)
    public static boolean removeBOPWarning;
    @Config.Comment(value={"Fix NPE when interacting with sugar block"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixCandycraftBlockSugarNPE;
    @Config.Comment(value={"Fix NPE in COFH's oredict"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixCofhOreDictNPE;
    @Config.Comment(value={"Fix race condition in COFH's oredict"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixCofhOreDictCME;
    @Config.Comment(value={"Disable ExtraTic's Integration with Metallurgy 3 Precious Materials Module: (Brass, Silver, Electrum & Platinum)"})
    @Config.DefaultBoolean(value=false)
    public static boolean fixExtraTiCTEConflict;
    @Config.Comment(value={"Fix Extra Utilities drums eating IC2 cells and Forestry capsules"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesDrumEatingCells;
    @Config.Comment(value={"Fix Extra Utilities Lapis Caelestis microblocks rendering"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesGreenscreenMicroblocks;
    @Config.Comment(value={"Fixes rendering issues with transparent items from Extra Utilities"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesItemRendering;
    @Config.Comment(value={"Fix dupe bug with Division Sigil removing enchantment"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesUnEnchanting;
    @Config.Comment(value={"Remove rain from the Last Millenium (Extra Utilities)"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesLastMilleniumRain;
    @Config.Comment(value={"Remove creatures from the Last Millenium (Extra Utilities)"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesLastMilleniumCreatures;
    @Config.Comment(value={"Prevent fluid retrieval node from voiding (Extra Utilities)"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesFluidRetrievalNode;
    @Config.Comment(value={"Caps hotkey'd stacks to their maximum stack size in filing cabinets"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesFilingCabinetDupe;
    @Config.Comment(value={"Prevent hotkeying other items onto item filters while they are open"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixExtraUtilitiesFilterDupe;
    @Config.Comment(value={"Fix time commands with GC"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixTimeCommandWithGC;
    @Config.Comment(value={"Fix Gliby's voice chat not shutting down its thread cleanly"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixGlibysVoiceChatThreadStop;
    @Config.Comment(value={"Fix Hunger Overhaul low stat effects"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixHungerOverhaul;
    @Config.Comment(value={"Fix some items restore 0 hunger"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixHungerOverhaulRestore0Hunger;
    @Config.Comment(value={"Immersive Engineering Java 12 compatibility patch"})
    @Config.DefaultBoolean(value=true)
    public static boolean java12ImmersiveEngineeringCompat;
    @Config.Comment(value={"Fix lag caused by IC2 armor tick"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2ArmorLag;
    @Config.Comment(value={"Fix IC2's direct inventory access"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2DirectInventoryAccess;
    @Config.Comment(value={"Fix IC2's armor hover mode"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2HoverMode;
    @Config.Comment(value={"Prevent IC2's nightvision from blinding you"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2Nightvision;
    @Config.Comment(value={"Fix IC2's reactor dupe"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2ReactorDupe;
    @Config.Comment(value={"Fix IC2 not loading translations from resource packs"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2ResourcePackTranslation;
    @Config.Comment(value={"Fixes various unchecked IC2 getBlock() methods"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2UnprotectedGetBlock;
    @Config.Comment(value={"Optimize inventory access to IC2 nuclear reactor"})
    @Config.DefaultBoolean(value=true)
    public static boolean optimizeIc2ReactorInventoryAccess;
    @Config.Comment(value={"Fix IC2 Crops trampling any types of farmland to dirt when sprinting"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIc2CropTrampling;
    @Config.Comment(value={"Prevents journeymap from using illegal character in file paths"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixJourneymapFilePath;
    @Config.Comment(value={"Fix jumpy scrolling in the waypoint manager screen"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixJourneymapJumpyScrolling;
    @Config.Comment(value={"Prevent unbound keybinds from triggering when pressing certain keys"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixJourneymapKeybinds;
    @Config.Comment(value={"Lotr Java 12 compatibility patch"})
    @Config.DefaultBoolean(value=true)
    public static boolean java12LotrCompat;
    @Config.Comment(value={"Minechem Java 12 compatibility patch"})
    @Config.DefaultBoolean(value=true)
    public static boolean java12MineChemCompat;
    @Config.Comment(value={"Prevents Sacred Rubber Tree Generation"})
    @Config.DefaultBoolean(value=false)
    public static boolean disableMassiveSacredTreeGeneration;
    @Config.Comment(value={"Fix not properly waking players if not everyone is sleeping"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixMorpheusWaking;
    @Config.Comment(value={"Forces the chunk loading option from optifine to default since other values can crash the game"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixOptifineChunkLoadingCrash;
    @Config.Comment(value={"Fix Axis aligned Bounding Box of Ignis Fruit"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixIgnisFruitAABB;
    @Config.Comment(value={"If fancy graphics are enabled, Nether Leaves render sides with other Nether Leaves adjacent too"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNetherLeavesFaceRendering;
    @Config.Comment(value={"Fix outdated URLs used in the PortalGun mod to download the sound pack"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPortalGunURLs;
    @Config.Comment(value={"Fix Thaumcraft Aspects being sorted by tag instead of by name"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixThaumcraftAspectSorting;
    @Config.Comment(value={"Fix golem's marker loading failure when dimensionId larger than MAX_BYTE"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixThaumcraftGolemMarkerLoading;
    @Config.Comment(value={"Implement a proper hashing method for WorldCoordinates"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixThaumcraftWorldCoordinatesHashingMethod;
    @Config.Comment(value={"Fix Thaumcraft leaves frequent ticking"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixThaumcraftLeavesLag;
    @Config.Comment(value={"Fix Thaumcraft wand pedestal vis duplication"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixWandPedestalVisDuplication;
    @Config.Comment(value={"Fix handling of null stacks in ItemWispEssence"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixNullHandlingItemWispEssence;
    @Config.Comment(value={"Prevent crash with Thermal Dynamics from Negative Array Exceptions from item duct transfers"})
    @Config.DefaultBoolean(value=true)
    public static boolean preventThermalDynamicsNASE;
    @Config.Comment(value={"Fix some NullPointerExceptions"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixVoxelMapChunkNPE;
    @Config.Comment(value={"Fix Y coordinate being off by one"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixVoxelMapYCoord;
    @Config.Comment(value={"Disable Witchery potion extender for Java 12 compat"})
    @Config.DefaultBoolean(value=true)
    public static boolean disableWitcheryPotionExtender;
    @Config.Comment(value={"Fixes Witchery player skins reflections with inhabited mirrors"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixWitcheryReflections;
    @Config.Comment(value={"Enhanced Witchery Thunder Detection for rituals and Witch Hunters"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixWitcheryThunderDetection;
    @Config.Comment(value={"Fixes some potential errors in Witchery Rendering"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixWitcheryRendering;
    @Config.Comment(value={"Fixes the player entity dot rendering when arrow is chosen"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixXaerosMinimapEntityDot;
    @Config.Comment(value={"Fix scrolling in the world map screen"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixXaerosWorldMapScroll;
    @Config.Comment(value={"Fix ZTones packet exploits"})
    @Config.DefaultBoolean(value=true)
    public static boolean fixZTonesPackets;
}

