/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.mixins.late.journeymap;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.journeymap.render.JMLayerRenderer;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayer;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalLayerRenderer;
import com.gtnewhorizons.navigator.api.model.steps.RenderStep;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.MapChat;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Fullscreen.class})
public abstract class FullscreenMixin
extends JmUI {
    @Unique
    private int navigator$oldMouseX = 0;
    @Unique
    private int navigator$oldMouseY = 0;
    @Unique
    private long navigator$timeLastClick = 0L;
    @Unique
    private int navigator$oldCenterX = 0;
    @Unique
    private int navigator$oldCenterZ = 0;
    @Unique
    private int navigator$oldWidth = 0;
    @Unique
    private int navigator$oldHeight = 0;
    @Unique
    private long navigator$lastRecache = 0L;
    @Final
    @Shadow(remap=false)
    static GridRenderer gridRenderer;
    @Shadow(remap=false)
    ThemeToolbar mapTypeToolbar;
    @Shadow(remap=false)
    ThemeButton buttonCaves;
    @Shadow(remap=false)
    ThemeButton buttonNight;
    @Shadow(remap=false)
    ThemeButton buttonDay;
    @Shadow(remap=false)
    MapChat chat;
    @Shadow(remap=false)
    int mx;
    @Shadow(remap=false)
    int my;

    public FullscreenMixin() {
        super("");
    }

    @Shadow(remap=false)
    protected abstract int getMapFontScale();

    @Inject(method={"initGui"}, at={@At(value="RETURN")}, require=1)
    private void navigator$onInit(CallbackInfo ci) {
        NavigatorApi.getEnabledLayers(SupportedMods.JourneyMap).forEach(layerManager -> {
            layerManager.onGuiOpened(SupportedMods.JourneyMap);
            layerManager.forceRefresh();
        });
    }

    @Inject(method={"drawMap"}, at={@At(value="INVOKE", target="Ljourneymap/client/model/MapState;getDrawWaypointSteps()Ljava/util/List;")}, remap=false, require=1, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void navigator$onBeforeDrawJourneyMapWaypoints(CallbackInfo ci, boolean refreshReady, StatTimer timer, int xOffset, int yOffset, float drawScale) {
        int fontScale = this.getMapFontScale();
        Minecraft minecraft = Minecraft.func_71410_x();
        int centerBlockX = (int)Math.round(gridRenderer.getCenterBlockX());
        int centerBlockZ = (int)Math.round(gridRenderer.getCenterBlockZ());
        int widthBlocks = minecraft.field_71443_c >> gridRenderer.getZoom();
        int heightBlocks = minecraft.field_71440_d >> gridRenderer.getZoom();
        for (LayerManager layerManager : NavigatorApi.getEnabledLayers(SupportedMods.JourneyMap)) {
            if (!this.navigator$shouldRecache(centerBlockX, centerBlockZ, widthBlocks, heightBlocks, layerManager)) continue;
            layerManager.recacheFullscreenMap(centerBlockX, centerBlockZ, widthBlocks, heightBlocks);
        }
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersByPriority(SupportedMods.JourneyMap)) {
            if (!(layer instanceof JMLayerRenderer) && !(layer instanceof UniversalLayerRenderer)) continue;
            List<? extends RenderStep> steps = layer.getRenderSteps();
            gridRenderer.draw(steps, (double)xOffset, (double)yOffset, drawScale, (double)fontScale, 0.0);
        }
    }

    @Redirect(method={"initButtons"}, at=@At(value="FIELD", target="Ljourneymap/client/ui/fullscreen/Fullscreen;mapTypeToolbar:Ljourneymap/client/ui/theme/ThemeToolbar;", opcode=181), remap=false, require=1)
    private void navigator$OnCreateMapTypeToolbar(Fullscreen owner, ThemeToolbar value) {
        Theme theme = ThemeFileHandler.getCurrentTheme();
        ButtonList buttonList = new ButtonList();
        for (ButtonManager btnManager : NavigatorApi.getEnabledButtons(SupportedMods.JourneyMap)) {
            String icon = btnManager.getIcon(SupportedMods.JourneyMap, theme.name).toString();
            String trimmedIcon = icon.substring(0, icon.lastIndexOf("."));
            ThemeToggle button = new ThemeToggle(theme, "", "", trimmedIcon);
            btnManager.setOnToggle(toggled -> button.setToggled(Boolean.valueOf(toggled), false));
            button.setLabels(btnManager.getButtonText(), btnManager.getButtonText());
            button.setToggled(Boolean.valueOf(btnManager.isActive()), false);
            button.addToggleListener((unused, toggled) -> {
                btnManager.toggle();
                return true;
            });
            buttonList.add((Object)button);
        }
        buttonList.add((Object)this.buttonCaves);
        buttonList.add((Object)this.buttonNight);
        buttonList.add((Object)this.buttonDay);
        this.mapTypeToolbar = new ThemeToolbar(theme, buttonList);
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderHelper;disableStandardItemLighting()V", shift=At.Shift.BY, by=2)})
    private void navigator$drawCustomTooltip(CallbackInfo ci, @Local List<String> tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.JourneyMap)) {
                if (!(layer instanceof InteractableLayer)) continue;
                InteractableLayer interactableLayer = (InteractableLayer)((Object)layer);
                interactableLayer.drawCustomTooltip(this.getFontRenderer(), this.mx, this.my, this.field_146294_l, this.field_146295_m);
            }
        }
    }

    @Inject(method={"drawScreen"}, at={@At(value="FIELD", opcode=180, target="Ljourneymap/client/ui/fullscreen/Fullscreen;chat:Ljourneymap/client/ui/fullscreen/MapChat;", ordinal=0, shift=At.Shift.BEFORE, remap=false)})
    private void navigator$getLayerTooltip(CallbackInfo ci, @Local LocalRef<List<String>> tooltip) {
        int scaledMouseX = this.mx * this.field_146297_k.field_71443_c / this.field_146294_l;
        int scaledMouseY = this.my * this.field_146297_k.field_71440_d / this.field_146295_m;
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.JourneyMap)) {
            if (!(layer instanceof InteractableLayer)) continue;
            InteractableLayer waypointProviderLayer = (InteractableLayer)((Object)layer);
            waypointProviderLayer.onMouseMove(scaledMouseX, scaledMouseY);
            if (tooltip.get() != null) continue;
            tooltip.set(waypointProviderLayer.getTooltip());
        }
    }

    @Inject(method={"keyTyped"}, at={@At(value="HEAD")}, require=1, cancellable=true)
    private void navigator$onKeyPress(CallbackInfo ci, @Local(argsOnly=true) int keyCode) {
        if (this.chat == null || this.chat.isHidden()) {
            for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.JourneyMap)) {
                InteractableLayer waypointProvider;
                if (!(layer instanceof InteractableLayer) || !(waypointProvider = (InteractableLayer)((Object)layer)).onKeyPressed(keyCode)) continue;
                ci.cancel();
            }
        }
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="RETURN")})
    private void navigator$onGuiClosed(CallbackInfo ci) {
        NavigatorApi.getEnabledLayers(SupportedMods.JourneyMap).forEach(layerManager -> layerManager.onGuiClosed(SupportedMods.JourneyMap));
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Ljourneymap/client/ui/fullscreen/layer/LayerDelegate;onMouseClicked(Lnet/minecraft/client/Minecraft;DDIILjourneymap/client/model/BlockCoordIntPair;I)V", remap=false)})
    private void navigator$mouseClicked(LayerDelegate instance, Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair clickedBlock, int mouseButton, Operation<Void> original) {
        int scaledMouseX = this.mx * mc.field_71443_c / this.field_146294_l;
        int scaledMouseY = this.my * mc.field_71440_d / this.field_146295_m;
        if (!this.navigator$onMapClicked(mouseButton, scaledMouseX, scaledMouseY, clickedBlock)) {
            original.call(new Object[]{instance, mc, mouseX, mouseY, gridWidth, gridHeight, clickedBlock, mouseButton});
        }
    }

    @Unique
    private boolean navigator$onMapClicked(int mouseButton, int mouseX, int mouseY, BlockCoordIntPair blockCoord) {
        if (mouseButton != 0) {
            return false;
        }
        long timestamp = System.currentTimeMillis();
        boolean isDoubleClick = mouseX == this.navigator$oldMouseX && mouseY == this.navigator$oldMouseY && timestamp - this.navigator$timeLastClick < 250L;
        this.navigator$oldMouseX = mouseX;
        this.navigator$oldMouseY = mouseY;
        this.navigator$timeLastClick = timestamp;
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.JourneyMap)) {
            if (!(layer instanceof InteractableLayer)) continue;
            InteractableLayer waypointProviderLayer = (InteractableLayer)((Object)layer);
            return waypointProviderLayer.onMapClick(isDoubleClick, mouseX, mouseY, blockCoord.x, blockCoord.z);
        }
        return false;
    }

    @Unique
    private boolean navigator$shouldRecache(int centerX, int centerZ, int width, int height, LayerManager manager) {
        if (!manager.isLayerActive()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.navigator$oldCenterX != centerX || this.navigator$oldCenterZ != centerZ || this.navigator$oldWidth != width || this.navigator$oldHeight != height || manager.forceRefresh || now - this.navigator$lastRecache >= 1000L) {
            this.navigator$oldCenterX = centerX;
            this.navigator$oldCenterZ = centerZ;
            this.navigator$oldWidth = width;
            this.navigator$oldHeight = height;
            this.navigator$lastRecache = now;
            return true;
        }
        return false;
    }
}

