/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.registry.GameData;
import ic2.core.util.DrawUtil;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderObscurator
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        Block referencedBlock = (Block)GameData.getBlockRegistry().getRaw(nbtData.func_74779_i("referencedBlock"));
        IIcon overlayIcon = RenderObscurator.getOverlayIcon(referencedBlock, nbtData);
        int overlayColor = RenderObscurator.getOverlayColor(referencedBlock);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            DrawUtil.renderIcon(itemStack.func_77954_c(), 16.0, 0.0, 0.0f, 0.0f, -1.0f);
            if (overlayIcon != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GL11.glColor3f((float)((float)(overlayColor >> 16 & 0xFF) / 255.0f), (float)((float)(overlayColor >> 8 & 0xFF) / 255.0f), (float)((float)(overlayColor & 0xFF) / 255.0f));
                DrawUtil.renderIcon(overlayIcon, 2.0, 2.0, 10.0, 10.0, 0.0, 0.0f, 0.0f, -1.0f);
            }
        } else {
            IIcon baseIcon = itemStack.func_77954_c();
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)baseIcon.func_94212_f(), (float)baseIcon.func_94206_g(), (float)baseIcon.func_94209_e(), (float)baseIcon.func_94210_h(), (int)baseIcon.func_94211_a(), (int)baseIcon.func_94216_b(), (float)0.0625f);
            if (overlayIcon != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GL11.glColor3f((float)((float)(overlayColor >> 16 & 0xFF) / 255.0f), (float)((float)(overlayColor >> 8 & 0xFF) / 255.0f), (float)((float)(overlayColor & 0xFF) / 255.0f));
                DrawUtil.renderIcon(overlayIcon, 0.875, 0.875, 0.375, 0.375, 0.001, 0.0f, 0.0f, 1.0f);
                DrawUtil.renderIcon(overlayIcon, 0.875, 0.875, 0.375, 0.375, -0.0635, 0.0f, 0.0f, -1.0f);
            }
        }
    }

    private static IIcon getOverlayIcon(Block referencedBlock, NBTTagCompound nbtData) {
        if (referencedBlock != null) {
            try {
                return referencedBlock.func_149691_a(nbtData.func_74762_e("referencedSide"), nbtData.func_74762_e("referencedMeta"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static int getOverlayColor(Block referencedBlock) {
        if (referencedBlock != null) {
            try {
                return referencedBlock.func_149635_D();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0xFFFFFF;
    }
}

