/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.math.functions;

import com.cleanroommc.modularui.api.IMathValue;
import com.cleanroommc.modularui.utils.math.Constant;

public abstract class Function
implements IMathValue {
    protected IMathValue[] args;
    protected String name;
    protected IMathValue result = new Constant(0.0);

    public Function(IMathValue[] values, String name) throws Exception {
        if (values.length < this.getRequiredArguments()) {
            String message = String.format("Function '%s' requires at least %s arguments. %s are given!", this.getName(), this.getRequiredArguments(), values.length);
            throw new Exception(message);
        }
        for (int i = 0; i < values.length; ++i) {
            this.verifyArgument(i, values[i]);
        }
        this.args = values;
        this.name = name;
    }

    protected void verifyArgument(int index, IMathValue value) {
    }

    @Override
    public void set(double value) {
    }

    @Override
    public void set(String value) {
    }

    public IMathValue getArg(int index) {
        if (index < 0 || index >= this.args.length) {
            throw new IllegalStateException("Index should be within the argument's length range! Given " + index + ", arguments length: " + this.args.length);
        }
        return this.args[index].get();
    }

    public String toString() {
        StringBuilder args = new StringBuilder();
        for (int i = 0; i < this.args.length; ++i) {
            args.append(this.args[i].toString());
            if (i >= this.args.length - 1) continue;
            args.append(", ");
        }
        return this.getName() + "(" + args + ")";
    }

    public String getName() {
        return this.name;
    }

    public int getRequiredArguments() {
        return 0;
    }
}

