/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StandaloneInventory
implements IInventory,
Iterable<ItemStack> {
    private Callback callback;
    private final String name;
    private ItemStack[] contents;

    public StandaloneInventory(int size, String name, IInventory callback) {
        this.name = name;
        this.contents = new ItemStack[size];
        this.callback = callback == null ? null : new InventoryCallback(callback);
    }

    public StandaloneInventory(int size, String name, RailcraftTileEntity callback) {
        this.name = name;
        this.contents = new ItemStack[size];
        this.callback = callback == null ? null : new TileCallback(callback);
    }

    public StandaloneInventory(int size, String name, Callback callback) {
        this.name = name;
        this.contents = new ItemStack[size];
        this.callback = callback;
    }

    public StandaloneInventory(int size, IInventory callback) {
        this(size, null, callback);
    }

    public StandaloneInventory(int size, RailcraftTileEntity callback) {
        this(size, null, callback);
    }

    public StandaloneInventory(int size, String name) {
        this(size, name, (RailcraftTileEntity)null);
    }

    public StandaloneInventory(int size) {
        this(size, null, (RailcraftTileEntity)null);
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.contents[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].field_77994_a <= j) {
                ItemStack itemstack = this.contents[i];
                this.contents[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.contents[i].func_77979_a(j);
            if (this.contents[i].field_77994_a <= 0) {
                this.contents[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        if (this.name != null) {
            return LocalizationPlugin.translate(this.name);
        }
        if (this.callback != null) {
            return this.callback.getInventoryName();
        }
        return this.invTypeName();
    }

    protected String invTypeName() {
        return "Standalone";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        if (this.callback != null) {
            this.callback.markDirty();
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.callback != null) {
            return this.callback.isUseableByPlayer(entityplayer);
        }
        return true;
    }

    public void func_70295_k_() {
        if (this.callback != null) {
            this.callback.openInventory();
        }
    }

    public void func_70305_f() {
        if (this.callback != null) {
            this.callback.closeInventory();
        }
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    public void writeToNBT(String tag, NBTTagCompound data) {
        InvTools.writeInvToNBT(this, tag, data);
    }

    public void readFromNBT(String tag, NBTTagCompound data) {
        InvTools.readInvFromNBT(this, tag, data);
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])this.contents);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    private static class TileCallback
    extends Callback {
        private final RailcraftTileEntity inv;

        public TileCallback(RailcraftTileEntity inv) {
            this.inv = inv;
        }

        @Override
        public void markDirty() {
            this.inv.func_70296_d();
        }

        @Override
        public String getInventoryName() {
            return this.inv.getName();
        }
    }

    private static class InventoryCallback
    extends Callback {
        private final IInventory inv;

        public InventoryCallback(IInventory inv) {
            this.inv = inv;
        }

        @Override
        public boolean isUseableByPlayer(EntityPlayer entityplayer) {
            return this.inv.func_70300_a(entityplayer);
        }

        @Override
        public void openInventory() {
            this.inv.func_70295_k_();
        }

        @Override
        public void closeInventory() {
            this.inv.func_70305_f();
        }

        @Override
        public void markDirty() {
            this.inv.func_70296_d();
        }

        @Override
        public String getInventoryName() {
            return this.inv.func_145825_b();
        }
    }

    public static abstract class Callback {
        public boolean isUseableByPlayer(EntityPlayer entityplayer) {
            return true;
        }

        public void openInventory() {
        }

        public void closeInventory() {
        }

        public void markDirty() {
        }

        public String getInventoryName() {
            return "Standalone";
        }
    }
}

