/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import com.google.common.collect.ForwardingList;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTPlugin {
    public static <T extends NBTBase> NBTList<T> getNBTList(NBTTagCompound nbt, String tag, EnumNBTType type) {
        NBTTagList nbtList = nbt.func_150295_c(tag, type.ordinal());
        return new NBTList(nbtList);
    }

    public static class NBTList<T extends NBTBase>
    extends ForwardingList<T> {
        private final ArrayList<T> backingList;

        public NBTList(NBTTagList nbtList) {
            this.backingList = (ArrayList)ObfuscationReflectionHelper.getPrivateValue(NBTTagList.class, (Object)nbtList, (int)0);
        }

        protected List<T> delegate() {
            return this.backingList;
        }
    }

    public static enum EnumNBTType {
        END(NBTTagEnd.class),
        BYTE(NBTTagByte.class),
        SHORT(NBTTagShort.class),
        INT(NBTTagInt.class),
        LONG(NBTTagLong.class),
        FLOAT(NBTTagFloat.class),
        DOUBLE(NBTTagDouble.class),
        BYTE_ARRAY(NBTTagByteArray.class),
        STRING(NBTTagString.class),
        LIST(NBTTagList.class),
        COMPOUND(NBTTagCompound.class),
        INT_ARRAY(NBTTagIntArray.class);

        public static final EnumNBTType[] VALUES;
        public final Class<? extends NBTBase> classObject;

        private EnumNBTType(Class<? extends NBTBase> c) {
            this.classObject = c;
        }

        public static EnumNBTType fromClass(Class<? extends NBTBase> c) {
            for (EnumNBTType type : VALUES) {
                if (type.classObject != c) continue;
                return type;
            }
            return null;
        }

        static {
            VALUES = EnumNBTType.values();
        }
    }
}

